
#include <routines/stack-c.h>
#include"../interface/common.c"

#define ENV_APP_NUMBER "__kmatplot_app_num__"
#define ENV_AXES_NUMBER "__kmatplot_axes_num__"

/*--------------------------------------------------------------------*/

int appNumber()
 {
  int app_num = 0;
  char *app_num_str = getenv( ENV_APP_NUMBER );
  if ( app_num_str  ) app_num = atoi( app_num_str );
  if ( app_num <= 0 ) app_num = 1;
  return app_num;
 }

/*--------------------------------------------------------------------*/

int axesNumber()
 {
  int axes_num = 0;
  char *axes_num_str = getenv( ENV_AXES_NUMBER );
  if ( axes_num_str  ) axes_num = atoi( axes_num_str );
  if ( axes_num <= 0 ) axes_num = 1;
  return axes_num;
 }

/*--------------------------------------------------------------------*/

void setMatrix( int socket_fd, int dataset, int channel, int rows, int cols, double *data )
  {
   plot_set_channel( socket_fd, axesNumber(), dataset, channel,
		 EDouble, rows, cols,
		 data, 0, rows*sizeof(double), sizeof(double) );	
 }

/*--------------------------------------------------------------------*/

void setAxes( int new_axes_number )
 {
  char buff[50];
  if ( new_axes_number <= 0 ) new_axes_number = 1;
  sprintf( buff, "%d", new_axes_number );
  setenv( ENV_AXES_NUMBER, buff, 1 );
 }

/*---------------------------------------------------------------*/
/*---------------------------------------------------------------*/
/*---------------------------------------------------------------*/

int ksetapp(char *fname)
/*
// Sets a new app number and returns a previous app number.
// If you don't want to change the current app number write:
// current_app = ksetapp(0); // if app is < 1 it won't be changed.
*/
{
  int m;
  int rows;
  int cols;
  int prev_app;
  int curr_app;

  CheckRhs(1,1);
  CheckLhs(1,1);
  GetRhsVar( 1, "i", &rows, &cols, &m );

  prev_app = appNumber();
  curr_app = *istk(m);
  if ( curr_app > 0 ) {
    char buff[50];
    sprintf( buff, "%d", curr_app );
    setenv( ENV_APP_NUMBER, buff, 1 );
    }

  rows = 1; cols = 1;
  CreateVar( 2, "i", &rows, &cols, &m ); *istk(m) = prev_app;
  LhsVar(1) = 2;
  PutLhsVar();
  return(0);
}

/*---------------------------------------------------------------*/

int ksetaxes(char *fname)
{
  int m;
  int rows;
  int cols;
  int prev_plot;
  int curr_plot;

  CheckRhs(1,1);
  CheckLhs(1,1);
  GetRhsVar( 1, "i", &rows, &cols, &m );

  prev_plot = axesNumber();
  curr_plot = *istk(m);
  if ( curr_plot > 0 ) setAxes( curr_plot );

  rows = 1; cols = 1;
  CreateVar( 2, "i", &rows, &cols, &m ); *istk(m) = prev_plot;
  LhsVar(1) = 2;
  PutLhsVar();
  return(0);
}

/*---------------------------------------------------------------*/

int kadd(char *fname)
/*
// Adds a new dataset
//  0 - curve
//  1 - image
//  2 - surface
//  3 - figure
*/
{
  int m;
  int rows;
  int cols;
  int type;
  int dataset_number = -1;

  CheckRhs(1,1);
  CheckLhs(1,1);
  GetRhsVar(1,"i",&rows,&cols,&m);

  type = *istk(m);
  if ( type < 0 || type > 3 ) {
	sciprint("Type must be 0, 1, 2, 3 ."); Error(999);
        return 0;
     } else {
	int socket_fd = plot_connect( appNumber(), NULL, NULL );
	if ( socket_fd == -1 && errno >= 0 ) {
		 sciprint( "Error: %s", strerror(errno) );
		 return 0;
	        }

 	dataset_number = plot_add_dataset( socket_fd, axesNumber(), (PlotType )type );
 	plot_disconnect( socket_fd );
     }

  rows = 1; cols = 1;
  CreateVar( 2, "i", &rows, &cols, &m ); *istk(m) = dataset_number;
  LhsVar(1) = 2;
  PutLhsVar();
  return(0);
 }
/*---------------------------------------------------------------*/

int kaddaxes(char *fname)
{
  int m;
  int rows;
  int cols;
  int type;
  int axes_number = -1;

  CheckRhs(1,1);
  CheckLhs(1,1);
  GetRhsVar(1,"i",&rows,&cols,&m);

  type = *istk(m);
  if ( type < 0 || type > 1 ) {
	sciprint("Type must be 0 for 2d axes or 1 for 3d axes."); Error(999);
        return 0;
     } else {
	int socket_fd = plot_connect( appNumber(), NULL, NULL );
	if ( socket_fd == -1 && errno >= 0 ) {
		 sciprint( "Error: %s", strerror(errno) );
		 return 0;
	        }

 	axes_number = plot_add_axes( socket_fd, type );
 	if ( axes_number > 0 ) setAxes( axes_number );
 	plot_disconnect( socket_fd );
     }

  rows = 1; cols = 1;
  CreateVar( 2, "i", &rows, &cols, &m ); *istk(m) = axes_number;
  LhsVar(1) = 2;
  PutLhsVar();
  return(0);
 }

/*---------------------------------------------------------------*/

int kremoveaxes(char *fname)
/*
// Removes axes:
// axes_id - axes id
*/
{
  int m;
  int rows;
  int cols;
  int axes_number = -1;

  CheckRhs(1,1);
  CheckLhs(1,1);
  GetRhsVar(1,"i",&rows,&cols,&m);

  axes_number = *istk(m);
  if ( axes_number < 0 ) {
	sciprint("Wrong axes id"); Error(999);
        return 0;
     } else {
	int socket_fd = plot_connect( appNumber(), NULL, NULL );
	if ( socket_fd == -1 && errno >= 0 ) {
		 sciprint( "Error: %s", strerror(errno) );
		 return 0;
	        }

 	plot_remove_axes( socket_fd, axes_number );
 	plot_disconnect( socket_fd );
     }

  rows = 1; cols = 1;
  CreateVar( 2, "i", &rows, &cols, &m ); *istk(m) = 1;
  LhsVar(1) = 2;
  PutLhsVar();
  return(0);
 }

/*---------------------------------------------------------------*/

int kremove(char *fname)
/*
// Removes dataset:
// dataset_number - dataset number
*/
{
  int m;
  int rows;
  int cols;
  int dataset_number = -1;

  CheckRhs(1,1);
  CheckLhs(1,1);
  GetRhsVar(1,"i",&rows,&cols,&m);

  dataset_number = *istk(m);
  if ( dataset_number < 0 ) {
	sciprint("Wrong dataset number"); Error(999);
        return 0;
     } else {
	int socket_fd = plot_connect( appNumber(), NULL, NULL );
	if ( socket_fd == -1 && errno >= 0 ) {
		 sciprint( "Error: %s", strerror(errno) );
		 return 0;
	        }

 	plot_remove_dataset( socket_fd, axesNumber(), dataset_number );
 	plot_disconnect( socket_fd );
     }

  rows = 1; cols = 1;
  CreateVar( 2, "i", &rows, &cols, &m ); *istk(m) = 1;
  LhsVar(1) = 2;
  PutLhsVar();
  return(0);
 }

/*---------------------------------------------------------------*/

int kremoveall(char *fname)
/*
// Removes all datasets:
// no arguments
*/
{
  int m;
  int rows;
  int cols;
  int socket_fd;

  CheckRhs(0,0);
  CheckLhs(1,1);
  /*GetRhsVar(1,"i",&rows,&cols,&m);*/

  socket_fd = plot_connect( appNumber(), NULL, NULL );
  if ( socket_fd == -1 && errno >= 0 ) {
		 sciprint( "Error: %s", strerror(errno) );
		 return 0;
	        }

  plot_remove_all_datasets( socket_fd, axesNumber() );
  plot_disconnect( socket_fd );

  rows = 1; cols = 1;
  CreateVar( 1, "i", &rows, &cols, &m ); *istk(m) = 1;
  LhsVar(1) = 1;
  PutLhsVar();
  return(0);
 }

/*---------------------------------------------------------------*/

int ksetmatrix(char *fname)
/*
// Set channel data.
// ksetmatrix( dataset, channel_number, matrix );
*/
 {
  int m;
  int rows;
  int cols;
  int chan;
  int dataset_number;
  int socket_fd;

  CheckRhs(3,3);
  CheckLhs(1,1);

  GetRhsVar(1,"i",&rows,&cols,&m);
  dataset_number = *istk(m);
  if ( dataset_number < 0 ) {
     sciprint("Wrong dataset number !"); Error(999);
     return 0;
    }

  GetRhsVar(2,"i",&rows,&cols,&m);
  chan = *istk(m);
  if ( chan < 0 ) {
     sciprint("Wrong channel number !"); Error(999);
     return 0;
    }

  GetRhsVar(3,"d",&rows,&cols,&m);
  socket_fd = plot_connect( appNumber(), NULL, NULL );
  if ( socket_fd == -1 && errno >= 0 ) {
	sciprint( "Error: %s", strerror(errno) );
	return 0;
	}
	
  setMatrix( socket_fd, dataset_number, chan, rows, cols, stk(m) );
  plot_disconnect( socket_fd );

  rows = 1; cols = 1;
  CreateVar( 4, "i", &rows, &cols, &m ); *istk(m) = 1;
  LhsVar(1) = 4;
  PutLhsVar();
  return(0);
 }

/*---------------------------------------------------------------*/

static TabF Tab[]={
  {ksetapp,    "ksetapp"},
  {ksetaxes,   "ksetaxes"},
  {kaddaxes,   "kaddaxes"},
  {kremoveaxes,"kremoveaxes"},
  {kadd,       "kadd"},
  {kremove,    "kremove" },
  {ksetmatrix, "ksetmatrix"},
  {kremoveall, "kremoveall"}

};


int C2F(plots)()
{
  Rhs = Max(0, Rhs);
  (*(Tab[Fin-1].f))(Tab[Fin-1].name);
  return 0;
}


/*---------------------------------------------------------------*/



