/***************************************************************************
                                  qsctools.h
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSCANVASSTDTOOLS_H
#define QSCANVASSTDTOOLS_H

#include"widgets/qscoord.h"
#include"widgets/qsctool.h"
#include<qlist.h>

class QLabel;
class QSDrvQt;
class QSCLabel;
class QSCArrow;
class QSCRect;
class QSCObject;
class QSAxes;

//-------------------------------------------------------------//

class QSToolLabel : public QSTool
  {
   	Q_OBJECT
   public:
    QSToolLabel( QObject *parent = NULL );
    virtual ~QSToolLabel();
    void activate( QSPlotView *parent );
    void deactivate();

  protected:
    void canvasClicked( const QPoint& pos, int );
  };


//-------------------------------------------------------------//

class KMatplotShell;
class KSCmdTransformCObjects;
class QSToolSelect : public QSTool
  {
   	Q_OBJECT
   public:
	QSToolSelect( KMatplotShell *shell, QObject *parent = NULL );
	virtual ~QSToolSelect();
	void activate( QSPlotView *parent );
	void deactivate();
	void draw();

   protected:
	virtual void canvasMiddleButtonClicked( const QPoint& pos, int );
	virtual void canvasClicked( const QPoint& pos, int );
	virtual bool canvasDragStart( const QPoint& pos, int );
	virtual void canvasDragMove( const QPoint& pos, const QPoint& prevPos, const QPoint& startPos, int, int, int );
	virtual void canvasDragEnd( const QPoint& pos, const QPoint& startPos, int, int );
	virtual void canvasMove( const QPoint& pos );
	bool eventMousePress( QMouseEvent* e );

   private slots:
	void slot_selection_changed();

   private:
	enum State { StateNormal, StateRotate } m_state;
	KMatplotShell   *m_shell;

	KSCmdTransformCObjects *m_transform_cmd;
	void create_transform_cmd();
	void move_selected_by( const QPoint& mouseShift, int keyState );

	class Handle;
	QList<Handle> m_handles;
        void make_new_handles();
	void show_handles();
	void hide_handles();
	void paint_handles();
	Handle *handle_at( const QPoint& pos );
	bool m_handles_visible;
 	Handle *m_drag_handle;
	QSPt2f  m_move_prev_d;
	void drag_resize_handle_by( const QPoint& mouseShift, int keyState, Handle *handle ) ;
	void drag_rotate_handle( const QPoint& startPos, const QPoint& currPos, int keyState, Handle *handle ) ;

	QSCObject *m_drag_object;
        QSCObject *selected_at( const QPoint& pos );
 	void paint_object( QSCObject* object );
	void paint_selected_objects();

	void paint_frame( const QPoint& p1, const QPoint& p2 );
	int angle( const QSPt2f& rcenter, const QPoint& click_pos, const QPoint& mouse_pos );
  };

//-------------------------------------------------------------//

class QSToolZoom : public QSTool
  {
   	Q_OBJECT
   public:
	QSToolZoom( QObject *parent = NULL );
	~QSToolZoom();
	void activate( QSPlotView *parent );
	void deactivate();
	void draw();

   protected:
	bool canvasDragStart( const QPoint& pos, int keyState );	
	void canvasDragMove( const QPoint& pos, const QPoint& prevPos, const QPoint& startPos, int keyState, int, int );
	void canvasDragEnd( const QPoint& pos, const QPoint& startPos, int keyState, int );
	void canvasRightButtonClicked( const QPoint& pos, int keyState );
	void canvasDoubleClicked(  const QPoint& pos, int keyState );
	void canvasMove( const QPoint& pos );

  private:
	QSAxes *m_active_axes;
	QSPt3f p1;
	QSPt3f p2;
	bool erase_crossmark;
	enum Plane { PlaneXY =0, PlaneXZ =1, PlaneYZ =2 } plane;
	bool find_plane( const QPoint& canvas_pos );
	QSPt3f world_point( const QPoint& canvas_pos );
	void draw_frame();
	QString message( const QSPt3f& p );
	void draw_crossmark( const QSPt3f& pos );
	void zoom_out( const QPoint& click_pos );
	void zoom_in( const QSPt3f& p1, const QSPt3f& p2 );
 };

//-------------------------------------------------------------//

class QSToolArrow : public QSTool
  {
   	Q_OBJECT
   public:
	QSToolArrow( QObject *parent = NULL );
	~QSToolArrow();
	void activate( QSPlotView *parent );
	void deactivate();
	void draw();

   protected:
	bool canvasDragStart( const QPoint& pos, int keyState );
	void canvasDragMove( const QPoint& pos, const QPoint& prevPos, const QPoint& startPos, int keyState, int, int );
	void canvasDragEnd( const QPoint& pos, const QPoint& startPos, int keyState, int );
  	
  private:
     	void paint_object();
	QSCArrow *m_new_object;
 };

//-------------------------------------------------------------//


class QSToolRect : public QSTool
  {
	Q_OBJECT
   public:
	QSToolRect( QObject *parent = NULL );
	~QSToolRect();
	void activate( QSPlotView *parent );
	void deactivate();
	void draw();

   protected:
	bool canvasDragStart( const QPoint& pos, int );
	void canvasDragMove( const QPoint& pos, const QPoint& prevPos, const QPoint& startPos, int, int, int );
	void canvasDragEnd( const QPoint& pos, const QPoint& startPos, int, int );
  	
  private:
     	void paint_object();
	QSCRect *m_new_object;
 };

//-------------------------------------------------------------//

class QSToolLocate : public QSTool
 {
	Q_OBJECT
  public:
	QSToolLocate( QObject *parent = NULL );
       ~QSToolLocate();
	void activate( QSPlotView *parent );
	void deactivate();
	void draw();

  protected:
	void canvasClicked( const QPoint& pos, int );
	void canvasMove( const QPoint& pos );
	void canvasRightButtonClicked( const QPoint& pos, int );
  private:
	QLabel *m_popup;
	QString m_info;
	QPoint  m_pos;
	QSRectf m_locate_area;
	void draw_info( bool show_popup = true );	
 };

#endif

