/***************************************************************************
                            qscobjects.h
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef QSCOBJECTS_H
#define QSCOBJECTS_H

#include"widgets/qscoord.h"
#include"widgets/qsgattr.h"
#include"widgets/qscobject.h"
#include<qstring.h>

//-----------------------------------------------------------------------//

/**
  * Draw a simple text on a canvas.
  * @author Kamil Dobkowski
  */
class QSCLabel : public QSCObject
 {
  Q_OBJECT
	Q_PROPERTY( int textAlign READ textAlign WRITE setTextAlign )
	Q_PROPERTY( int frameAlign READ frameAlign WRITE setFrameAlign )
	Q_PROPERTY( int angle READ angle WRITE setAngle )
	Q_PROPERTY( QString text READ text WRITE setText )
	Q_PROPERTY( double posX READ posX WRITE setPosX )
	Q_PROPERTY( double posY READ posY WRITE setPosY )
	Q_PROPERTY( double posZ READ posZ WRITE setPosZ )
	Q_PROPERTY( int coordX READ coordX WRITE setCoordX )
	Q_PROPERTY( int coordY READ coordY WRITE setCoordY )
 	Q_PROPERTY( int coordZ READ coordZ WRITE setCoordZ )
	Q_PROPERTY( QString font READ fontProperty WRITE setFontProperty )
	Q_PROPERTY( QString fill READ fillProperty WRITE setFillProperty )
        Q_PROPERTY( QString frame READ frameProperty WRITE setFrameProperty )
	Q_PROPERTY( QString shadowFill READ shadowFillProperty WRITE setShadowFillProperty )
	Q_PROPERTY( int shadowPosX READ shadowPosX WRITE setShadowPosX )
	Q_PROPERTY( int shadowPosY READ shadowPosY WRITE setShadowPosY )
	
  public:
	QSCLabel( const QString& text=QString::null, QObject *parent=NULL );
	~QSCLabel();

	int style() { return Rotateable | Moveable; }
	void insertString( int pos, const QString& s );
	void deleteString( int pos, int len );
	void setCursorHint( int pos );
	int cursorHint() const { return m_cursor; }

	void draw( QSDrv *drv, bool blocking=true, bool transparent=true );
	void setBox( const QSRectf& r, QSDrv *drv );
	void rotate( int deg, QSDrv *drv );
	QSPt2f rCenter( QSDrv *drv );
	QSRectf box( QSDrv *drv );
	QString name();

	void setEditMode( bool enabled );
	bool editMode() const { return m_edited; }

	void setText( const QString& text );
	QString text() const { return m_text; }
	void setAngle( int angle );
	int angle() const { return m_angle; }
	void setFrameAlign( int align );
	int frameAlign() const { return m_frame_align; }
	void setTextAlign( int align );
	int textAlign() const { return m_text_align; }
	void setPos( const QSPt3f& pos );
	void setPosX( double value );
	void setPosY( double value );
	void setPosZ( double value );	
	QSPt3f pos() const { return m_pos; }
	double posX() const { return m_pos.x; }
	double posY() const { return m_pos.y; }
	double posZ() const { return m_pos.z; }	
	void setCoord( const QSPt3& coordSystem );
	void setCoordX( int coordSystem );
	void setCoordY( int coordSystem );	    	
	void setCoordZ( int coordSystem );
	QSPt3 coord() const { return m_axis; }
	int coordX() const { return m_axis.x; }
	int coordY() const { return m_axis.y; }
	int coordZ() const { return m_axis.z; }
	void setFont( const QSGFont& font );
        void setFontProperty( const QString& data );
	QSGFont font() const { return m_font; }
	QString fontProperty() const { return toQString(m_font); }
	void setFill( const QSGFill& fill );
	void setFillProperty( const QString &data );
	QSGFill fill() const { return m_fill; }
	QString fillProperty() const { return toQString(m_fill); }
	void setFrame( const QSGLine& line );
	void setFrameProperty( const QString& data );
	QSGLine frame() const { return m_frame; }
	QString frameProperty() const { return toQString(m_frame); }
	void setShadowFill( const QSGFill& fill );
	void setShadowFillProperty( const QString& data );
	QSGFill shadowFill() const { return m_shadow_fill; }
	QString shadowFillProperty() const { return toQString(m_shadow_fill); }
	void setShadowPos( const QSPt2& shift );
	void setShadowPosX( int shift );
	void setShadowPosY( int shift );		
	QSPt2 shadowPos() const { return m_shadow_pos; }
	int shadowPosX() const { return m_shadow_pos.x; }
	int shadowPosY() const { return m_shadow_pos.y; }

  protected:
	int m_text_align;
	int m_frame_align;
	int m_angle;
	QSPt3f  m_pos;
	QSPt3   m_axis;
	QString m_text;
	QSGFill m_fill;
	QSGLine m_frame;
	QSGFont m_font;
	QSPt2   m_shadow_pos;
	QSGFill m_shadow_fill;
	int  m_cursor;
	bool m_edited;
 };


//-----------------------------------------------------------------------//

/**
  * Draw an arrow on a canvas.
  * @author Kamil Dobkowski
  */
class QSCArrow : public QSCObject {
  Q_OBJECT
	Q_PROPERTY( double originX READ originX WRITE setOriginX  )
	Q_PROPERTY( double originY READ originY WRITE setOriginY  )
	Q_PROPERTY( double originZ READ originZ WRITE setOriginZ  )
	Q_PROPERTY( double endX READ endX WRITE setEndX )
	Q_PROPERTY( double endY READ endY WRITE setEndY )
	Q_PROPERTY( double endZ READ endZ WRITE setEndZ )
	Q_PROPERTY( int originCoordX READ originCoordX WRITE setOriginCoordX )
	Q_PROPERTY( int originCoordY READ originCoordY WRITE setOriginCoordY )	
	Q_PROPERTY( int originCoordZ READ originCoordZ WRITE setOriginCoordZ )
	Q_PROPERTY( int endCoordX READ endCoordX WRITE setEndCoordX )
	Q_PROPERTY( int endCoordY READ endCoordY WRITE setEndCoordY )
	Q_PROPERTY( int endCoordZ READ endCoordZ WRITE setEndCoordZ )
	Q_PROPERTY( QString originArrow READ originArrowProperty WRITE setOriginArrowProperty )
	Q_PROPERTY( QString originPoint READ originPointProperty WRITE setOriginPointProperty )
	Q_PROPERTY( QString endArrow READ endArrowProperty WRITE setEndArrowProperty )
	Q_PROPERTY( QString endPoint READ endPointProperty WRITE setEndPointProperty )
	Q_PROPERTY( QString line READ lineProperty WRITE setLineProperty )

  public:
	QSCArrow( QObject *parent=NULL );
	~QSCArrow();
	int style() { return Resizeable | Moveable; }

	void draw( QSDrv *drv, bool blocking=true, bool transparent=true );
	bool isHit(  const QSPt2f &p, QSDrv* drv );
	void setBox( const QSRectf& r, QSDrv *drv );	
	void rotate( int deg, QSDrv *drv );
	QSPt2f rCenter( QSDrv *drv );
	QSRectf box( QSDrv *drv );
	QString name() { return tr("Arrow"); }
	void setEditMode( bool enabled );
	bool editMode() const { return !m_visible; }

	void setOriginPos( const QSPt3f& pos );
	void setOriginX( double x );
	void setOriginY( double y );	
	void setOriginZ( double z );
	QSPt3f originPos() const { return m_end1; }
	double originX() const { return m_end1.x; }
	double originY() const { return m_end1.y; }
	double originZ() const { return m_end1.z; }

	void setEndPos( const QSPt3f& pos );
	void setEndX( double x );
	void setEndY( double y );	
	void setEndZ( double z );
	QSPt3f endPos() const { return m_end2; }
	double endX() const { return m_end2.x; }
	double endY() const { return m_end2.y; }
	double endZ() const { return m_end2.z; }

 	void setOriginCoord( const QSPt3& coordSystem );
	void setOriginCoordX( int coordSystem );
	void setOriginCoordY( int coordSystem );	    	
	void setOriginCoordZ( int coordSystem );
	QSPt3 originCoord() const { return m_axis1; }
	int originCoordX() const { return m_axis1.x; }
	int originCoordY() const { return m_axis1.y; }
	int originCoordZ() const { return m_axis1.z; }

 	void setEndCoord( const QSPt3& coordSystem );
	void setEndCoordX( int coordSystem );
	void setEndCoordY( int coordSystem );	    	
	void setEndCoordZ( int coordSystem );
	QSPt3 endCoord() const { return m_axis2; }
	int endCoordX() const { return m_axis2.x; }
	int endCoordY() const { return m_axis2.y; }
	int endCoordZ() const { return m_axis2.z; }

	void setOriginArrow( const QSGArrow& arrow );
	void setOriginArrowProperty( const QString& data );
	QSGArrow originArrow() const { return m_end1style; }
	QString originArrowProperty() const { return toQString(m_end1style); }

 	void setOriginPoint( const QSGPoint& point );
	void setOriginPointProperty( const QString& data );
	QSGPoint originPoint() const { return m_end1point; }
	QString originPointProperty() const { return toQString(m_end1point); }

	void setEndArrow( const QSGArrow& arrow );
	void setEndArrowProperty( const QString& data );
	QSGArrow endArrow() const { return m_end2style; }
	QString endArrowProperty() const { return toQString(m_end2style); }

 	void setEndPoint( const QSGPoint& point );
	void setEndPointProperty( const QString& data );
	QSGPoint endPoint() const { return m_end2point; }
	QString endPointProperty() const { return toQString(m_end2point); }	

	void setLine( const QSGLine& line );
	void setLineProperty( const QString& data );
	QSGLine line() const { return m_line; }
	QString lineProperty() const { return toQString(m_line); }

   protected:
	QSPt3f m_end1;
	QSPt3f m_end2;
	QSPt3 m_axis1;
	QSPt3 m_axis2;
	bool m_visible;
	QSGArrow m_end1style;
	QSGArrow m_end2style;
	QSGPoint m_end1point;
	QSGPoint m_end2point;
	QSGLine m_line;;
   };

//-----------------------------------------------------------------------//

/**
  * Draw an ellipse on a canvas.
  * @author Kamil Dobkowski
  */
class QSCRect : public QSCObject {
  Q_OBJECT
	Q_PROPERTY( double originX READ originX WRITE setOriginX  )
	Q_PROPERTY( double originY READ originY WRITE setOriginY  )
	Q_PROPERTY( double originZ READ originZ WRITE setOriginZ  )
	Q_PROPERTY( double endX READ endX WRITE setEndX )
	Q_PROPERTY( double endY READ endY WRITE setEndY )
	Q_PROPERTY( double endZ READ endZ WRITE setEndZ )
	Q_PROPERTY( int originCoordX READ originCoordX WRITE setOriginCoordX )
	Q_PROPERTY( int originCoordY READ originCoordY WRITE setOriginCoordY )	
	Q_PROPERTY( int originCoordZ READ originCoordZ WRITE setOriginCoordZ )
	Q_PROPERTY( int endCoordX READ endCoordX WRITE setEndCoordX )
	Q_PROPERTY( int endCoordY READ endCoordY WRITE setEndCoordY )
	Q_PROPERTY( int endCoordZ READ endCoordZ WRITE setEndCoordZ )
	Q_PROPERTY( QString shadowFill READ shadowFillProperty WRITE setShadowFillProperty )
	Q_PROPERTY( int shadowPosX READ shadowPosX WRITE setShadowPosX )
	Q_PROPERTY( int shadowPosY READ shadowPosY WRITE setShadowPosY )
	Q_PROPERTY( QString fill READ fillProperty WRITE setFillProperty )
	Q_PROPERTY( QString frame READ frameProperty WRITE setFrameProperty )
        Q_PROPERTY( bool ellipse READ ellipse WRITE setEllipse )
	
  public:
     	QSCRect( QObject *parent=NULL );
    	~QSCRect();
	
	void setEllipse( bool ellipse );
	bool ellipse() const { return m_ellipse; }

	void setOriginPos( const QSPt3f& pos );
	void setOriginX( double x );
	void setOriginY( double y );	
	void setOriginZ( double z );
	QSPt3f originPos() const { return m_end1; }
	double originX() const { return m_end1.x; }
	double originY() const { return m_end1.y; }
	double originZ() const { return m_end1.z; }

	void setEndPos( const QSPt3f& pos );
	void setEndX( double x );
	void setEndY( double y );	
	void setEndZ( double z );
	QSPt3f endPos() const { return m_end2; }
	double endX() const { return m_end2.x; }
	double endY() const { return m_end2.y; }
	double endZ() const { return m_end2.z; }

 	void setOriginCoord( const QSPt3& coordSystem );
	void setOriginCoordX( int coordSystem );
	void setOriginCoordY( int coordSystem );	    	
	void setOriginCoordZ( int coordSystem );
	QSPt3 originCoord() const { return m_axis1; }
	int originCoordX() const { return m_axis1.x; }
	int originCoordY() const { return m_axis1.y; }
	int originCoordZ() const { return m_axis1.z; }

 	void setEndCoord( const QSPt3& coordSystem );
	void setEndCoordX( int coordSystem );
	void setEndCoordY( int coordSystem );	    	
	void setEndCoordZ( int coordSystem );
	QSPt3 endCoord() const { return m_axis2; }
	int endCoordX() const { return m_axis2.x; }
	int endCoordY() const { return m_axis2.y; }
	int endCoordZ() const { return m_axis2.z; }

	void setFrame( const QSGLine& line );
	void setFrameProperty( const QString& data );
	QSGLine frame() const { return m_frame; }
	QString frameProperty() const { return toQString(m_frame); }

 	void setFill( const QSGFill& fill );
	void setFillProperty( const QString &data );
	QSGFill fill() const { return m_fill; }
	QString fillProperty() const { return toQString(m_fill); }

	void setShadowFill( const QSGFill& fill );
	void setShadowFillProperty( const QString& data );
	QSGFill shadowFill() const { return m_shadow_fill; }
	QString shadowFillProperty() const { return toQString(m_shadow_fill); }
	void setShadowPos( const QSPt2& shift );
	void setShadowPosX( int shift );
	void setShadowPosY( int shift );		
	QSPt2 shadowPos() const { return m_shadow_pos; }
	int shadowPosX() const { return m_shadow_pos.x; }
	int shadowPosY() const { return m_shadow_pos.y; }

	void draw( QSDrv *drv, bool blocking=true, bool transparent=true );
    	int style() { return Resizeable | Moveable; }
	void setBox( const QSRectf& r, QSDrv *drv );
        bool isHit( const QSPt2f &p, QSDrv* drv );
	QSRectf box( QSDrv *drv );
      	QString name() { return m_ellipse ? tr("Ellipse") : tr("Rectangle"); }

  protected:
	bool m_ellipse;
	QSPt3f m_end1;
	QSPt3f m_end2;
   	QSPt3 m_axis1;
   	QSPt3 m_axis2;
	QSGFill m_fill;
     	QSGLine m_frame;
        QSPt2  m_shadow_pos;
	QSGFill m_shadow_fill;
   };

#endif

