/***************************************************************************
                                  kremove.cpp
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
#include <iostream.h>
#include <errno.h>
#include "octave-common.h"

//------------------------------------------------------------------//

DEFUN_DLD (kremove, args, ,
" usage: kremove(dataset_number)\n"
"\n"
"Removes a dataset from a plot.\n"
"See also: kadd, kremoveall, ksetapp, ksetaxes, kaddaxes, kremoveaxes, kplot, kimage, kcontour, kmesh, ksetmatrix\n" )
{
 int dataset_number = (int )args(0).double_value();
 if ( dataset_number < 0  ) {
      	error("Invalid dataset number.");
     } else {
      	int socket_fd = plot_connect( appNumber(), NULL, NULL );
      	if ( socket_fd == -1 && errno < sys_nerr && errno >= 0 ) {
			 error( sys_errlist[errno] );
			 return octave_value_list();
		  	}
	plot_remove_dataset( socket_fd, axesNumber(), dataset_number );
	plot_disconnect( socket_fd );
     }
 return octave_value_list();
}

