/***************************************************************************
                                  main.cpp
                             -------------------
    begin                : nie mar  5 14:43:31 CET 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>	// open, dup2
#include <fcntl.h>
#include <qapplication.h>
#include "kssocketio.h"
#include "kmatplotshell.h"
#include "ksglobalsettings.h"
#include "widgets/qsgattr.h"
#include "formula/mpformula.h"
#include "formula/mpsymbols.h"

#define STDOUT_FD 1
#define STDERR_FD 2

KSSocketIO *kmatplot_socket = NULL;

int main(int argc, char *argv[])
 {
  QApplication app( argc, argv );

  // load global settings
  KSGlobalSettings::load();
  KSGlobalSettings::apply();

 // load all formula modules
  MPFormula::addGlobalSymbols( new MPCommonSymFactory() );

  // initialize socket
  if ( KSGlobalSettings::openSocket() ) kmatplot_socket = new KSSocketIO();
  QCString option_fd;
  for( int i=1; i<app.argc()-1; i++ ) {
	if ( QCString(app.argv()[i]) == "--fd" ) option_fd = app.argv()[i+1];
	}
  if ( !option_fd.isEmpty() ) {
	if ( !kmatplot_socket ) kmatplot_socket = new KSSocketIO();
	// send stdout and stderr to /dev/null ...
	int null_fd = open("/dev/null",O_WRONLY);
	dup2( null_fd, STDOUT_FD );
	dup2( null_fd, STDERR_FD );
	// bind to open socket ( socket is opened before parent process forked )
	// see interface/common.c
	kmatplot_socket->setFileDescriptor( option_fd.toUInt() );	
	}

  // create the main window
  KMatplotShell *shell = new KMatplotShell();

  // load file if providen in a commandline
  if ( app.argc() == 2 ) shell->openFile( app.argv()[1] );

  // run the app
  shell->show();
  app.setMainWidget(shell);
  int result = app.exec();
  delete kmatplot_socket;
  return result;
 }
