/***************************************************************************
                               kswinpageview.h
                             -------------------
    begin                : Thu Jan 17 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSWINPAGEVIEW_H
#define KSWINPAGEVIEW_H

#include <qwidget.h>
#include "ksworkspace.h"

class KSWorkbook;
class KSCmdSetRanges;
class KSCmdSetProperties;
class KMatplotShell;
class QSPlotView;
class QSData;

/**
  *@author kamil
  */
class KSWinPageView : public KSWorkspaceWindow  {
   	Q_OBJECT
  public:
	KSWinPageView(  KSWorkspace *workspace );
	virtual ~KSWinPageView();
	QSPlotView *view() const;
	virtual void cut();
	virtual void copy();
	virtual void copyAll();
	virtual void paste();
	virtual void del();
	virtual void activated();
	virtual void deactivated();
	virtual void doAction( QAction* /*action*/ );
	virtual QWidget *createObjectPanel( QWidget *parent );
	virtual QWidget *createPropertyPanel( QWidget *parent );
  protected:
	QSPlotView *m_view;
	KSWorkbook *m_workbook;
	KMatplotShell *m_shell;
	QSData *m_curr_dataset;
	KSCmdSetRanges		*m_curr_ranges_cmd;
	KSCmdSetProperties	*m_curr_properties_cmd;
	bool m_apply_button;
        bool check_axes();
	void update_actions();

  protected slots:
	void slot_show_page_popup();
	void slot_curr_page_changed();
	void slot_view_slider_pressed();
	void slot_view_slider_released();
	void slot_view_scrollbar_pressed();
	void slot_view_scrollbar_released();
	void slot_selection_changed();
	void slot_selected_object_changed();
	void slot_active_axes_changed();

 	void slotDeletePage();
	void slotRenamePage();
	void slotPageToFront();
	void slotPageToBack();
	void slotRaisePage();
	void slotLowerPage();
	void slotExportPicture();

	void slotWizard();
	void slotNewAxes2D();
	void slotNewAxes3D();
	void slotNewCurve();
	void slotNewImage();
	void slotNewContour();
	void slotNewNGContour();
	void slotNewSurface();
	void slotNewFigure();
	void slotNewXAxis();
	void slotNewYAxis();
	void slotNewZAxis();
	void slotNewVAxis();
	void slotDatasets();
 	void slotNewLegend();

	void slotBringToFront();
	void slotSendToBack();
	void slotRaise();
	void slotLower();
	void slotGrid();
	void slotGroup();
	void slotUngroup();

	void slotHideSliders();
	void slotHideRulers();
	void slotShowFullPage();

	void slotIOInfo();

	void slotPageZoom();
        void slotToolArrow();
        void slotToolLabel();
        void slotToolLocate();
        void slotToolRect();
        void slotToolSelect();

        void slotToolZoom();

	void slotApplyButton();
	void slotObjectMenu();
	void slotX11Backstoring();

	void slotCutDataset();
	void slotCopyDataset();
	void slotCopyAllDataset();
	void slotPasteDataset();
	void slotDeleteDataset();
	void slotRaiseDataset();
	void slotLowerDataset();
	void slotBringDatasetToFront();
	void slotSendDatasetToBack();

	void slot_page_title_changed( const QString& newTitle );
	void slot_set_current_dataset( QSData *dataset );
};

#endif
