/***************************************************************************
                          kswinpageview.cpp  -  description
                             -------------------
    begin                : Thu Jan 17 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kswinpageview.h"

#include "kspanelmanager.h"
#include "ksobjectfactory.h"
#include "kscommands.h"
#include "kssocketio.h"
#include "kmatplotshell.h"
#include "ksmatrix.h"
#include "qscobjects.h"
#include "qsctools.h"

#include "ksworksheetdlg.h"
#include "widgets/qsgattr.h"
#include "widgets/qsplotview.h"
#include "widgets/qsaxes2d.h"
#include "widgets/qsaxes3d.h"
#include "widgets/qscurve.h"
#include "widgets/qsimage.h"
#include "widgets/qscontour.h"
#include "widgets/qssurface.h"
#include "widgets/qsfigure.h"
#include "widgets/qsclegend.h"
#include "widgets/qsplotview.h"

#include "formula/mpformula.h"
#include "formula/mpsymbols.h"
#include "dialogs/ksdatasetdlg.h"
#include "dialogs/ksobjecttreedlg.h"
#include "dialogs/ksexportpicturedlg.h"
#include "dialogs/ksgriddlg.h"
#include "dialogs/ksgraphwizard.h"

#include "pixmaps/action_red.xpm"

#include <qpixmap.h>
#include <qaction.h>
#include <qpopupmenu.h>
#include <qinputdialog.h>
#include <qmessagebox.h>
#include <qcursor.h>

// see main.cpp
extern KSSocketIO *kmatplot_socket;

//--------------------------------------------------------------------------//

KSWinPageView::KSWinPageView( KSWorkspace *workspace )
: KSWorkspaceWindow( workspace, tr("Page view"), QPixmap(action_red) )
 {
  m_curr_dataset = NULL;

  m_shell = workspace->shell();
  m_workbook = m_shell->workbook();
  m_curr_ranges_cmd = NULL;
  m_curr_properties_cmd = NULL;
  m_apply_button = false;

  m_view = new QSPlotView(this);
  m_view->setWorkbook( m_workbook );
  m_view->setZoom( 0.75 );
  m_view->setTool( new QSToolSelect(m_shell) );

  setContents( m_view );
  connect( m_view->selection(), SIGNAL(sigListChanged()), this, SLOT(slot_selection_changed()) );
  connect( m_view, SIGNAL(sigActiveObjectChanged()), this, SLOT(slot_selected_object_changed()) );
  connect( m_view, SIGNAL(sigActiveAxesChanged()), this, SLOT(slot_active_axes_changed()) );
  connect( m_view, SIGNAL(sigPageBarClicked()), this, SLOT(slot_show_page_popup()) );
  connect( m_view, SIGNAL(sigCurrentPageChanged()), this, SLOT(slot_curr_page_changed()) );
  connect( m_view, SIGNAL(sigSliderPressed()), this, SLOT(slot_view_slider_pressed()) );
  connect( m_view, SIGNAL(sigSliderReleased()), this, SLOT(slot_view_slider_released()) );
  connect( m_view, SIGNAL(sigScrollBarPressed()), this, SLOT(slot_view_scrollbar_pressed()) );
  connect( m_view, SIGNAL(sigScrollBarReleased()), this, SLOT(slot_view_scrollbar_released()) );
  connect( m_view, SIGNAL(sigCurrentPageTitleChanged(const QString&)), this, SLOT(slot_page_title_changed(const QString&)) );
 }

//--------------------------------------------------------------------------//

KSWinPageView::~KSWinPageView()
 {
  delete m_curr_properties_cmd;
  delete m_curr_ranges_cmd;
 }

//--------------------------------------------------------------------------//

QSPlotView *KSWinPageView::view() const
 {
  return m_view;
 }

//--------------------------------------------------------------------------//

void KSWinPageView::activated()
 {
  m_shell->disableCustomActions();
  // page commands, export picture
  slot_curr_page_changed();
  // enable cut delete etc if there is selection
  slot_selection_changed();
  // enable insert xaxis, legend, edit_datasets
  slot_active_axes_changed();

  m_shell->m_paste->setEnabled( TRUE );

  m_shell->m_object_menu->setEnabled( TRUE );

  m_shell->m_tools->setEnabled( TRUE );
  m_shell->m_zoom->setEnabled( TRUE );
  m_shell->m_grid->setEnabled( TRUE );
  m_shell->m_ioinfo->setEnabled( TRUE );

  m_shell->m_hide_sliders->setEnabled( TRUE );
  m_shell->m_apply_button->setEnabled( TRUE );
  m_shell->m_hide_rulers->setEnabled( TRUE );
  m_shell->m_x11_backstoring->setEnabled( TRUE );
  m_shell->m_show_full_page->setEnabled( TRUE );

  // set a propert tool, zoom, settings, etc.
  update_actions();
 }

//------------------------------------------------------------//

void KSWinPageView::deactivated()
 {
 }

//-----------------------------------------------------------//

void KSWinPageView::update_actions()
 {
  if ( dynamic_cast<QSToolZoom*>(m_view->tool()) ) m_shell->m_tool_zoom->setOn( TRUE );
  else
  if ( dynamic_cast<QSToolLocate*>(m_view->tool()) ) m_shell->m_tool_locate->setOn( TRUE );
  else
  if ( dynamic_cast<QSToolSelect*>(m_view->tool()) ) m_shell->m_tool_select->setOn( TRUE );
  else
  if ( dynamic_cast<QSToolLabel*>(m_view->tool()) ) m_shell->m_tool_label->setOn( TRUE );
  else
  if ( dynamic_cast<QSToolArrow*>(m_view->tool()) ) m_shell->m_tool_arrow->setOn( TRUE );
  else
  if ( dynamic_cast<QSToolRect*>(m_view->tool()) ) m_shell->m_tool_rect->setOn( TRUE );
  else {
	m_shell->m_tool_locate->setOn( FALSE );
	m_shell->m_tool_select->setOn( FALSE );
	m_shell->m_tool_label->setOn( FALSE );
	m_shell->m_tool_arrow->setOn( FALSE );
	m_shell->m_tool_rect->setOn( FALSE );
	m_shell->m_tool_zoom->setOn( FALSE );
	}

  if ( m_view->zoom() == 0.50 ) m_shell->m_zoom_50->setOn( TRUE );
  if ( m_view->zoom() == 0.75 ) m_shell->m_zoom_75->setOn( TRUE );
  if ( m_view->zoom() == 1.00 ) m_shell->m_zoom_100->setOn( TRUE );
  if ( m_view->zoom() == 1.50 ) m_shell->m_zoom_150->setOn( TRUE );
  if ( m_view->zoom() == 2.00 ) m_shell->m_zoom_200->setOn( TRUE );

  if ( !m_view->slidersVisible()  ) m_shell->m_hide_sliders->setOn( TRUE );
			       else m_shell->m_hide_sliders->setOn( FALSE );
  if ( !m_view->rulersVisible()   ) m_shell->m_hide_rulers->setOn( TRUE );
                               else m_shell->m_hide_rulers->setOn( FALSE );
  if ( !m_view->pixmapBuffering() ) m_shell->m_x11_backstoring->setOn( TRUE );
                               else m_shell->m_x11_backstoring->setOn( FALSE );	
  if (  m_view->fullPage() ) m_shell->m_show_full_page->setOn( TRUE );
                        else m_shell->m_show_full_page->setOn( FALSE );			
  if ( m_apply_button ) m_shell->m_apply_button->setOn( TRUE );
		   else m_shell->m_apply_button->setOn( FALSE );
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_curr_page_changed()
 {
  if ( m_view->currentPage() ) {
	m_shell->m_wizard->setEnabled( TRUE );
	m_shell->m_new_axes2d->setEnabled( TRUE );
	m_shell->m_new_axes3d->setEnabled( TRUE );
	m_shell->m_rename_page->setEnabled( TRUE );
	m_shell->m_delete_page->setEnabled( TRUE );
	m_shell->m_page_to_front->setEnabled( TRUE );
	m_shell->m_page_to_back->setEnabled( TRUE );
	m_shell->m_raise_page->setEnabled( TRUE );
	m_shell->m_lower_page->setEnabled( TRUE );
	m_shell->m_export_picture->setEnabled( TRUE );
	slot_page_title_changed( m_view->currentPage()->title() );
	} else {
 	m_shell->m_wizard->setEnabled( FALSE );
 	m_shell->m_new_axes2d->setEnabled( FALSE );
	m_shell->m_new_axes3d->setEnabled( FALSE );
	m_shell->m_rename_page->setEnabled( FALSE );
	m_shell->m_delete_page->setEnabled( FALSE );
	m_shell->m_page_to_front->setEnabled( FALSE );
	m_shell->m_page_to_back->setEnabled( FALSE );
	m_shell->m_raise_page->setEnabled( FALSE );
	m_shell->m_lower_page->setEnabled( FALSE );
	m_shell->m_export_picture->setEnabled( FALSE );
	slot_page_title_changed( QString::null );
	}
  /*
  if ( view()->currentPage() ) {
	m_shell->m_edit_objects->setEnabled(TRUE);
	} else {
	m_shell->m_edit_objects->setEnabled(FALSE);
	}
  */
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_active_axes_changed()
 {
  m_view->bindScrollBar( QSPlotView::HorizontalBar, QSAxis::XAxisType );
  m_view->bindScrollBar( QSPlotView::VerticalBar, QSAxis::YAxisType );
  if ( dynamic_cast<QSAxes2D*>(m_view->activeAxes()) ) {
  	m_view->bindSlider( QSPlotView::HorizontalSlider, "", 0, 0 );
  	m_view->bindSlider( QSPlotView::VerticalSlider,   "", 0, 0 );
 	m_view->bindSlider( QSPlotView::AdditionalSlider, "", 0, 0 );
  	}
  else
  if ( dynamic_cast<QSAxes3D*>(m_view->activeAxes())  ) {
  	m_view->bindSlider( QSPlotView::HorizontalSlider, "azimuth", 0, 359 );
  	m_view->bindSlider( QSPlotView::VerticalSlider, "elevation", -90, 90 );
  	m_view->bindSlider( QSPlotView::AdditionalSlider, "lightAzimuth", 0, 359 );
  	}
  else {
  	m_view->bindSlider( QSPlotView::HorizontalSlider, "", 0, 0 );
  	m_view->bindSlider( QSPlotView::VerticalSlider,   "", 0, 0 );
 	m_view->bindSlider( QSPlotView::AdditionalSlider, "", 0, 0 );
       }

  if ( m_view->activeAxes() ) {
	m_shell->m_paste_dataset->setEnabled( TRUE );
	// enable actions
	m_shell->m_new_curve->setEnabled( TRUE );
	m_shell->m_new_image->setEnabled( TRUE );
	m_shell->m_new_contour->setEnabled( TRUE );
	m_shell->m_new_ngcontour->setEnabled( TRUE );
	m_shell->m_new_surface->setEnabled( TRUE );
	m_shell->m_new_figure->setEnabled( TRUE );
	m_shell->m_new_legend->setEnabled( TRUE );
	m_shell->m_new_xaxis->setEnabled( TRUE );
	m_shell->m_new_yaxis->setEnabled( TRUE );
	m_shell->m_new_zaxis->setEnabled( TRUE );
	m_shell->m_new_vaxis->setEnabled( TRUE );
	m_shell->m_new_legend->setEnabled( TRUE );
       } else {
	m_shell->m_paste_dataset->setEnabled( FALSE );
	// disable actions
	m_shell->m_new_curve->setEnabled( FALSE );
	m_shell->m_new_image->setEnabled( FALSE );
	m_shell->m_new_contour->setEnabled( FALSE );
	m_shell->m_new_ngcontour->setEnabled( FALSE );
	m_shell->m_new_surface->setEnabled( FALSE );
	m_shell->m_new_figure->setEnabled( FALSE );
	m_shell->m_new_legend->setEnabled( FALSE );
	m_shell->m_new_xaxis->setEnabled( FALSE );
	m_shell->m_new_yaxis->setEnabled( FALSE );
	m_shell->m_new_zaxis->setEnabled( FALSE );
	m_shell->m_new_legend->setEnabled( FALSE );
       }

   if ( view()->activeAxes() ) {
	m_shell->m_datasets->setEnabled(TRUE);
	} else {
	m_shell->m_datasets->setEnabled(FALSE);
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_selection_changed()
 {
  if ( m_view->selection()->count()>0 ) {
	m_shell->m_cut->setEnabled( TRUE );
	m_shell->m_copy->setEnabled( TRUE );
	m_shell->m_copy_all->setEnabled( TRUE );
        m_shell->m_delete->setEnabled( TRUE );
	m_shell->m_bring_to_front->setEnabled( TRUE );
        m_shell->m_send_to_back->setEnabled( TRUE  );
	m_shell->m_raise->setEnabled( TRUE  );
	m_shell->m_lower->setEnabled( TRUE  );
	} else {
	m_shell->m_cut->setEnabled( FALSE );
	m_shell->m_copy->setEnabled( FALSE );
	m_shell->m_copy_all->setEnabled( FALSE );
        m_shell->m_delete->setEnabled( FALSE );
	m_shell->m_bring_to_front->setEnabled( FALSE );
        m_shell->m_send_to_back->setEnabled( FALSE );
	m_shell->m_raise->setEnabled( FALSE );
	m_shell->m_lower->setEnabled( FALSE );
	}

  if ( m_view->selection()->count()>1 ) {
	m_shell->m_group->setEnabled( TRUE );
	} else {
	m_shell->m_group->setEnabled( FALSE );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_selected_object_changed()
 {
  if ( dynamic_cast<QSCGroup*>(m_view->activeObject()) && !m_view->activeObject()->isAxesShadow() ) {
	m_shell->m_ungroup->setEnabled( TRUE );	
	} else {
	m_shell->m_ungroup->setEnabled( FALSE );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_view_slider_pressed()
 {
  if ( m_view->activeAxes() ) {
	delete m_curr_properties_cmd;
        m_curr_properties_cmd = new KSCmdSetProperties( m_view->activeAxes() );
	// only register properties ( current value will be remembered )
	for ( int slider_nr=0; slider_nr<3; slider_nr++ ) {
        	QCString property_name = m_view->sliderProperty( (QSPlotView::SliderType )slider_nr);
		m_curr_properties_cmd->setProperty( property_name, m_view->activeAxes()->property(property_name) );
		}
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_view_slider_released()
 {
  if ( m_curr_properties_cmd ) {
	// update to new values
	for ( int slider_nr=0; slider_nr<3; slider_nr++ ) {
        	QCString property_name = m_view->sliderProperty( (QSPlotView::SliderType )slider_nr );
		m_curr_properties_cmd->setProperty( property_name, m_view->activeAxes()->property(property_name) );
		}
	m_workbook->execute( m_curr_properties_cmd );
	m_curr_properties_cmd = NULL;
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_view_scrollbar_pressed()
 {
  if ( m_view->activeAxes() ) {
	delete m_curr_ranges_cmd;
	m_curr_ranges_cmd = new KSCmdSetRanges( m_view->activeAxes() );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_view_scrollbar_released()
 {
  if ( m_curr_ranges_cmd ) {
	m_curr_ranges_cmd->commit();
	m_workbook->execute( m_curr_ranges_cmd );
	m_curr_ranges_cmd = NULL;
	}
 }

//--------------------------------------------------------------------------//

void KSWinPageView::cut()
 {
  if ( m_view->selection()->count() > 0 ) {
	KSObjectFactory factory( m_workbook );
	factory.copyQSCObjectCollectionToClipboard( m_view->selection() );
	m_workbook->execute( new KSCmdRemoveCObject( m_view->selection() ) );
	}
 }

//--------------------------------------------------------------------------//

void KSWinPageView::copy()
 {
  if ( m_view->selection()->count() > 0 ) {
	KSObjectFactory factory( m_workbook );
	factory.copyQSCObjectCollectionToClipboard( m_view->selection() );
	}
 }

//--------------------------------------------------------------------------//

void KSWinPageView::copyAll()
 {
  if ( m_view->selection()->count() > 0 ) {
	KSObjectFactory factory( m_workbook );
	factory.setFlags( KSObjectFactory::CopyAllData );
	factory.copyQSCObjectCollectionToClipboard( m_view->selection() );	
	}
 }

//--------------------------------------------------------------------------//

void KSWinPageView::paste()
 {
  KSObjectFactory factory( m_workbook );
  QSCObjectCollection *new_objects = factory.pasteQSCObjectCollectionFromClipboard();
  if ( new_objects ) {
  	bool ok = m_workbook->execute( new KSCmdAddCObject( new_objects, m_view->activeCollection() ) );
  	if ( ok ) for( int i=0; i<new_objects->count(); i++ ) m_view->selection()->add( new_objects->object(i) );		
	delete new_objects;
	}
 }

//--------------------------------------------------------------------------//

void KSWinPageView::del()
 {
  m_workbook->execute( new KSCmdRemoveCObject( m_view->selection() ) );
 }

//--------------------------------------------------------------------------//

void KSWinPageView::doAction( QAction* action )
 {
  if ( !isActive() ) return;
  if ( action == m_shell->m_delete_page ) slotDeletePage();
  if ( action == m_shell->m_rename_page ) slotRenamePage();
  if ( action == m_shell->m_page_to_front ) slotPageToFront();
  if ( action == m_shell->m_page_to_back  ) slotPageToBack();
  if ( action == m_shell->m_raise_page ) slotRaisePage();
  if ( action == m_shell->m_lower_page ) slotLowerPage();
  if ( action == m_shell->m_export_picture ) slotExportPicture();

  if ( action == m_shell->m_wizard ) slotWizard();
  if ( action == m_shell->m_new_axes2d ) slotNewAxes2D();
  if ( action == m_shell->m_new_axes3d ) slotNewAxes3D();
  if ( action == m_shell->m_new_curve  ) slotNewCurve();
  if ( action == m_shell->m_new_image ) slotNewImage();
  if ( action == m_shell->m_new_contour )  slotNewContour();
  if ( action == m_shell->m_new_ngcontour ) slotNewNGContour();
  if ( action == m_shell->m_new_surface ) slotNewSurface();
  if ( action == m_shell->m_new_figure ) slotNewFigure();
  if ( action == m_shell->m_new_xaxis ) slotNewXAxis();
  if ( action == m_shell->m_new_yaxis ) slotNewYAxis();
  if ( action == m_shell->m_new_zaxis ) slotNewZAxis();
  if ( action == m_shell->m_new_vaxis ) slotNewVAxis();
  if ( action == m_shell->m_datasets ) slotDatasets();
  if ( action == m_shell->m_new_legend ) slotNewLegend();

  if ( action == m_shell->m_bring_to_front ) slotBringToFront();
  if ( action == m_shell->m_send_to_back ) slotSendToBack();
  if ( action == m_shell->m_raise ) slotRaise();
  if ( action == m_shell->m_lower ) slotLower();
  if ( action == m_shell->m_grid ) slotGrid();
  if ( action == m_shell->m_group ) slotGroup();
  if ( action == m_shell->m_ungroup ) slotUngroup();

  if ( action == m_shell->m_hide_sliders ) slotHideSliders();
  if ( action == m_shell->m_hide_rulers  ) slotHideRulers();
  if ( action == m_shell->m_show_full_page ) slotShowFullPage();
  if ( action == m_shell->m_ioinfo ) slotIOInfo();

  if ( action == m_shell->m_apply_button ) slotApplyButton();
  if ( action == m_shell->m_object_menu ) slotObjectMenu();
  if ( action == m_shell->m_x11_backstoring ) slotX11Backstoring();

  if ( action == m_shell->m_zoom ) slotPageZoom();
  if ( action == m_shell->m_tool_zoom ) slotToolZoom();
  if ( action == m_shell->m_tool_arrow ) slotToolArrow();
  if ( action == m_shell->m_tool_label ) slotToolLabel();
  if ( action == m_shell->m_tool_locate ) slotToolLocate();
  if ( action == m_shell->m_tool_rect ) slotToolRect();
  if ( action == m_shell->m_tool_select ) slotToolSelect();

  if ( action == m_shell->m_cut_dataset ) slotCutDataset();
  if ( action == m_shell->m_copy_dataset ) slotCopyDataset();
  if ( action == m_shell->m_copy_all_dataset ) slotCopyAllDataset();
  if ( action == m_shell->m_paste_dataset ) slotPasteDataset();
  if ( action == m_shell->m_delete_dataset ) slotDeleteDataset();
  if ( action == m_shell->m_raise_dataset ) slotRaiseDataset();
  if ( action == m_shell->m_lower_dataset ) slotLowerDataset();
  if ( action == m_shell->m_bring_dataset_to_front ) slotBringDatasetToFront();
  if ( action == m_shell->m_send_dataset_to_back ) slotSendDatasetToBack();
 }

//--------------------------------------------------------------------------//

QWidget *KSWinPageView::createObjectPanel( QWidget *parent )
 {
  KSObjectTreePanel *object_panel = new KSObjectTreePanel( m_shell, m_view, parent );
  return object_panel;
 }

//--------------------------------------------------------------------------//

QWidget *KSWinPageView::createPropertyPanel( QWidget *parent )
 {
  KSPanelManager *panel_mgr = new KSPanelManager( m_shell, parent );
  panel_mgr->setView( m_view );
  panel_mgr->setEnabled( true );
  panel_mgr->setAutoSetProperties( !m_apply_button );
  panel_mgr->setOrientation( m_shell->bottomDock()->orientation() );
  connect( panel_mgr, SIGNAL(message(const QString&)), m_shell, SLOT(slotShowHelpMessage(const QString&)) );
  connect( panel_mgr, SIGNAL(dataObjectSelected(QSData*)), m_shell, SLOT(slotDataObjectSelected(QSData*)) );
  connect( panel_mgr, SIGNAL(dataObjectSelected(QSData*)), this, SLOT(slot_set_current_dataset(QSData*)) );
  connect( m_shell->bottomDock(), SIGNAL(orientationChanged(Orientation)), panel_mgr, SLOT(setOrientation(Orientation)) );
  return panel_mgr;
 }

//-----------------------------------------------------------------------------//

void KSWinPageView::slotExportPicture()
 {
  KSExportPictureDlg dlg( view(), "exportpicture" );
  dlg.exec();
 }

//-----------------------------------------------------------------------------//

void KSWinPageView::slotDatasets()
 {
  KSDatasetDlg d( m_workbook, view()->activeAxes() );
  d.exec();
 }

//-----------------------------------------------------------------------------//

void KSWinPageView::slotIOInfo()
 {
  QString info;
  if ( kmatplot_socket ) {
	info += tr(" Application: " ) + QString::number(kmatplot_socket->appNumber()) + tr(" ( see 'ksetapp' command ) \n");
	info += tr(" Active axes: " ) + QString::number(kmatplot_socket->axesId(view()->activeAxes())) + tr(" ( see 'ksetaxes' command ) ");
	info += "\n";
	info += tr(" Socket name: " ) + (const char *)kmatplot_socket->socketName();
	} else {
	info += tr("Socket disabled.");
	}
  QMessageBox::information( this, tr("I/O Info"), info );
 }

//-------------------------------------------------------------//

void KSWinPageView::slotDeletePage()
 {
  m_workbook->execute( new KSCmdRemovePage(m_view->currentPage(),m_workbook) );
 }

//-------------------------------------------------------------//

void KSWinPageView::slotRenamePage()
 {
  if ( m_view->currentPage() ) {
  	bool ok_pressed = false;
  	QString new_title = QInputDialog::getText( tr("Enter a new page title"), QString::null, QLineEdit::Normal, m_view->currentPage()->title(), &ok_pressed, m_view );
  	if ( ok_pressed ) { m_view->currentPage()->setTitle( new_title ); }
	}
 }

//-------------------------------------------------------------//

void KSWinPageView::slotPageToFront()
 {
  m_workbook->execute( new KSCmdPageOrder(KSCmdPageOrder::ToFront,m_view->currentPage(),m_workbook) );	
 }

//-------------------------------------------------------------//

void KSWinPageView::slotPageToBack()
 {
  m_workbook->execute( new KSCmdPageOrder(KSCmdPageOrder::ToBack,m_view->currentPage(),m_workbook) );
 }

//-------------------------------------------------------------//

void KSWinPageView::slotRaisePage()
 {
  m_workbook->execute( new KSCmdPageOrder(KSCmdPageOrder::Raise,m_view->currentPage(),m_workbook) );
 }

//-------------------------------------------------------------//

void KSWinPageView::slotLowerPage()
 {
  m_workbook->execute( new KSCmdPageOrder(KSCmdPageOrder::Lower,m_view->currentPage(),m_workbook) );
 }

//-------------------------------------------------------------//

void KSWinPageView::slot_show_page_popup()
 {
  QPopupMenu *menu = new QPopupMenu( m_view );
  m_shell->m_new_page->addTo( menu );
  m_shell->m_rename_page->addTo( menu );
  m_shell->m_delete_page->addTo( menu );
  menu->insertSeparator();
  m_shell->m_raise_page->addTo( menu );
  m_shell->m_lower_page->addTo( menu );
  menu->insertSeparator();
  m_shell->m_page_to_front->addTo( menu );
  m_shell->m_page_to_back->addTo( menu );

  menu->exec(QCursor::pos());
  delete menu;	
 }

//-----------------------------------------------------------//

void KSWinPageView::slotGroup()
 {
  m_workbook->execute( new KSCmdCObjectGroup( m_view->selection(), m_view->selection() ) );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotUngroup()
 {
  if ( dynamic_cast<QSCGroup*>(m_view->activeObject()) )
	m_workbook->execute( new KSCmdCObjectUngroup( dynamic_cast<QSCGroup*>(m_view->activeObject()), m_view->selection() ) );
 }


//-----------------------------------------------------------//

void KSWinPageView::slotBringToFront()
 {
  m_workbook->execute( new KSCmdObjectOrder( KSCmdObjectOrder::ToFront, m_view->selection(), m_workbook ) );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotHideSliders()
 {
  bool enabled = m_shell->m_hide_sliders->isOn();
  m_view->setSlidersVisible( !enabled );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotHideRulers()
 {
  bool enabled = m_shell->m_hide_rulers->isOn();
  m_view->setRulersVisible( !enabled );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotX11Backstoring()
 {
  bool enabled = m_shell->m_x11_backstoring->isOn();
  m_view->setPixmapBuffering( !enabled );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotShowFullPage()
 {
  bool enabled = m_shell->m_show_full_page->isOn();
  m_view->setFullPage( enabled );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotApplyButton()
 {
  bool enabled = m_shell->m_apply_button->isOn();
  KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
  m_apply_button = enabled;
  if ( panel_mgr ) panel_mgr->setAutoSetProperties( !m_apply_button );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewAxes2D()
 {
  QSAxes *new_axes = new QSAxes2D();
  bool ok = m_workbook->execute( new KSCmdAddCObject( new_axes->shadowObject(), m_view->currentPage()->objects() ) );
  if ( ok ) m_view->selection()->set( new_axes->shadowObject() );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewAxes3D()
 {
 QSAxes *new_axes = new QSAxes3D();
 bool ok = m_workbook->execute( new KSCmdAddCObject( new_axes->shadowObject(), m_view->currentPage()->objects() ) );
 if ( ok ) m_view->selection()->set( new_axes->shadowObject() );
 }

//-----------------------------------------------------------//

bool KSWinPageView::check_axes()
 {
  if ( !m_view->activeAxes() ) {
  	QMessageBox::warning ( NULL, tr("Error"), tr("No axes selected"), QMessageBox::Ok, 0, 0 );
	return false;
	}
  return true;
 }


//-----------------------------------------------------------//

void KSWinPageView::slotNewCurve()
 {
  if ( check_axes() ) {
	m_workbook->execute( new KSCmdAddDataset(new QSCurve(m_view->activeAxes())) );
  	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::DatasetCategory, m_view->activeAxes()->plotCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewImage()
 {
  if ( check_axes() ) {
	m_workbook->execute( new KSCmdAddDataset(new QSImage(m_view->activeAxes())) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::DatasetCategory, m_view->activeAxes()->plotCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewContour()
 {
  if ( check_axes() ) {
	m_workbook->execute( new KSCmdAddDataset(new QSGriddedContour(m_view->activeAxes())) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::DatasetCategory, m_view->activeAxes()->plotCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewNGContour()
 {
  if ( check_axes() ) {
  	m_workbook->execute( new KSCmdAddDataset(new QSNonGriddedContour(m_view->activeAxes())) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::DatasetCategory, m_view->activeAxes()->plotCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewSurface()
{
 if ( check_axes() ) {
	m_workbook->execute( new KSCmdAddDataset(new QSSurface(m_view->activeAxes())) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::DatasetCategory, m_view->activeAxes()->plotCount()-1 );
	}
}

//-----------------------------------------------------------//

void KSWinPageView::slotNewFigure()
 {
  if ( check_axes() ) {
  	m_workbook->execute( new KSCmdAddDataset(new QSFigure(m_view->activeAxes())) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::DatasetCategory, m_view->activeAxes()->plotCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewXAxis()
 {
  if ( check_axes() ) {
  	m_workbook->execute( new KSCmdAddAxis( new QSAxis(QSAxis::XAxisType,m_view->activeAxes()) ) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::AxisCategory, m_view->activeAxes()->axisCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewYAxis()
 {
  if ( check_axes() ) {
  	m_workbook->execute( new KSCmdAddAxis( new QSAxis(QSAxis::YAxisType,m_view->activeAxes()) ) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::AxisCategory, m_view->activeAxes()->axisCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewZAxis()
 {
  if ( check_axes() ) {
  	m_workbook->execute( new KSCmdAddAxis( new QSAxis(QSAxis::ZAxisType,m_view->activeAxes()) ) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
 	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::AxisCategory, m_view->activeAxes()->axisCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewVAxis()
 {
  if ( check_axes() ) {
  	m_workbook->execute( new KSCmdAddAxis( new QSAxis(QSAxis::VAxisType,m_view->activeAxes()) ) );
	KSPanelManager *panel_mgr = dynamic_cast<KSPanelManager*>(m_shell->propertyContainer()->widget());
	if ( panel_mgr ) panel_mgr->selectPanel( QSAxes::AxisCategory, m_view->activeAxes()->axisCount()-1 );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotNewLegend()
 {
  if ( check_axes() ) {
  	m_workbook->execute( new KSCmdAddCObject(new QSCLegend(m_view->activeAxes()),m_view->activeCollection()) );
  	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotGrid()
 {
  KSGridDlg d( m_view, this );
  d.exec();
 }

//-------------------------------------------------------------//

void KSWinPageView::slotObjectMenu()
 {
  QPopupMenu *menu = new QPopupMenu( m_view );
  m_shell->m_cut->addTo( menu );
  m_shell->m_copy->addTo( menu );
  m_shell->m_copy_all->addTo( menu );
  m_shell->m_paste->addTo( menu );
  m_shell->m_delete->addTo( menu );
  menu->insertSeparator();

  QPopupMenu *popup_insert = new QPopupMenu( menu );
  menu->insertItem( tr("Insert"), popup_insert );

  m_shell->m_new_curve->addTo( popup_insert );
  m_shell->m_new_image->addTo( popup_insert );
  m_shell->m_new_contour->addTo( popup_insert );
  m_shell->m_new_ngcontour->addTo( popup_insert );
  m_shell->m_new_surface->addTo( popup_insert );
  m_shell->m_new_figure->addTo( popup_insert );

  popup_insert->insertSeparator();

  m_shell->m_new_xaxis->addTo( popup_insert );
  m_shell->m_new_yaxis->addTo( popup_insert );
  m_shell->m_new_zaxis->addTo( popup_insert );
  m_shell->m_new_vaxis->addTo( popup_insert );

  menu->insertSeparator();

  m_shell->m_bring_to_front->addTo( menu );
  m_shell->m_send_to_back->addTo( menu );
  menu->insertSeparator();
  m_shell->m_raise->addTo( menu );
  m_shell->m_lower->addTo( menu );

  menu->exec(QCursor::pos());
 }

//-----------------------------------------------------------//

void KSWinPageView::slotSendToBack()
 {
  m_workbook->execute( new KSCmdObjectOrder( KSCmdObjectOrder::ToBack, m_view->selection(), m_workbook ) );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotRaise()
 {
  m_workbook->execute( new KSCmdObjectOrder( KSCmdObjectOrder::Raise, m_view->selection(), m_workbook ) );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotLower()
 {
  m_workbook->execute( new KSCmdObjectOrder( KSCmdObjectOrder::Lower, m_view->selection(), m_workbook ) );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotPageZoom()
 {
  if ( m_shell->m_zoom_50->isOn()  ) m_view->setZoom( 0.50 );
  if ( m_shell->m_zoom_75->isOn()  ) m_view->setZoom( 0.75 );
  if ( m_shell->m_zoom_100->isOn() ) m_view->setZoom( 1.00 );
  if ( m_shell->m_zoom_150->isOn() ) m_view->setZoom( 1.50 );
  if ( m_shell->m_zoom_200->isOn() ) m_view->setZoom( 2.00 );
 }

 //-----------------------------------------------------------//

void KSWinPageView::slotToolZoom()
 {
  bool on = m_shell->m_tool_zoom->isOn();
  if ( on ) m_view->setTool( new QSToolZoom() );
      else  m_view->setTool( NULL );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotToolSelect()
 {
  bool on = m_shell->m_tool_select->isOn();
  if ( on ) m_view->setTool( new QSToolSelect(m_shell) );
      else  m_view->setTool( NULL );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotToolLabel()
 {
  bool on = m_shell->m_tool_label->isOn();
  if ( on ) m_view->setTool( new QSToolLabel() );
      else  m_view->setTool( NULL );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotToolArrow()
 {
  bool on = m_shell->m_tool_arrow->isOn();
  if ( on ) m_view->setTool( new QSToolArrow() );
      else  m_view->setTool( NULL );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotToolRect()
 {
  bool on = m_shell->m_tool_rect->isOn();
  if ( on ) m_view->setTool( new QSToolRect() );
      else  m_view->setTool( NULL );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotToolLocate()
 {
  bool on = m_shell->m_tool_locate->isOn();
  if ( on ) m_view->setTool( new QSToolLocate() );
      else  m_view->setTool( NULL );
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_page_title_changed( const QString& newTitle )
 {
  setTitle( newTitle );
 }

//-----------------------------------------------------------//

void KSWinPageView::slotCutDataset()
 {
  KSObjectFactory factory( m_workbook );
  QSPlot *plot = dynamic_cast<QSPlot*>(m_curr_dataset);
  QSAxis *axis = dynamic_cast<QSAxis*>(m_curr_dataset);
  if ( plot ) {
  	factory.copyQSPlotToClipboard( plot );
  	m_workbook->execute( new KSCmdRemoveDataset(plot) );
	}
  if ( axis ) {
	 factory.copyQSAxisToClipboard( axis );
	 m_workbook->execute( new KSCmdRemoveAxis(axis) );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotCopyDataset()
 {
  KSObjectFactory factory( m_workbook );
  QSPlot *plot = dynamic_cast<QSPlot*>(m_curr_dataset);
  QSAxis *axis = dynamic_cast<QSAxis*>(m_curr_dataset);
  if ( plot ) {
	 factory.copyQSPlotToClipboard( plot );	
	}
  if ( axis ) {
	 factory.copyQSAxisToClipboard( axis );	
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotCopyAllDataset()
 {
  KSObjectFactory factory( m_workbook );
  factory.setFlags( KSObjectFactory::CopyAllData );
  QSPlot *plot = dynamic_cast<QSPlot*>(m_curr_dataset);
  QSAxis *axis = dynamic_cast<QSAxis*>(m_curr_dataset);
  if ( plot ) {
	 factory.copyQSPlotToClipboard( plot );	
	}
  if ( axis ) {
	 factory.copyQSAxisToClipboard( axis );	
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotPasteDataset()
 {
  if ( m_view->activeAxes() ) {
	KSObjectFactory factory( m_workbook );
	QSPlot *new_plot = factory.pasteQSPlotFromClipboard( m_view->activeAxes() );
	if ( new_plot ) m_workbook->execute( new KSCmdAddDataset( new_plot ) );	
	QSAxis *new_axis = factory.pasteQSAxisFromClipboard( m_view->activeAxes() );
	if ( new_axis ) m_workbook->execute( new KSCmdAddAxis( new_axis ) );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotDeleteDataset()
 {
  QSPlot *plot = dynamic_cast<QSPlot*>(m_curr_dataset);
  QSAxis *axis = dynamic_cast<QSAxis*>(m_curr_dataset);
  if ( plot ) {
	 m_workbook->execute( new KSCmdRemoveDataset(plot) );
	}
  if ( axis ) {
	 m_workbook->execute( new KSCmdRemoveAxis(axis) );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotBringDatasetToFront()
 {
  if ( m_curr_dataset ) {
	 QSPlot *plot = dynamic_cast<QSPlot*>(m_curr_dataset);
         QSAxis *axis = dynamic_cast<QSAxis*>(m_curr_dataset);
         if ( plot ) m_workbook->execute( new KSCmdDatasetOrder( KSCmdDatasetOrder::ToFront,plot) );
         if ( axis ) m_workbook->execute( new KSCmdAxisOrder( KSCmdAxisOrder::ToFront,axis) );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotSendDatasetToBack()
 {
  if ( m_curr_dataset ) {
	 QSPlot *plot = dynamic_cast<QSPlot*>(m_curr_dataset);
         QSAxis *axis = dynamic_cast<QSAxis*>(m_curr_dataset);
         if ( plot ) m_workbook->execute( new KSCmdDatasetOrder( KSCmdDatasetOrder::ToBack,plot) );
         if ( axis ) m_workbook->execute( new KSCmdAxisOrder( KSCmdAxisOrder::ToBack,axis) );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotRaiseDataset()
 {
  if ( m_curr_dataset ) {
	 QSPlot *plot = dynamic_cast<QSPlot*>(m_curr_dataset);
         QSAxis *axis = dynamic_cast<QSAxis*>(m_curr_dataset);
         if ( plot ) m_workbook->execute( new KSCmdDatasetOrder( KSCmdDatasetOrder::Raise,plot) );
         if ( axis ) m_workbook->execute( new KSCmdAxisOrder( KSCmdAxisOrder::Raise,axis) );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotLowerDataset()
 {
  if ( m_curr_dataset ) {
	 QSPlot *plot = dynamic_cast<QSPlot*>(m_curr_dataset);
         QSAxis *axis = dynamic_cast<QSAxis*>(m_curr_dataset);
         if ( plot ) m_workbook->execute( new KSCmdDatasetOrder( KSCmdDatasetOrder::Lower,plot) );
         if ( axis ) m_workbook->execute( new KSCmdAxisOrder( KSCmdAxisOrder::Lower,axis) );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slot_set_current_dataset( QSData *dataset )
 {
  m_curr_dataset = dataset;
  if ( m_curr_dataset ) {
	m_shell->m_cut_dataset->setEnabled( TRUE );
	m_shell->m_copy_dataset->setEnabled( TRUE );
	m_shell->m_copy_all_dataset->setEnabled( TRUE );
	m_shell->m_delete_dataset->setEnabled( TRUE );
	m_shell->m_raise_dataset->setEnabled( TRUE );
	m_shell->m_lower_dataset->setEnabled( TRUE );
	m_shell->m_bring_dataset_to_front->setEnabled( TRUE );
	m_shell->m_send_dataset_to_back->setEnabled( TRUE );
	} else {
	m_shell->m_cut_dataset->setEnabled( FALSE );
	m_shell->m_copy_dataset->setEnabled( FALSE );
	m_shell->m_copy_all_dataset->setEnabled( FALSE );
	m_shell->m_delete_dataset->setEnabled( FALSE );
	m_shell->m_raise_dataset->setEnabled( FALSE );
	m_shell->m_lower_dataset->setEnabled( FALSE );
	m_shell->m_bring_dataset_to_front->setEnabled( FALSE );
	m_shell->m_send_dataset_to_back->setEnabled( FALSE );
	}
 }

//-----------------------------------------------------------//

void KSWinPageView::slotWizard()
 {
  KSGraphWizard dlg( m_view, m_workbook, this );
  dlg.exec();
 }