/***************************************************************************
                          ksmatrixsheet.h  -  description
                             -------------------
    begin                : Tue Feb 26 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSMATRIXSHEET_H
#define KSMATRIXSHEET_H

#include <qwidget.h>
//#include <qsmatrix.h>

/*
//---------------------------------------------------------------------//

class KSCellFormat {
	QSGFill background;
	int numericPrecision;
	char numericFormat;
	QString dateTimeFormat;
	};

//----------------------------------------------------------------------//

typedef struct {
	union {
		double numeric;
		QString *string;
		} m_value;
	int m_type;
	int m_format;

	bool isEmpty() const {}
	void setEmpty( bool empty );
	void setType( int type );
	int type() const {}
	void setValue( double value );
	void setString( const QString& string );
	double value() const;
	QString string( const KSCellFormat& format ) const;
	} cell_t;

//-----------------------------------------------------------------------//

class KSSheetColumn {
	
	int size();
	void resize( int new_size );
	void adjustSize();
	};

//-----------------------------------------------------------------------//

/** The most complex implemetation of
  * QSMatrix interface - sheet-like data with
  * auto-resizing, data types, formulas and
  * format assigned to individual cells.
  * @author kamil


class KSMatrixSheet : public QSMatrix  {
   Q_OBJECT
public:
	enum CellType { NumericType,
			IntegerType,
			StringType,
			DateType,
			TimeType,
			DateTimeType,
			FillType,
			LineType,
			FontType,
			PointType,
			ArrowType };

	KSMatrixSheet(QWidget *parent=0, const char *name=0);
	virtual ~KSMatrixSheet();

	void setDefaultFormat( const KSCellFormat& format );
	const KSCellFormat &defaultFormat() const;

        void setCellType( int row, int col, CellType type );
	CellType cellType( int row, int col ) const;

	void setFormat( const KSCellFormat& format, int rowFrom, int rowTo, int colFrom, int colTo );
	const KSCellFormat &format( int row, int col ) const;
	const KSCellFormat &format( int formatIndex  ) const;	
	void changeFormat( int formatIndex, const KSCellFormat& newFormat );
	int formatIndex( int row, int col ) const;
	
	void clear( int rowFrom, int rowTo, int colFrom, int colTo );
	void clear( int row, int col );

	void setCellType( int row, int col, CellType type );
	CellType cellType( int row, int col ) const;

	void insertColumns( int beforeCol, int number );
	void deleteColumns( int col, int number );

	int columnSize( int col ) const;

	virtual bool isEmpty( int row, int col ) const;

	virtual double value( int row, int col ) = 0;
	virtual QString string( int row, int col );
	virtual int rows() const = 0;
	virtual int cols() const = 0;
        virtual bool resize( int rows, int cols );
	virtual bool transpose() { return false; }
        virtual void setValue( int row, int col, double value );
	virtual void setString( int row, int col, const QString& string );
	virtual bool isEditable() const;
	virtual bool isString() const;	

        //void setFormula( const QString& formula, int rowFrom, int rowTo, int colFrom, int colTo );
	//int formula( );
};
*/
#endif
