/***************************************************************************
                                 ksmatrixio.h                               
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KSMATRIXIO_H
#define KSMATRIXIO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"ksmatrix.h"
#include"ksmatrixiohandler.h"
#include<list.h>
#include<qstring.h>
#include<qdatastream.h>
#include<qfile.h>


/**
  * List of matrix IO handlers - see KSMatrixIO::hlist
  */
typedef list<KSMatrixIOHandler *> KSHandlersList;

/**
  * Matix loading/saving class. This class loads matrices from files using handlers.
  * Handler is a class, which loads and saves matrices to a file in one format.
  * Handlers can be added or removed from the global list.
  */
class KSMatrixIO : public QObject {

       Q_OBJECT

       public:

        /**
          * Constructor. Opens a file and tries to determine a file format.
          * If 'filename' is empty, no file is opened and you must
          * open it with 'openFile()'.
          */
        KSMatrixIO( const QString& filename = QString(), int mode = IO_ReadOnly );

        /**
          * Destructor.
          */
       ~KSMatrixIO();

        /**
          * Opens a file and tries to determine a file format.
          */
        void openFile( const QString& filename, int mode = IO_ReadOnly );

        /**
          * Closes the currently opened file.
          */
        void closeFile();

        /**
          * Returns a filename of the currently opened file ( if any ) or
          * an empty QString.
          */
        QString filename() const { return file.name(); }

        /**
          * This method returns a list of matrices
          * in the file.  Matrices have valid size and
          * type but no data memory is allocated !
          * Remember to delete this list after use !
          */
       KSHeadersList *loadHeaders( const QString& format = QString() );

      /**
        * Loads 'matrixname' matrix from the file.
        */
       KSMatrix *loadMatrix( const QString& matrixname, const QString& format = QString() );

        /**
          * Saves 'm' matrix to the file ( which is reopened with the read/save access ).
          */
       void saveMatrix( QSMatrix *m, const QString& matrixname, const QString& format );

       /**
         * Adds a new loader to the list of loaders.
         * Pointer is consumed and will be deleted on exit.
         */
       static void addHandler( KSMatrixIOHandler *handler );

       /**
         * Deletes all loaders, which handles 'format'.
         */
       static int removeHandlers( const QString& format );

       static KSHandlersList hlist;

      signals:

        void progress( int percent );

      protected:

        KSMatrixIOHandler *findHandler( QDataStream &is, const QString& filename );
        KSMatrixIOHandler *findHandler( const QString& format );

      private:

        QFile   file;
        QString dformat;
        void setDefaultHandler();

        static bool initialized;
     };

#endif


















































