/***************************************************************************
                            ksglobalmatrixlist.cpp
                             -------------------
    begin                :

    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksglobalmatrixlist.h"
#include "widgets/qschildlist.h"

//-------------------------------------------------------------//

KSSheet::KSSheet( KSSheetList *parent )
:QSData( parent, parent )
 {
  m_matrix = NULL;
  m_parent = parent;
  m_insert_pos = -1;
 }

//-------------------------------------------------------------//

KSSheet::~KSSheet()
 {
  delete m_matrix;
 }

//-------------------------------------------------------------//

bool KSSheet::setMatrix( int channel, QSMatrix *m )
 {
  if ( channel == 0 ) {
	dataChanging(0);
        delete m_matrix;
	m_matrix = m;
	if ( m_matrix ) m_matrix->setDataObject( this, 0 );
	dataChanged(0);
	}
  return true;
 }

//-------------------------------------------------------------//

QSMatrix *KSSheet::takeMatrix( int channel, QSMatrix *newMatrix )
 {
  if ( channel == 0 ) {
	dataChanging(0);
        QSMatrix *result = m_matrix;
	if ( m_matrix ) m_matrix->setDataObject( NULL, -1 );
	m_matrix = newMatrix;
	if ( newMatrix ) newMatrix->setDataObject( this, 0 );
	dataChanged(0);
	return result;
	}
  return NULL;
 }

//-------------------------------------------------------------//

QSMatrix *KSSheet::matrix( int channel ) const
 {
  if ( channel == 0 ) return m_matrix; else return NULL;
 }

//-------------------------------------------------------------//

void KSSheet::deleteMatrix( int channel )
 {
  if ( channel == 0 && m_matrix != NULL ) {
	dataChanging(0);
	delete m_matrix;
	m_matrix = NULL;
	dataChanged(0);
	}
 }

//-------------------------------------------------------------//
/*
QString KSSheet::title() const
 {
  if ( m_matrix ) return m_matrix->title();
  return QString::null;
 }
*/
//-------------------------------------------------------------//

void KSSheet::setColumnData( int column, ColumnType type, const QString& title )
 {
  ColumnData new_data;
  new_data.column = column;
  new_data.type   = type;
  new_data.title  = title;
  setColumnData( new_data );
 }

//-------------------------------------------------------------//

bool KSSheet::isColumnDataPresent( int column ) const
 {
  return m_column_info.contains( column );
 }

//-------------------------------------------------------------//

void KSSheet::setColumnData( ColumnData data )
 {
 if ( data.column >= 0 ) {
 	if ( data.type == ColumnUnknown && data.title.isEmpty() ) m_column_info.remove( data.column );
						        else m_column_info.replace( data.column, data );
	}
 }

//-------------------------------------------------------------//

void KSSheet::removeColumnData( int column )
 {
  m_column_info.remove( column );
 }

//-------------------------------------------------------------//

KSSheet::ColumnData KSSheet::columnData( int column ) const
 {
  return m_column_info.contains( column ) ? m_column_info[column] : ColumnData( column );
 }

//-------------------------------------------------------------//

void KSSheet::loadStateFromStream( QDataStream& stream, QSObjectFactory *factory )
 {
  QSData::loadStateFromStream( stream, factory );
  stream >> m_insert_pos;
  int elements; stream >> elements;
  for( int i=0; i<elements; i++ ) {
	ColumnData element;
	stream >> element.column;
	int type; stream >> type; element.type = (ColumnType )type;
	stream >> element.title;
	setColumnData( element );
	}
 }

//-------------------------------------------------------------//

void KSSheet::saveStateToStream( QDataStream& stream, QSObjectFactory *factory )
 {
  QSData::saveStateToStream( stream, factory );
  stream << (int )m_parent->sheetFind(this); // insert pos
  stream << (int )m_column_info.count();
  ColumnInfo::Iterator it;
  for( it = m_column_info.begin(); it != m_column_info.end(); ++it ) {
	stream << it.data().column;
	stream << (int )it.data().type;
	stream << it.data().title;
	}
 }

//-------------------------------------------------------------//

int KSSheet::cellRangeCount() const
 {
  return (int )m_cell_range_list.size();
 }

//-------------------------------------------------------------//

KSMatrixWorksheetCellRange *KSSheet::cellRange( int index )
 {
  return m_cell_range_list[index];
 }

//-------------------------------------------------------------//

void KSSheet::cellRangeAdd( KSMatrixWorksheetCellRange *matrix )
 {
  if ( matrix ) m_cell_range_list.push_back( matrix );
 }

//-------------------------------------------------------------//

void KSSheet::cellRangeRemove( KSMatrixWorksheetCellRange *matrix )
 {
  for( int i=0; i<cellRangeCount(); i++ )
	if ( m_cell_range_list[i] == matrix ) {
		m_cell_range_list.erase( m_cell_range_list.begin() + i );
		break;
		}
 }



//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//



KSSheetList::KSSheetList( QObject * parent, const char * name )
:QSData( parent, NULL, name )
 {
  m_sheets = new QSChildList<KSSheet>;
 }

//-------------------------------------------------------------//

KSSheetList::~KSSheetList()
 {
  delete m_sheets;	
 }

//-------------------------------------------------------------//

void KSSheetList::clearAll()
 {
  while( childCount() ) sheetDelete( 0 );
 }

//-------------------------------------------------------------//

int KSSheetList::childCount() const
 {
  return m_sheets->count();
 }

//-------------------------------------------------------------//

KSSheet *KSSheetList::child( int index ) const
 {
  if ( index >=0 && index < childCount() ) return (*m_sheets)[index]; else return NULL;
 }

//-------------------------------------------------------------//

void KSSheetList::sheetAdd( KSSheet *sheet )
 {
  if ( sheet && sheet->insertPos() > -1 ) {
	m_sheets->insert( sheet->insertPos(), sheet );
	} else {
  	m_sheets->add( sheet );
	}
  emit sigChildAdded ( sheet );
  emit sigChildListChanged();
 }

//-------------------------------------------------------------//

void KSSheetList::sheetInsert( int position, KSSheet *sheet )
 {
  m_sheets->insert( position, sheet );
  emit sigChildAdded ( sheet );
  emit sigChildListChanged();
 }

//-------------------------------------------------------------//

void KSSheetList::sheetRemove( int index )
 {
  KSSheet *sheet = (*m_sheets)[index];
  if ( sheet ) {
	m_sheets->remove( index );
	emit sigChildRemoved( sheet );
 	emit sigChildListChanged();
	}
  }

//-------------------------------------------------------------//

void KSSheetList::sheetDelete( int index )
 {
  KSSheet *sheet = (*m_sheets)[index];
  if ( sheet ) {
	m_sheets->remove( index );
	emit sigChildRemoved( sheet );
 	emit sigChildListChanged();
	delete sheet;
	}
 }

//-------------------------------------------------------------//

void KSSheetList::sheetRaise( int index )
 {
  m_sheets->raise( index );
  emit sigChildOrder();
  emit sigChildListChanged();
 }

//-------------------------------------------------------------//

void KSSheetList::sheetLower( int index )
 {
  m_sheets->lower( index );
  emit sigChildOrder();
  emit sigChildListChanged();
 }

//-------------------------------------------------------------//

void KSSheetList::sheetToFront( int index )
 {
  m_sheets->toFront( index );
  emit sigChildOrder();
  emit sigChildListChanged();
 }

//-------------------------------------------------------------//

void KSSheetList::sheetToBack( int index )
 {
  m_sheets->toBack( index );
  emit sigChildOrder();
  emit sigChildListChanged();
 }

//-------------------------------------------------------------//

void KSSheetList::sheetReorder( int toPosition, int index )
 {
  m_sheets->reorder( toPosition, index );
  emit sigChildOrder();
  emit sigChildListChanged();
 }

 //-------------------------------------------------------------//

int KSSheetList::sheetFind( KSSheet *sheet )
 {
  return m_sheets->find(sheet);
 }

//-------------------------------------------------------------//

