/***************************************************************************
                                 kscommands.h
                             -------------------                                         
    begin                :
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KSCOMMANDS_H
#define KSCOMMANDS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"ksworkbook.h"
#include<qmap.h>
#include<qlist.h>
#include<qptrdict.h>
#include<qvaluelist.h>

//---------------------------------------------------------------------------------------------//

class QSCObject;
class QSCObjectCollection;
class KSCmdAddCObject : public KSCommand
 {
  public:
   KSCmdAddCObject( QSCObject *object, QSCObjectCollection *parent );
   KSCmdAddCObject( QSCObjectCollection *objects, QSCObjectCollection *parent );
   virtual ~KSCmdAddCObject();	
   virtual bool execute();
   virtual void unexecute();

  protected:
   QList<QSCObject> m_objects;
   QSCObjectCollection *m_parent;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdRemoveCObject : public KSCommand
 {
  public:
   KSCmdRemoveCObject( QSCObject *object );
   KSCmdRemoveCObject( QSCObjectCollection *objects );
   ~KSCmdRemoveCObject();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   QList<QSCObject> m_objects;
   QMap<int,QSCObject*> m_positions;
   QSCObjectCollection *m_parent;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdObjectOrder : public KSCommand
 {
  public:
   enum CommandType { ToFront, ToBack, Raise, Lower };
   KSCmdObjectOrder( CommandType t, QSCObjectCollection *objectCollection, QSWorkbook *workbook );
   virtual ~KSCmdObjectOrder();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   CommandType m_type;
   QSCObjectCollection *m_collection;
   QMap<int,QSCObject*> m_objects;
 };

//---------------------------------------------------------------------------------------------//

class QSDrv;
class KSCmdTransformCObjects : public KSCommand
 {
  public:
	KSCmdTransformCObjects( QSDrv *drv );
	virtual ~KSCmdTransformCObjects();
	void addObject( QSCObject *object );
	QSRectf objectRect( QSCObject *object );
 	int objectAngle( QSCObject *object );
	void commit();
	virtual bool execute();
	virtual void unexecute();

  private:
	class TransformData {
		public:
		QSRectf m_rect;
		int m_angle;
		TransformData() {
			}
		TransformData( const QSRectf rect, int angle ) {
			m_rect  = rect;
			m_angle = angle;
			}
		~TransformData() {
			}
		};

 	typedef QMap<QSCObject*,TransformData> TransformDataList;
	TransformDataList m_old_data;
	TransformDataList m_new_data;
	QSDrv *m_drv;
 };

//---------------------------------------------------------------------------------------------//

class QSCGroup;
class KSCmdCObjectGroup : public KSCommand
 {
  public:
	KSCmdCObjectGroup( QSCObjectCollection *objects, QSCObjectCollection *selection=NULL );
	~KSCmdCObjectGroup();
	virtual bool execute();
	virtual void unexecute();
  private:
	QSCGroup *m_group;
	QList<QSCObject> m_objects;
	QMap<int,QSCObject*> m_positions;
	QSCObjectCollection *m_parent;
	QSCObjectCollection *m_selection;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdCObjectUngroup : public KSCommand
 {
  public:
	KSCmdCObjectUngroup( QSCGroup *group, QSCObjectCollection *selection=NULL );
	~KSCmdCObjectUngroup();
	virtual bool execute();
	virtual void unexecute();
  private:
	QSCGroup *m_group;
	QList<QSCObject> m_objects;
	QMap<int,QSCObject*> m_positions;
	QSCObjectCollection *m_parent;
	QSCObjectCollection *m_selection;
 };
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

class QSPlot;
class KSCmdAddDataset : public KSCommand
 {
  public:
   KSCmdAddDataset( QSPlot *plot );
   virtual ~KSCmdAddDataset();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   QSAxes *m_axes;
   QSPlot *m_plot;
   bool m_delete_plot;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdAddDatasetGroup : public KSCommand
 {
  public:
   KSCmdAddDatasetGroup();
   virtual ~KSCmdAddDatasetGroup();	
   void addDataset( QSPlot *plot );
   virtual bool execute();
   virtual void unexecute();
  protected:
   QSAxes *m_axes;
   QList<QSPlot> m_plots;
   bool m_delete_plots;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdRemoveDataset : public KSCommand
 {
  public:
   KSCmdRemoveDataset( QSPlot *plot );
   virtual ~KSCmdRemoveDataset();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   int m_pos;
   QSAxes *m_axes;
   QSPlot *m_plot;
   bool m_delete_plot;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdDatasetOrder : public KSCommand
 {
  public:
   enum CommandType { ToFront, ToBack, Raise, Lower };
   KSCmdDatasetOrder( CommandType t, QSPlot *plot );
   virtual ~KSCmdDatasetOrder();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   CommandType m_type;
   int m_pos;
   QSAxes *m_axes;
   QSPlot *m_plot;
 };

//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

class QSAxis;
class KSCmdAddAxis : public KSCommand
 {
  public:
   enum CommandType { ToFront, ToBack, Raise, Lower };
   KSCmdAddAxis( QSAxis *axis );
   virtual ~KSCmdAddAxis();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   QSAxes *m_axes;
   QSAxis *m_axis;
   bool m_delete_axis;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdRemoveAxis : public KSCommand
 {
  public:
   KSCmdRemoveAxis( QSAxis *axis );
   virtual ~KSCmdRemoveAxis();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   int m_pos;
   QSAxes *m_axes;
   QSAxis *m_axis;
   bool m_delete_axis;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdAxisOrder : public KSCommand
 {
  public:
   enum CommandType { ToFront, ToBack, Raise, Lower };
   KSCmdAxisOrder( CommandType t, QSAxis *axis );
   virtual ~KSCmdAxisOrder();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   CommandType m_type;
   int m_pos;
   QSAxes *m_axes;
   QSAxis *m_axis;
 };

//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

class QSPage;
class KSCmdAddPage : public KSCommand
 {
  public:
   enum CommandType { ToFront, ToBack, Raise, Lower };
   KSCmdAddPage( QSPage *page, QSWorkbook *workbook );
   virtual ~KSCmdAddPage();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   QSWorkbook *m_workbook;
   QSPage *m_page;
   bool m_delete_page;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdRemovePage : public KSCommand
 {
  public:
   KSCmdRemovePage( QSPage *page, QSWorkbook *workbook );
   virtual ~KSCmdRemovePage();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   QSWorkbook *m_workbook;
   int m_pos;
   QSPage *m_page;
   bool m_delete_page;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdPageOrder : public KSCommand
 {
  public:
   enum CommandType { ToFront, ToBack, Raise, Lower };
   KSCmdPageOrder( CommandType t, QSPage *page, QSWorkbook *workbook );
   virtual ~KSCmdPageOrder();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   CommandType m_type;
   int m_pos;
   QSWorkbook *m_workbook;
   QSPage *m_page;
 };

//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

class KSSheet;
class KSSheetList;
class KSCmdAddSheet : public KSCommand
 {
  public:
   KSCmdAddSheet( KSSheet *sheet, KSSheetList *sheetList );
   virtual ~KSCmdAddSheet();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   KSSheetList *m_sheet_list;
   KSSheet *m_sheet;
   bool m_delete_sheet;
 };

//---------------------------------------------------------------------------------------------//

class KSMatrixWorksheetCellRange;
class KSCmdRemoveSheet : public KSCommand
 {
  public:
   KSCmdRemoveSheet( KSSheet *sheet, KSSheetList *sheetList  );
   virtual ~KSCmdRemoveSheet();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   KSSheetList *m_sheet_list;
   int m_pos;
   KSSheet *m_sheet;
   bool m_delete_sheet;
   QList<KSMatrixWorksheetCellRange> m_cell_range_list;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdSheetOrder : public KSCommand
 {
  public:
   enum CommandType { ToFront, ToBack, Raise, Lower };
   KSCmdSheetOrder( CommandType t, KSSheet *sheet, KSSheetList *sheetList );
   virtual ~KSCmdSheetOrder();	
   virtual bool execute();
   virtual void unexecute();
  protected:
   CommandType m_type;
   int m_pos;
   KSSheetList *m_sheet_list;
   KSSheet *m_sheet;
 };

//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

class QSData;
class QSMatrix;

class KSCmdSetData : public KSCommand
 {
  public:
   KSCmdSetData( QSData *dataObject, int channel, QSMatrix *newMatrix );
   virtual ~KSCmdSetData();
   virtual bool execute();
   virtual void unexecute();
  protected:
   QSData *m_data_object;
   int m_channel;
   QSMatrix *m_new_matrix;
   QSMatrix *m_old_matrix;
   bool m_delete_new_matrix;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdChangeData : public KSCommand
 {
  public:
	KSCmdChangeData( QSMatrix *matrix, int rowFrom, int colFrom, int rowTo, int colTo );
	virtual ~KSCmdChangeData();
	virtual bool execute();
	virtual void unexecute();
  protected:
	QSMatrix *copy_modified_range();
	void apply_buffer( QSMatrix *buffer );
	int m_row_from;
	int m_col_from;
	int m_row_to;
	int m_col_to;
	QSMatrix *m_matrix;
	QSMatrix *m_old_data;
	QSMatrix *m_new_data;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdChangeValue : public KSCommand
 {
  public:
	KSCmdChangeValue( QSMatrix *matrix, int row, int col, const QString& new_value );
	virtual ~KSCmdChangeValue();
	virtual bool execute();
	virtual void unexecute();
  protected:
	QSMatrix *m_matrix;
	int m_row;
	int m_col;
	QString m_old_value;
	QString m_new_value;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdRemoveRows : public KSCommand
 {
  public:
	KSCmdRemoveRows( QSMatrix *matrix, int fromRow, int toRow );
	virtual ~KSCmdRemoveRows();
	bool execute();
	void unexecute();
  protected:
	int m_from_row;
	int m_to_row;
	QSMatrix *m_old_data;
	QSMatrix *m_matrix;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdRemoveCols : public KSCommand
 {
  public:
	KSCmdRemoveCols( QSMatrix *matrix, int fromCol, int toCol );
	virtual ~KSCmdRemoveCols();
	bool execute();
	void unexecute();
  protected:
	int m_from_col;
	int m_to_col;
	QSMatrix *m_old_data;
	QSMatrix *m_matrix;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdRemoveSheetCols : public KSCmdRemoveCols
 {
  public:
	KSCmdRemoveSheetCols( KSSheet *sheet, int fromCol, int toCol );
	virtual ~KSCmdRemoveSheetCols();
	bool execute();
	void unexecute();
  protected:
	KSSheet *m_sheet;
	struct private_data;
	private_data *m_data;		
 };

//---------------------------------------------------------------------------------------------//

class KSCmdInsertRow : public KSCommand
 {
  public:
	KSCmdInsertRow( QSMatrix *matrix, int atPos );
	virtual ~KSCmdInsertRow();
	bool execute();
	void unexecute();
  protected:
	int m_at_pos;
	QSMatrix *m_old_data;
	QSMatrix *m_matrix;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdInsertCol : public KSCommand
 {
  public:
	KSCmdInsertCol( QSMatrix *matrix, int atPos );
	virtual ~KSCmdInsertCol();
	bool execute();
	void unexecute();
  protected:
	int m_at_pos;
	QSMatrix *m_old_data;
	QSMatrix *m_matrix;
 };

//---------------------------------------------------------------------------------------------//

class KSCmdInsertSheetCol : public KSCmdInsertCol
 {
  public:
	KSCmdInsertSheetCol( KSSheet *sheet, int atPos );
	virtual ~KSCmdInsertSheetCol();
	bool execute();
	void unexecute();
  protected:
	KSSheet *m_sheet;
	struct private_data;
	private_data *m_data;	
 };

//---------------------------------------------------------------------------------------------//

class KSCmdMatrixTranspose : public KSCommand
 {
  public:
	KSCmdMatrixTranspose(QSMatrix*matrix);
	virtual ~KSCmdMatrixTranspose();
	virtual bool execute();
	virtual void unexecute();
  protected:
	QSMatrix *m_matrix;
 };

//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

class KSCmdSetProperties : public KSCommand
 {
  public:
	KSCmdSetProperties( QObject *object );
	virtual ~KSCmdSetProperties();
	void setProperty( const char *name, const QVariant& value );
	virtual bool execute();
	virtual void unexecute();
  protected:
	QObject *m_object;
	typedef QMap<QCString,QVariant> PropertyList;
	PropertyList m_new_properties;
	PropertyList m_old_properties;
 };

//---------------------------------------------------------------------------------------------//

class QSGraphicalData;
class KSCmdSetGraphicalProperties : public KSCmdSetProperties
 {
  public:
	KSCmdSetGraphicalProperties( QSGraphicalData *object );
	virtual ~KSCmdSetGraphicalProperties();
	virtual bool execute();
	virtual void unexecute();	
	void setFont( int element, const QSGFont& font );
	void setFill( int element, const QSGFill& fill );
	void setLine( int element, const QSGLine& line );
	void setPoint( int element, const QSGPoint& point );	
  protected:
	QMap<int,QSGFont> m_new_fonts;
	QMap<int,QSGFont> m_old_fonts;
	QMap<int,QSGLine> m_new_lines;
	QMap<int,QSGLine> m_old_lines;
	QMap<int,QSGFill> m_new_fills;
	QMap<int,QSGFill> m_old_fills;
	QMap<int,QSGPoint> m_new_points;
	QMap<int,QSGPoint> m_old_points;
	QSGraphicalData *m_object;
 };


//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

class KSCmdSetRanges : public KSCommand
 {
  public:
	KSCmdSetRanges( QSAxes *axes );
	virtual ~KSCmdSetRanges();
	void commit();
	virtual bool execute();
	virtual void unexecute();
  protected:
	QSAxes *m_axes;
	typedef struct {
		double min;
		double max;
		double base;
		int scale;
		bool round;
		bool reversed;
		} axis_remembered_view_t;
	typedef QPtrDict<axis_remembered_view_t> viewList;
	viewList m_old_ranges;
	viewList m_new_ranges;	
	void save_data( viewList *list );
	void set_data( viewList *list );
 };

#endif



