/***************************************************************************
                                  kmatplotshell.h
                             -------------------
    begin                : Sat Mar 11 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMATPLOTSHELL_H
#define KMATPLOTSHELL_H

#include "widgets/qsconsole.h"
#include <qmainwindow.h>
#include <qwidget.h>
#include <qaction.h>

class QLabel;
class QDockWindow;
class QPrinter;
class QToolbar;
class QTabWidget;
class QTextEdit;
class QSData;
class KSWorkbook;
class KSWorkspace;
class KSSimpleContainer;
class KSSimpleConsole;

/**
  *@author Kamil Dobkowski
  */
class KMatplotShell : public QMainWindow  {
	Q_OBJECT
public:
	KMatplotShell( const char *name=0 );
	virtual ~KMatplotShell();
	KSWorkbook *workbook() { return m_workbook; }
	void refreshSettings();
	virtual bool openFile( const QString& filename );
	virtual bool saveFile( const QString& filename );
	virtual bool mergeFile( const QString& filename );
	KSSimpleContainer *objectContainer() const { return m_object_container; }
	KSSimpleContainer *propertyContainer() const { return m_property_container; }
	QDockWindow *bottomDock() const { return m_bottom_dock; }
	QDockWindow *sideDock() const { return m_side_dock; }

	void disableCustomActions();

	QAction *m_maximize_windows;
	QAction *m_minimize_windows;
	QAction *m_close_window;
	QAction *m_close_all_windows;
	QAction *m_restore_windows;
	QAction *m_hide_window;
	QAction *m_show_window;
	QAction *m_new_worksheet_win;
	QAction *m_new_page_view_win;
	QAction *m_new_edit_data_win;
	QAction *m_tile_windows;
	QAction *m_cascade_windows;

	QAction* m_cut;
	QAction* m_copy;
	QAction* m_copy_all;
	QAction* m_paste;
	QAction* m_delete;
	QAction *m_datasets;
	QAction *m_object_menu;

	QActionGroup *m_zoom;
	QAction *m_zoom_50;
	QAction *m_zoom_75;
	QAction *m_zoom_100;
	QAction *m_zoom_150;
	QAction *m_zoom_200;
	QAction *m_grid;
	QAction *m_ioinfo;

	QAction *m_new_legend;

	QAction *m_wizard;
	QAction *m_new_axes2d;
	QAction *m_new_axes3d;
	QAction *m_new_curve;
	QAction *m_new_image;
	QAction *m_new_contour;
	QAction *m_new_ngcontour;
	QAction *m_new_surface;
	QAction *m_new_figure;
	QAction *m_new_xaxis;
	QAction *m_new_yaxis;
	QAction *m_new_zaxis;
	QAction *m_new_vaxis;

	QAction *m_cut_dataset;
	QAction *m_copy_dataset;
	QAction *m_copy_all_dataset;
	QAction *m_paste_dataset;
	QAction *m_delete_dataset;
	QAction *m_raise_dataset;
	QAction *m_lower_dataset;
	QAction *m_bring_dataset_to_front;
	QAction *m_send_dataset_to_back;

	QAction *m_new_sheet;
	QAction *m_rename_sheet;
	QAction *m_new_matrix;
	QAction *m_new_string;
	QAction *m_new_formula;
	QAction *m_new_reference;
	QAction *m_import_octave;
	QAction *m_export_octave;
	QAction *m_detach;
	QAction *m_transpose;

	QAction *m_cut_sheet;
	QAction *m_copy_sheet;
	QAction *m_copy_all_sheet;
	QAction *m_paste_sheet;
	QAction *m_delete_sheet;

	QAction *m_new_page;
	QAction *m_rename_page;
	QAction *m_delete_page;
	QAction *m_page_to_front;
	QAction *m_page_to_back;
	QAction *m_raise_page;
	QAction *m_lower_page;
	QAction *m_export_picture;

	QAction *m_bring_to_front;
	QAction *m_send_to_back;
	QAction *m_raise;
	QAction *m_lower;
	QAction *m_group;
	QAction *m_ungroup;

	QActionGroup *m_tools;
	QAction *m_tool_zoom;
	QAction *m_tool_locate;
	QAction *m_tool_select;
	QAction *m_tool_label;
	QAction *m_tool_arrow;
	QAction *m_tool_rect;

	QAction *m_hide_sliders;
	QAction *m_apply_button;
	QAction *m_hide_rulers;
	QAction *m_x11_backstoring;
	QAction *m_show_full_page;


public slots:

	void doAction( QAction *action );

	void slotShowHelpMessage( const QString& message );
	void slotShowOutputMessage( const QString& message );
        void slotDataObjectSelected( QSData *data );

	void slotNew();
	void slotOpen();
	void slotMerge();
	void slotSave();
	void slotSaveAs();
	void slotPrinterSetup();
	bool slotPrint();

 	void clearAll();
	void slotUndo();
	void slotRedo();
	void slotCut();
	void slotCopy();
	void slotCopyAll();
	void slotPaste();
	void slotDelete();

	void slotExampleSimple();
	void slotExampleContour();
	void slotExamplePath3d();
	void slotExampleSurface();
	void slotExampleShell();
	void slotAbout();

	void toggleToolBar();
	void slotConfigure();

	void slotNewWorksheetWin();
	void slotNewPageViewWin();
	void slotNewEditDataWin();
	void slotMaximizeWindows();
	void slotMinimizeWindows();
	void slotRestoreWindows();
	void slotHideWindow();
	void slotShowWindow();
	void slotCloseWindow();
	void slotCloseAllWindows();
	void slotTileWindows();
	void slotCascadeWindows();

	void slotNewPage();
	void slotPageZoom( QAction* );
        void slotTool( QAction* );

protected:
	void create_actions();
	void create_dock_areas();
	void load_example( const QString& filename );
	virtual bool queryExit();
        virtual void closeEvent( QCloseEvent* e );

	QPrinter		*m_printer;
	KSWorkbook		*m_workbook;
	QDockWindow		*m_bottom_dock;
	QDockWindow		*m_side_dock;
	QDockWindow		*m_help_dock;
	QTabWidget		*m_side_tab;
	QTabWidget		*m_bottom_tab;
	KSSimpleContainer 	*m_property_container;
	KSSimpleContainer 	*m_object_container;
	KSSimpleContainer 	*m_help_container;
	QLabel			*m_help_message;
	QTextEdit		*m_output_message;
	KSSimpleConsole		*m_console;
	KSWorkspace		*m_workspace;
	QSData			*m_curr_data_object;
	QToolBar		*m_file_toolbar;
	QToolBar		*m_edit_toolbar;
	QToolBar		*m_view_toolbar;
	QToolBar		*m_tool_toolbar;
	QString			m_curr_file;
	QString			m_open_path;
	QString			m_save_path;

	bool			m_auto_apply;
	bool			m_modified;

	QActionGroup *m_toolbars;
	QAction *m_show_side_dock;
	QAction *m_show_help_dock;
	QAction *m_show_bottom_dock;
	QAction *m_show_file_toolbar;
	QAction *m_show_edit_toolbar;
	QAction *m_show_view_toolbar;
	QAction *m_show_tool_toolbar;

	QAction *m_new;
	QAction *m_open;
	QAction *m_merge;
	QAction *m_save;
	QAction *m_save_as;
	QAction *m_print;
	QAction *m_printer_setup;
	QAction *m_exit;

	QAction* m_undo;
	QAction* m_redo;
	QAction *m_configure;

	QAction *m_example_simple;
	QAction *m_example_contour;
	QAction *m_example_3dpath;
	QAction *m_example_surface;
	QAction *m_example_shell;
	QAction *m_about;

private slots:
	void slot_set_dirty();
	void slot_new_undo();
	void slot_new_redo();
	void slot_show_error( const QString& messsage );
	void slot_dock_visiblity_changed( bool visible );
	void slot_show_toolbars();
 };

//------------------------------------------------------------------------------//

class KSSimpleAction : public QAction
 {
	Q_OBJECT
  public:
	KSSimpleAction ( KMatplotShell *shell, QObject * parent, const char * name = 0, bool toggle = FALSE );
	KSSimpleAction ( KMatplotShell *shell, const QString & text, const QIconSet & icon, const QString & menuText, QKeySequence accel, QObject * parent, const char * name = 0, bool toggle = FALSE );
	KSSimpleAction ( KMatplotShell *shell, const QString & text, const QString & menuText, QKeySequence accel, QObject * parent, const char * name = 0, bool toggle = FALSE );
	virtual ~KSSimpleAction();

  protected slots:
	void slot_activated();

  protected:
	KMatplotShell *m_shell;

 };

//------------------------------------------------------------------------------//

class KSSimpleContainer : public QFrame
 {
	Q_OBJECT
   public:
	KSSimpleContainer( QWidget *widget, int w, int h, int margin=0 );
	virtual ~KSSimpleContainer();
	void setWidget( QWidget *widget );
	QWidget *widget() const { return m_widget; }
	virtual QSize sizeHint() const;
   protected:
	virtual void resizeEvent ( QResizeEvent *event );
	QWidget *m_widget;
	QSize m_size;
	int m_margin;
 };

//------------------------------------------------------------------------------//

class KSSimpleConsole : public QSConsole
 {
  public:
	KSSimpleConsole( KMatplotShell *shell );
	virtual ~KSSimpleConsole();
  protected:
	virtual void appendText( const QString& message );
	KMatplotShell *m_shell;
 };


#endif
