/***************************************************************************
                                mpsymbol.cpp
                             -------------------
    begin                : Tue Nov 20 2001
    copyright            : (C) 2001 by Kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mpsymbol.h"
#include <string.h>

//--------------------------------------------------------------------------//

MPSymbol::MPSymbol( MPSymbolList *args, int columnFrom, int columnTo, const char *identifier )
 {
  m_args = args;
  m_rows = 0;
  m_cols = 0;
  m_col_from	= columnFrom;
  m_col_to	= columnTo;
  m_id 		= strdup(identifier);
 }

//--------------------------------------------------------------------------//

MPSymbol::~MPSymbol()
 {
  delete m_args;
  free(m_id);
 }
//--------------------------------------------------------------------------//

void MPSymbol::setArgs( MPSymbolList *args )
 {
  delete m_args; m_args = args;
 }

//--------------------------------------------------------------------------//

void MPSymbol::checkArgs( MPError& error )
 {
  m_rows = 0;
  m_cols = 0;
  if ( !error.hasError() && m_args ) {	
	for( int i=0; i<m_args->count(); i++ ) {
		m_args->at(i)->checkArgs( error ); if ( error.hasError() ) break;
		if ( i>0 && !isSizeEqual( m_args->at(i), m_args->at(i-1) ) ) {
			error.setNonconformantArgument( i+1, m_args->at(i), this );
			return;
			}
		// check if all arguments have the same size
		if ( m_rows < m_args->at(i)->rows() ) m_rows = m_args->at(i)->rows();
		if ( m_cols < m_args->at(i)->cols() ) m_cols = m_args->at(i)->cols();
		}
	}
 }

//--------------------------------------------------------------------------//

bool MPSymbol::isSizeEqual( const MPSymbol *expr1, const MPSymbol *expr2 )
 {
  if ( expr1->isScalar() ||
       expr2->isScalar() ||
       ( expr1->rows() == expr2->rows() &&
	 expr1->cols() == expr2->cols() ) ) return true;
  return false;       	
 }

//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//

MPSymbolList::MPSymbolList()
 {
 }

//--------------------------------------------------------------------------//

MPSymbolList::MPSymbolList( MPSymbol *symbol )
 {
  add( symbol );
 }

//--------------------------------------------------------------------------//

MPSymbolList::MPSymbolList( MPSymbol *symbol1, MPSymbol *symbol2 )
 {
  add( symbol1 );
  add( symbol2 );
 }

//--------------------------------------------------------------------------//

MPSymbolList::~MPSymbolList()
 {
  for( int i=0; i<count(); i++ ) delete m_list[i];
 }

//--------------------------------------------------------------------------//

void MPSymbolList::add( MPSymbol *symbol )
 {
  if ( symbol ) m_list.push_back( symbol );
 }



//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//

MPSymbolFactory::MPSymbolFactory()
 {
 }

//--------------------------------------------------------------------------//

MPSymbolFactory::~MPSymbolFactory()
 {
 }

//--------------------------------------------------------------------------//

/*
unicode not supported yet
bool MPSymbolFactory::wstrcmp( const wchar_t *string1, const wchar_t *string2 )
 {
  if ( string1 == NULL || string2 == NULL ) return false;
  while ( *string1 && *string2 && *string1 == *string2 ) { string1++; string2++; }
  return ( *string1 == *string2 );	
 }
*/

//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//

MPError::MPError()
 {
  m_type = None;
  m_col_from = 0;
  m_col_to = 0;
 }

//--------------------------------------------------------------------------//

MPError::~MPError()
 {
 }

//--------------------------------------------------------------------------//

void MPError::setWrongNumberOfArguments( int, int, MPSymbol *symbol )
 {
  if ( m_type == None ) {
  	m_type = WrongNumberOfArgs;
 	m_col_from = symbol->colFrom();
	m_col_to   = symbol->colTo();
	}
 }

//--------------------------------------------------------------------------//

void MPError::setNonconformantArgument( int, MPSymbol *arg, MPSymbol * )
 {
  if ( m_type == None ) {
  	m_type = NonconformantArgs;
	m_col_from = arg->colFrom();
	m_col_to   = arg->colTo();
	}
 }

//--------------------------------------------------------------------------//

void MPError::setUndefinedSymbol( const char *, int colFrom, int colTo )
 {
  if ( m_type == None ) {
  	m_type = UndefinedSymbol;
	m_col_from = colFrom;
	m_col_to   = colTo;
	}
 }

//--------------------------------------------------------------------------//

void MPError::setParseError( int colFrom, int colTo )
 {
  if ( m_type == None ) {
  	m_type = ParseError;
	m_col_from = colFrom;
	m_col_to   = colTo;
	}
 }

//--------------------------------------------------------------------------//

void MPError::setError( const char *, MPSymbol *symbol )
 {
  if ( m_type == None ) {
  	m_type = Custom;
	m_col_from = symbol->colFrom();
	m_col_to   = symbol->colTo();
	}
 }




