/***************************************************************************
                                mpformula.h
                             -------------------
    begin                : Sun Nov 18 2001
    copyright            : (C) 2001 by Kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MPFORMULA_H
#define MPFORMULA_H

#include <qstring.h>
#include <qlist.h>
#include "mpparser.cpp.h"
#include "mpparsersymbol.h"

//---------------------------------------------------------------------------//

/**
  * List of factories
  */
class MPFactoryList : public QList<MPSymbolFactory>
 {
  public:
	MPFactoryList() : QList<MPSymbolFactory>() { setAutoDelete(TRUE); }
	MPFactoryList( MPSymbolFactory *oneElement ) { setAutoDelete(TRUE); append(oneElement); }
	~MPFactoryList() {}
 };

//---------------------------------------------------------------------------//
/**
  * Parses string and returns an expression tree.
  * MPSymbol *QSFormula::parse( const QString& formula, MPError& error, FactoryList *locals )
  * @author Kamil
  */
class MPFormula {
	friend int yylex( MPParserSymbol *symbol_value, void *location_info_ptr, void *formula_ptr );
	friend void yyerr(  const char *message, void *location_info_ptr, void *formula_ptr );
	friend int yyparse( void *formula_ptr );
  public:
	/**
	  * Constructor.
	  */
	MPFormula();
	/**
	  * Destructor
	  */
	virtual ~MPFormula();
	/**
	  * Parses the given string and returns expression. If the error occurs the NULL is
	  * returned and error info is passes in 'error' object.
	  */
	MPSymbol *parse( const QString& formula, MPError& error, MPFactoryList *locals=NULL );
	/**
	  * Adds global symbols. They will be shared by all QSFormula objects.
	  */
	static void addGlobalSymbols( MPSymbolFactory *factory );
	/**
	  * Removes a global symbols.
	  */
	static void delGlobalSymbols( MPSymbolFactory *factory );

  private:
	int			 m_char;
	QString			 m_formula;
	MPSymbol		*m_root_sym;
	MPError			*m_error;
	MPFactoryList		*m_local_symbols;
 	static MPFactoryList	 m_global_symbols;

	QChar curr_char() const;
	QChar apply_char( QString& append_to );
	MPSymbol *get_symbol( const QString &id, MPSymbolList *args, int colFrom, int colTo );
	};

//----------------------------------------------------------------------------------------------//

class MPFormulaError : public MPError {
      public:
	MPFormulaError();
	virtual ~MPFormulaError();
	virtual void setWrongNumberOfArguments( int currArgs, int correctArgs, MPSymbol *expression );
	virtual void setNonconformantArgument( int arg_nr, MPSymbol *expression, MPSymbol *sym );
	virtual void setUndefinedSymbol( const char *symbol, int colFrom, int colTo );
	virtual void setParseError( int colFrom, int colTo );
	virtual void setError( const char *message, MPSymbol *expression );
	QString message() { return m_msg; }
      private:
	QString m_msg;
	QString standard_message( MPSymbol *expression );
   };

#endif
