/***************************************************************************
                          kstextedit.h  -  description
                             -------------------
    begin                : Fri Feb 15 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTEXTEDIT_H
#define KSTEXTEDIT_H

#include<qwidget.h>
#include<qframe.h>
#include<qstring.h>
#include<qdialog.h>
#include<qtextedit.h>
#include"../widgets/qsgattr.h"

class QLineEdit;
class QPushButton;
class QTextEdit;
class QMenuBar;
class QDockArea;
class QAction;
class QComboBox;
class QFont;

//----------------------------------------------------------------------------------------------//

/**
  *@author kamil
  */
class KSTextEdit : public QFrame  {
   Q_OBJECT
public: 
	KSTextEdit(QWidget *parent, const char *name=0 );
	virtual ~KSTextEdit();
	void setBaseFont( const QSGFont& baseFont );
	void setText( const QString& text );
	QString text() const { return m_text; }
signals:
	void changed();
protected:
	QLineEdit *m_line;
	QPushButton *m_button;
	QString m_text;
	QSGFont m_base_font;

protected slots:
	void show_dialog();
	void change_first_line();
};

//----------------------------------------------------------------------------------------------//

/**
` * Rich text edit dialog.
  */
class KSTextEditDlg : public QDialog {
	Q_OBJECT
public:
	KSTextEditDlg( QWidget *parent, const QString& text, const QSGFont& baseFont );
	virtual ~KSTextEditDlg();
	QString text() const;

protected:
 	void setup_actions();
	QPushButton *m_button_ok;
	QPushButton *m_button_cancel;
	QTextEdit *m_text_edit;
	QMenuBar *m_menu;
	QDockArea *m_toolbars_area;
	QAction *m_action_text_bold;
	QAction *m_action_text_underline;
	QAction *m_action_text_italic;
	QAction *m_action_text_color;
	QAction *m_action_align_left;
	QAction *m_action_align_center;
	QAction *m_action_align_right;
	QAction *m_action_align_justify;
	QAction *m_action_valign_sup;
	QAction *m_action_valign_sub;
	QComboBox *m_combo_style;
	QComboBox *m_combo_font;
	QComboBox *m_combo_size;

private slots:
	void slotImport();
	void slotExport();
	void slotUndo();
	void slotRedo();
	void slotCut();
	void slotCopy();
	void slotPaste();
	void slotTextBold();
	void slotTextUnderline();
	void slotTextItalic();
	void slotTextFamily( const QString &family );
	void slotTextSize( const QString &size );
	void slotTextStyle( int style );
	void slotTextColor();
	void slotTextAlign( QAction *action );
	void slotTextVAlignSubScript();
 	void slotTextVAlignSuperScript();
        void slotTextSymbol(const QString &text );
	void slot_font_changed( const QFont &font );
	void slot_alignment_changed( int alignment );
        typedef QTextEdit::VerticalAlignment VerticalAlignment;
	void slot_valignment_changed( VerticalAlignment );
 };

//----------------------------------------------------------------------------------------------//

#endif
