/***************************************************************************
                          kstextedit.cpp  -  description
                             -------------------
    begin                : Fri Feb 15 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include"kstextedit.h"
#include<qlayout.h>
#include<qpushbutton.h>
#include<qlineedit.h>
#include<qtextedit.h>
#include<qmenubar.h>
#include<qpopupmenu.h>
#include<qregexp.h>
#include<qcombobox.h>
#include<qdockarea.h>
#include<qtoolbar.h>
#include<qapplication.h>
#include<qmainwindow.h>
#include <qaction.h>
#include <qfontdatabase.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <qmessagebox.h>
#include <qlistbox.h>

#include"../pixmaps/action_open.xpm"
#include"../pixmaps/action_save.xpm"
#include"../pixmaps/action_undo.xpm"
#include"../pixmaps/action_redo.xpm"
#include"../pixmaps/action_cut.xpm"
#include"../pixmaps/action_copy.xpm"
#include"../pixmaps/action_paste.xpm"
#include"../pixmaps/action_textbold.xpm"
#include"../pixmaps/action_textitalic.xpm"
#include"../pixmaps/action_textunderline.xpm"
#include"../pixmaps/action_textleft.xpm"
#include"../pixmaps/action_textcenter.xpm"
#include"../pixmaps/action_textright.xpm"
#include"../pixmaps/action_textjustify.xpm"
#include"../pixmaps/action_textcolor.xpm"
#include"../pixmaps/action_textsubscript.xpm"
#include"../pixmaps/action_textsuperscript.xpm"

#include"../widgets/qsdrvqt.h"

//---------------------------------------------------------------------------//

KSTextEdit::KSTextEdit(QWidget *parent, const char *name  )
 : QFrame(parent,name)
 {
  setFrameStyle( StyledPanel | Sunken );
  setLineWidth( 2 );
  setFixedHeight( 22 );
  QHBoxLayout *layout = new QHBoxLayout( this, 2, 1 );
  layout->setAutoAdd( TRUE );
  m_line = new QLineEdit( this ); m_line->setFrameStyle( NoFrame | Plain );
  m_button = new QPushButton( tr("..."), this );
  connect( m_button, SIGNAL(clicked()), this, SLOT(show_dialog()) );
  connect( m_line, SIGNAL(returnPressed()), this, SLOT(change_first_line()) );
 }

//---------------------------------------------------------------------------//

KSTextEdit::~KSTextEdit()
 {
 }

//---------------------------------------------------------------------------//

void KSTextEdit::setText( const QString& text )
 {
  m_text = text;
  m_line->setText( text );
 }

//---------------------------------------------------------------------------//

void KSTextEdit::setBaseFont( const QSGFont& baseFont )
 {
  m_base_font = baseFont;
 }

//---------------------------------------------------------------------------//

void KSTextEdit::show_dialog()
 {
  KSTextEditDlg dlg( this, m_text, m_base_font );
  if ( dlg.exec() ) { setText( dlg.text() ); emit changed(); }
 }

//---------------------------------------------------------------------------//

void KSTextEdit::change_first_line()
 {
  setText( m_line->text() );
  emit changed();
 }


//---------------------------------------------------------------------------//
//---------------------------------------------------------------------------//
//---------------------------------------------------------------------------//
//---------------------------------------------------------------------------//
//---------------------------------------------------------------------------//
//---------------------------------------------------------------------------//


KSTextEditDlg::KSTextEditDlg( QWidget *parent, const QString& text, const QSGFont& baseFont )
: QDialog( parent, NULL, TRUE )
 {
  setCaption( tr("Enter text") );
  resize( 470, 350 );
  m_menu = new QMenuBar( this );
  m_toolbars_area = new QDockArea( Horizontal, QDockArea::Normal, this );
  QGridLayout *layout = new QGridLayout( this, 3, 4, 1, 1 );

  //QStyleSheet *sheet = new QStyleSheet( this );
  //sheet->item("p")->setLineSpacing( 0 );
  //sheet->item("p")->setFontFamily(baseFont.family);
  //sheet->item("p")->setColor( QSDrvQt::toQColor(baseFont.color) );

  //QStyleSheet::defaultSheet()->item("p")->setFontFamily("Symbol");

  m_text_edit = new QTextEdit( text, QString::null, this );
  m_button_ok = new QPushButton( tr("OK"),this );
  m_button_cancel = new QPushButton( tr("Cancel"), this );
  layout->setMenuBar( m_menu );
  layout->addMultiCellWidget( m_toolbars_area, 0, 0, 0, 3 );
  layout->addMultiCellWidget( m_text_edit, 1, 1, 0, 3 );
  layout->addWidget( m_button_ok, 2, 1 );
  layout->addWidget( m_button_cancel, 2, 3 );
  layout->setColStretch( 0, 100 );
  layout->addRowSpacing( 2, 35 );
  layout->addColSpacing( 2, 10 );
  m_text_edit->setTextFormat( RichText );
  m_text_edit->setWordWrap( QTextEdit::NoWrap );
  //m_text_edit->setStyleSheet( sheet );

  m_button_ok->setDefault ( FALSE );
  m_button_cancel->setDefault ( FALSE );
  connect( m_button_ok, SIGNAL(clicked()), this, SLOT(accept()) );
  connect( m_button_cancel, SIGNAL(clicked()), this, SLOT(reject()) );
  setup_actions();
  //m_text_edit->setCurrentFont( QSDrvQt::toQFont(baseFont,72.0) );
  //m_text_edit->setColor( QSDrvQt::toQColor(baseFont.color) );
  //m_text_edit->setFont( QSDrvQt::toQFont(baseFont) );
  //cout <<  " set font " << QSDrvQt::toQFont(baseFont).family() << endl;
 }

//---------------------------------------------------------------------------//

void KSTextEditDlg::setup_actions()
 {
 QToolBar *file_toolbar = new QToolBar( "Text file toolbar", (QMainWindow *)qApp->mainWidget(), m_toolbars_area );
 file_toolbar->dock();
 file_toolbar->setMovingEnabled( FALSE );

 QPopupMenu *file_menu = new QPopupMenu( this );
 m_menu->insertItem( tr("&File"), file_menu );

 QAction *action_import = new QAction( tr("Import"), QPixmap(action_open), tr("&Import..."),CTRL+Key_I, this, "text_file_import" );
 connect( action_import, SIGNAL(activated()), this, SLOT(slotImport()) );
 action_import->addTo( file_toolbar );
 action_import->addTo( file_menu );

 QAction *action_export = new QAction( tr("Export"), QPixmap(action_save), tr("&Export..."), CTRL + Key_E, this, "text_file_export" );
 connect( action_export, SIGNAL(activated()), this, SLOT(slotExport()) );
 action_export->addTo( file_toolbar );
 action_export->addTo( file_menu );

 //-----------------------------------------------------------------------------------------------------------//

 QToolBar *edit_toolbar = new QToolBar( "Text edit toolbar", (QMainWindow *)qApp->mainWidget(), m_toolbars_area );
 edit_toolbar->dock();
 edit_toolbar->setMovingEnabled( FALSE );
 QPopupMenu *edit_menu = new QPopupMenu( this );
 m_menu->insertItem( tr("&Edit"), edit_menu );

 QAction *action_edit_undo = new QAction( tr("Undo"), QPixmap(action_undo), tr("&Undo"), CTRL+Key_Z, this, "text_undo" );
 connect( action_edit_undo, SIGNAL(activated()), this, SLOT(slotUndo()) );
 action_edit_undo->addTo( edit_toolbar );
 action_edit_undo->addTo( edit_menu );

 QAction *action_edit_redo = new QAction( tr("Redo"), QPixmap(action_redo), tr("&Redo"), CTRL+Key_Y, this, "text_redo" );
 connect( action_edit_redo, SIGNAL(activated()), this, SLOT(slotRedo()) );
 action_edit_redo->addTo( edit_toolbar );
 action_edit_redo->addTo( edit_menu );
 edit_menu->insertSeparator();

 QAction *action_edit_copy = new QAction( tr("Copy"), QPixmap(action_copy), tr("&Copy"), CTRL+Key_C, this, "text_copy" );
 connect( action_edit_copy, SIGNAL( activated() ), this, SLOT(slotCopy()) );
 action_edit_copy->addTo( edit_toolbar );
 action_edit_copy->addTo( edit_menu );

 QAction *action_edit_cut = new QAction( tr("Cut"), QPixmap(action_cut), tr("Cu&t"), CTRL+Key_X, this, "text_cut" );
 connect( action_edit_cut, SIGNAL(activated()), this, SLOT(slotCut()) );
 action_edit_cut->addTo( edit_toolbar );
 action_edit_cut->addTo( edit_menu );

 QAction *action_edit_paste = new QAction( tr( "Paste" ), QPixmap(action_paste), tr("&Paste"), CTRL+Key_V, this, "text_paste" );
 connect( action_edit_paste, SIGNAL(activated()), this, SLOT(slotPaste()) );
 action_edit_paste->addTo( edit_toolbar );
 action_edit_paste->addTo( edit_menu );

 //----------------------------------------------------------------------------------------------------------//

 QPopupMenu *format_menu = new QPopupMenu( this );
 m_menu->insertItem( tr("F&ormat"), format_menu );

 QToolBar *format_toolbar = new QToolBar( "Format toolbar", (QMainWindow *)qApp->mainWidget(), m_toolbars_area );
 format_toolbar->dock();
 format_toolbar->setMovingEnabled( FALSE );

 m_action_text_bold = new QAction( tr("Bold"), QPixmap(action_textbold), tr("&Bold"), CTRL+Key_B, this, "text_bold" );
 connect( m_action_text_bold, SIGNAL(activated()), this, SLOT(slotTextBold()) );
 m_action_text_bold->addTo( format_toolbar );
 m_action_text_bold->addTo( format_menu );
 m_action_text_bold->setToggleAction( TRUE );

 m_action_text_italic = new QAction( tr("Italic"), QPixmap(action_textitalic), tr("&Italic"), CTRL+Key_I, this, "text_italic" );
 connect( m_action_text_italic, SIGNAL(activated()), this, SLOT(slotTextItalic()) );
 m_action_text_italic->addTo( format_toolbar );
 m_action_text_italic->addTo( format_menu );
 m_action_text_italic->setToggleAction( TRUE );

 m_action_text_underline = new QAction( tr("Underline"), QPixmap(action_textunderline), tr("&Underline"), CTRL+Key_U, this, "text_underline" );
 connect( m_action_text_underline, SIGNAL( activated() ), this, SLOT(slotTextUnderline()) );
 m_action_text_underline->addTo( format_toolbar );
 m_action_text_underline->addTo( format_menu );
 m_action_text_underline->setToggleAction( TRUE );
 format_menu->insertSeparator();


 m_action_valign_sub = new QAction( tr("Subscript"), QPixmap(action_textsubscript), tr("Su&bscript"), CTRL+Key_B, this, "text_subscript" );
 connect( m_action_valign_sub, SIGNAL( activated() ), this, SLOT(slotTextVAlignSubScript()) );
 m_action_valign_sub->addTo( format_toolbar );
 m_action_valign_sub->addTo( format_menu );
 m_action_valign_sub->setToggleAction( TRUE );

 m_action_valign_sup = new QAction( tr("Supscript"), QPixmap(action_textsuperscript), tr("Su&pscript"), CTRL+Key_P, this, "text_supscript" );
 connect( m_action_valign_sup, SIGNAL( activated() ), this, SLOT(slotTextVAlignSuperScript()) );
 m_action_valign_sup->addTo( format_toolbar );
 m_action_valign_sup->addTo( format_menu );
 m_action_valign_sup->setToggleAction( TRUE );

 QActionGroup *align_group = new QActionGroup( this );
 align_group->setExclusive( TRUE );
 connect( align_group, SIGNAL(selected(QAction*)), this, SLOT(slotTextAlign(QAction*)) );

 m_action_align_left = new QAction( tr("Left"), QPixmap(action_textleft), tr("&Left"), CTRL+Key_L, align_group, "text_left" );
 m_action_align_left->addTo( format_toolbar );
 m_action_align_left->addTo( format_menu );
 m_action_align_left->setToggleAction( TRUE );
 m_action_align_center = new QAction( tr("Center"), QPixmap(action_textcenter), tr("C&enter"), CTRL+Key_E, align_group, "text_center" );
 m_action_align_center->addTo( format_toolbar );
 m_action_align_center->addTo( format_menu );
 m_action_align_center->setToggleAction( TRUE );
 m_action_align_right = new QAction( tr("Right"), QPixmap(action_textright), tr("&Right"), CTRL+Key_R, align_group, "text_right" );
 m_action_align_right->addTo( format_toolbar );
 m_action_align_right->addTo( format_menu );
 m_action_align_right->setToggleAction( TRUE );
 m_action_align_justify = new QAction( tr("Justify"), QPixmap(action_textjustify), tr("&Justify"), CTRL+Key_J, align_group, "text_justify" );
 m_action_align_justify->addTo( format_toolbar );
 m_action_align_justify->addTo( format_menu );
 m_action_align_justify->setToggleAction( TRUE );

 format_menu->insertSeparator();

 m_action_text_color = new QAction( tr("Color"), QPixmap(action_textcolor), tr("&Color..."), 0, this, "text_color" );
 connect( m_action_text_color, SIGNAL(activated()), this, SLOT(slotTextColor()) );
 m_action_text_color->addTo( format_toolbar );
 m_action_text_color->addTo( format_menu );

 //----------------------------------------------------------------------------------------------------------//

 QToolBar *font_toolbar = new QToolBar( "Format toolbar", (QMainWindow *)qApp->mainWidget(), m_toolbars_area );
 font_toolbar->dock();
 font_toolbar->setMovingEnabled( FALSE );
 m_combo_style = new QComboBox( FALSE, font_toolbar );
 m_combo_style->insertItem( "Standard" );
 m_combo_style->insertItem( "Bullet List (Disc)" );
 m_combo_style->insertItem( "Bullet List (Circle)" );
 m_combo_style->insertItem( "Bullet List (Square)" );
 m_combo_style->insertItem( "Ordered List (Decimal)" );
 m_combo_style->insertItem( "Ordered List (Alpha lower)" );
 m_combo_style->insertItem( "Ordered List (Alpha upper)" );
 connect( m_combo_style, SIGNAL(activated(int)), this, SLOT(slotTextStyle(int)) );

 QFontDatabase font_list;
 m_combo_font = new QComboBox( TRUE, font_toolbar );
 m_combo_font->insertStringList( font_list.families() );
 m_combo_font->lineEdit()->setText( QApplication::font().family() );
 connect( m_combo_font, SIGNAL(activated(const QString&)), this, SLOT(slotTextFamily(const QString &)) );

 m_combo_size = new QComboBox( TRUE, font_toolbar );
 m_combo_size->lineEdit()->setText( QString::number(QApplication::font().pointSize()) );
 QValueList<int> sizes = font_list.standardSizes();
 QValueList<int>::Iterator it = sizes.begin();
 for ( ;it!=sizes.end();++it ) m_combo_size->insertItem( QString::number(*it) );
 connect( m_combo_size, SIGNAL(activated(const QString&)), this, SLOT(slotTextSize(const QString &)) );

 QComboBox *m_combo_symbol = new QComboBox( TRUE, font_toolbar );
 //m_combo_symbol->setListBox( new QListBox(m_combo_symbol) );
 //m_combo_symbol->setEditable( FALSE );
 for ( int i='a';i<='z';i++) m_combo_symbol->insertItem( QChar((char )i) );
 for ( int i='A';i<='Z';i++) m_combo_symbol->insertItem( QChar((char )i) );
 m_combo_symbol->listBox()->setColumnMode( 10 );
 m_combo_symbol->listBox()->viewport()->setBackgroundMode( PaletteBase );
 m_combo_symbol->listBox()->setVScrollBarMode( QScrollView::AlwaysOff );
 m_combo_symbol->listBox()->setHScrollBarMode( QScrollView::AlwaysOff );
 m_combo_symbol->listBox()->setMinimumWidth(  m_combo_symbol->listBox()->sizeHint().width()+10  );
 m_combo_symbol->listBox()->setMinimumHeight( m_combo_symbol->listBox()->sizeHint().height()+10 );
 m_combo_symbol->listBox()->setFont( QFont("Symbol",16) );
 m_combo_symbol->setFont( QFont("Symbol",16) );
 connect( m_combo_symbol, SIGNAL(activated(const QString&)), this, SLOT(slotTextSymbol(const QString &)) );

//---------------------------------------------------------------------------//

 connect( m_text_edit, SIGNAL(currentFontChanged(const QFont &)), this, SLOT(slot_font_changed(const QFont &)) );
 connect( m_text_edit, SIGNAL(currentAlignmentChanged(int)), this, SLOT(slot_alignment_changed(int)) );
 connect( m_text_edit, SIGNAL(currentVerticalAlignmentChanged(VerticalAlignment)), this, SLOT(slot_valignment_changed(VerticalAlignment)) );
 }

//---------------------------------------------------------------------------//

KSTextEditDlg::~KSTextEditDlg()
 {
  //delete file_toolbar;
 }

//---------------------------------------------------------------------------//

QString KSTextEditDlg::text() const
 {
  return m_text_edit->text();
 }

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotImport()
{
 QString file_name = QFileDialog::getOpenFileName( QString::null, tr( "HTML-Files (*.htm *.html);;All Files (*)" ), this );
 if ( !file_name.isEmpty() ) {
	if ( !QFile::exists(file_name) ) { QMessageBox::critical( this, tr("Error"), tr("File does not exist !"), 0, 0 ); return; }
	QFile file( file_name );
	if ( !file.open(IO_ReadOnly) ) { QMessageBox::critical( this, tr("Error"), tr("Can't open the file !"), 0, 0 ); return; }
	QTextStream text_stream( &file );
	m_text_edit->setText( text_stream.read() );	
	}
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotExport()
{
 QString file_name = QFileDialog::getSaveFileName( QString::null, tr( "HTML-Files (*.htm *.html);;All Files (*)" ), this );
 if ( !file_name.isEmpty() ) {
	QFile file( file_name );
	if ( !file.open(IO_WriteOnly) ) { QMessageBox::critical( this, tr("Error"), tr("Can't open the file !"), 0, 0 ); return; }
	QTextStream text_stream( &file );
	text_stream << m_text_edit->text();
	}
}


//---------------------------------------------------------------------------//

void KSTextEditDlg::slotUndo()
{
 m_text_edit->undo();
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotRedo()
{
 m_text_edit->redo();
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotCut()
{
 m_text_edit->cut();
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotCopy()
{
 m_text_edit->copy();
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotPaste()
{
 m_text_edit->paste();
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextBold()
{
 m_text_edit->setBold( m_action_text_bold->isOn() );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextUnderline()
{
 m_text_edit->setUnderline( m_action_text_underline->isOn() );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextItalic()
{
 m_text_edit->setItalic( m_action_text_italic->isOn() );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextFamily( const QString &font )
{
 m_text_edit->setFamily( font );
 m_text_edit->setFocus();
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextSize( const QString &size )
{
 m_text_edit->setPointSize( size.toInt() );
 m_text_edit->setFocus();
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextStyle( int style )
{
 if ( style == 0 ) m_text_edit->setParagType( QStyleSheetItem::DisplayBlock, QStyleSheetItem::ListDisc );
 else if ( style == 1 ) m_text_edit->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListDisc );
 else if ( style == 2 ) m_text_edit->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListCircle );
 else if ( style == 3 ) m_text_edit->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListSquare );
 else if ( style == 4 ) m_text_edit->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListDecimal );
 else if ( style == 5 ) m_text_edit->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListLowerAlpha );
 else if ( style == 6 ) m_text_edit->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListUpperAlpha );
 m_text_edit->setFocus();
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextColor()
{
 QColor col = QColorDialog::getColor( m_text_edit->color(), this );
 if ( col.isValid() ) { m_text_edit->setColor( col ); }
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextAlign( QAction *action )
{
 if ( action == m_action_align_left ) m_text_edit->setAlignment( AlignLeft );
 else if ( action == m_action_align_center ) m_text_edit->setAlignment( AlignHCenter );
 else if ( action == m_action_align_right  ) m_text_edit->setAlignment( AlignRight );
 else if ( action == m_action_align_justify ) m_text_edit->setAlignment( AlignJustify );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slot_font_changed( const QFont &font )
{
 m_combo_font->lineEdit()->setText( font.family() );
 m_combo_size->lineEdit()->setText( QString::number(font.pointSize()) );
 m_action_text_bold->setOn( font.bold() );
 m_action_text_italic->setOn( font.italic() );
 m_action_text_underline->setOn( font.underline() );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slot_alignment_changed( int align )
{
 if ( ( align == AlignAuto ) || ( align & AlignLeft )) m_action_align_left->setOn( TRUE );
 else if ( ( align & AlignHCenter ) ) m_action_align_center->setOn( TRUE );
 else if ( ( align & AlignRight   ) ) m_action_align_right->setOn( TRUE );
 else if ( ( align & AlignJustify ) ) m_action_align_justify->setOn( TRUE );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextVAlignSubScript()
{
 if ( m_action_valign_sub->isOn() ) m_text_edit->setVerticalAlignment( QTextEdit::AlignSubScript );
			       else m_text_edit->setVerticalAlignment( QTextEdit::AlignNormal    );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextVAlignSuperScript()
{
 if ( m_action_valign_sup->isOn() ) m_text_edit->setVerticalAlignment( QTextEdit::AlignSuperScript );
			       else m_text_edit->setVerticalAlignment( QTextEdit::AlignNormal      );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slot_valignment_changed( KSTextEditDlg::VerticalAlignment alignment )
{
 m_action_valign_sub->setOn( alignment == QTextEdit::AlignSubScript   );
 m_action_valign_sup->setOn( alignment == QTextEdit::AlignSuperScript );
}

//---------------------------------------------------------------------------//

void KSTextEditDlg::slotTextSymbol(const QString &text )
 {
  QString family = m_text_edit->family();
  m_text_edit->setFamily("Symbol");
  m_text_edit->insert(text);
  m_text_edit->setFamily(family);
 }