/***************************************************************************
                                 ksexportdlg.cpp
                             -------------------
    begin                : Thu Feb 10 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksexportdlg.h"
#include "../ksmatrixio.h"
#include "../ksglobalmatrixlist.h"
#include "../ksdataobjectfactory.h"
#include "kschannellist.h"
#include <qfiledialog.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qregexp.h>

QString KSExportDlg::m_file_name;

//-----------------------------------------------------------//

KSExportDlg::KSExportDlg(QSData *data, QWidget *parent, const char *name)
: KSExportDlgInterf(parent,name,true)
 {
  chanList->addColumn( tr(" Channel name"), 150 );
  chanList->addColumn( tr(" Channel name"), 85 );
  chanList->addColumn( tr(" RowsxCols"), 60 );
  chanList->addColumn( tr(" Action "), 60 );

  if ( dynamic_cast<KSSheetList*>(data) ) chanList->setDataObject( data, false, 0, false  );
				     else chanList->setDataObject( data, true, -1, true  );
  filename->setText( m_file_name );

  connect( bbrowse, SIGNAL(clicked()), this, SLOT(chooseFile()) );
  connect( bexport, SIGNAL(clicked()), this, SLOT(markChannel()) );
  connect( bok,     SIGNAL(clicked()), this, SLOT(accept()) );
  connect( bcancel, SIGNAL(clicked()), this, SLOT(reject()) );
 }

//-----------------------------------------------------------//

KSExportDlg::~KSExportDlg()
 {
 }

//-----------------------------------------------------------//

void KSExportDlg::markChannel()
 {
  KSChannelListItem *citem = chanList->selected();
  if ( citem && citem->isValid() ) {
	if ( citem->text(3).isEmpty() ) citem->setText( 3, tr("Export") );
	                           else citem->setText( 3, QString::null  );
	}
 }

//-----------------------------------------------------------//

void KSExportDlg::chooseFile()
 {
  QString result = QFileDialog::getSaveFileName( m_file_name.isEmpty() ? QDir::homeDirPath() : m_file_name,
                                        tr("*| All files (*)"),
					this, "export_dialog",
					tr("Export to..."));
  if ( !result.isEmpty() ) {
        m_file_name = result;
        filename->setText( m_file_name );
       }
 }

//-----------------------------------------------------------//

void KSExportDlg::saveAll()
 {
  m_file_name = filename->text().stripWhiteSpace();
  if ( m_file_name.isEmpty() ) return;

  KSMatrixIO io( m_file_name, IO_WriteOnly );
  KSChannelListItem *citem = chanList->first();
  while ( citem ) {
         if ( citem->isValid() && !citem->text(3).isEmpty() ) {
                 QString mname = QString("c") +
				 KSDataObjectFactory::channelNameFactory(citem->dataObject(),citem->channel()).lower().stripWhiteSpace()+
				 QString::number(citem->channel());
                 
		 mname.replace( QRegExp("\\s+" ), "_" );
		 mname.replace( QRegExp("\\-+" ), "_" );
		 mname.replace( QRegExp("\\.+" ), "_" );
                 QSMatrix *m = citem->dataObject()->matrix( citem->channel() );
                 if ( m ) io.saveMatrix( m, mname, "ASCII" );
                }

         // process the next item
	 citem = citem->next();
        }
 }

//-----------------------------------------------------------//

