/***************************************************************************
                                 spdeletedialog.cpp                             
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "ksdatasetdlg.h"
#include "kschannellist.h"
//#include "../kmatplotshell.h"
#include "../ksworkbook.h"
#include "../kscommands.h"
#include "../ksobjectfactory.h"
#include "../widgets/qsplot.h"
#include "../widgets/qsaxes.h"
#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qcursor.h>

//-----------------------------------------------------------//

KSDatasetDlg::KSDatasetDlg( KSWorkbook *workbook, QSAxes *axes, QWidget *parent, const char *name )
: KSDatasetDlgInterf(parent,name,true)
 {
  setCaption(tr("Current axes - Datasets"));

  m_workbook = workbook;
  m_axes = axes;

  chanList->setGeometry(20,30,410,220);
  chanList->setDataObject( axes, false, -1 );	
  chanList->addColumn( tr(" Channel name"), 380 );

  connect( bok,     SIGNAL(clicked()), this, SLOT(accept()) );
  connect( bfront,  SIGNAL(clicked()), this, SLOT(slot_to_front()) );
  connect( bback,   SIGNAL(clicked()), this, SLOT(slot_to_back()) );
  connect( buttonRaise, SIGNAL(clicked()), this, SLOT(slot_raise()) );
  connect( buttonLower, SIGNAL(clicked()), this, SLOT(slot_lower()) );
  connect( chanList, SIGNAL(rightButtonPressed(QListViewItem*,const QPoint&,int)),this,SLOT(slot_show_menu(QListViewItem*,const QPoint&,int)) );
 }

//-----------------------------------------------------------//

KSDatasetDlg::~KSDatasetDlg()
 {
 }

//-----------------------------------------------------------//

void KSDatasetDlg::slot_to_front()
 {
  if ( chanList->selected() && chanList->selected()->dataObject() ) {
	 QSPlot *plot = dynamic_cast<QSPlot*>(chanList->selected()->dataObject());
         QSAxis *axis = dynamic_cast<QSAxis*>(chanList->selected()->dataObject());
         if ( plot ) m_workbook->execute( new KSCmdDatasetOrder( KSCmdDatasetOrder::ToFront,plot) );
         if ( axis ) m_workbook->execute( new KSCmdAxisOrder( KSCmdAxisOrder::ToFront,axis) );
	}
 }

//-----------------------------------------------------------//

void KSDatasetDlg::slot_to_back()
 {
  if ( chanList->selected() && chanList->selected()->dataObject() ) {
	 QSPlot *plot = dynamic_cast<QSPlot*>(chanList->selected()->dataObject());
         QSAxis *axis = dynamic_cast<QSAxis*>(chanList->selected()->dataObject());
         if ( plot ) m_workbook->execute( new KSCmdDatasetOrder( KSCmdDatasetOrder::ToBack,plot) );
         if ( axis ) m_workbook->execute( new KSCmdAxisOrder( KSCmdAxisOrder::ToBack,axis) );
	}
 }

//-----------------------------------------------------------//

void KSDatasetDlg::slot_raise()
 {
  if ( chanList->selected() && chanList->selected()->dataObject() ) {
	 QSPlot *plot = dynamic_cast<QSPlot*>(chanList->selected()->dataObject());
         QSAxis *axis = dynamic_cast<QSAxis*>(chanList->selected()->dataObject());
         if ( plot ) m_workbook->execute( new KSCmdDatasetOrder( KSCmdDatasetOrder::Raise,plot) );
         if ( axis ) m_workbook->execute( new KSCmdAxisOrder( KSCmdAxisOrder::Raise,axis) );
	}
 }

 //-----------------------------------------------------------//

void KSDatasetDlg::slot_lower()
 {
  if ( chanList->selected() && chanList->selected()->dataObject() ) {
	 QSPlot *plot = dynamic_cast<QSPlot*>(chanList->selected()->dataObject());
         QSAxis *axis = dynamic_cast<QSAxis*>(chanList->selected()->dataObject());
         if ( plot ) m_workbook->execute( new KSCmdDatasetOrder( KSCmdDatasetOrder::Lower,plot) );
         if ( axis ) m_workbook->execute( new KSCmdAxisOrder( KSCmdAxisOrder::Lower,axis) );
	}
 }

//-----------------------------------------------------------//

void KSDatasetDlg::slot_show_menu(QListViewItem*,const QPoint&,int)
 {
  // Part -> show menu
  //
  QPopupMenu *menu = new QPopupMenu( this );
  int menu_cut      = menu->insertItem( tr("Cut") );
  int menu_copy     = menu->insertItem( tr("Copy") );
  int menu_copy_all = menu->insertItem( tr("Copy all") );
  int menu_paste    = menu->insertItem( tr("Paste") );
  int menu_delete   = menu->insertItem( tr("Delete") );
  if ( !chanList->selected() || !chanList->selected()->dataObject() ) {
	menu->setItemEnabled( menu_cut,  FALSE );
	menu->setItemEnabled( menu_copy, FALSE );
	menu->setItemEnabled( menu_copy_all, FALSE );
	menu->setItemEnabled( menu_delete, FALSE );
	}
  int item_id = menu->exec(QCursor::pos());
  KSObjectFactory factory( m_workbook );

  QSData *selected = chanList->selected() ? chanList->selected()->dataObject() : NULL;
  QSPlot *plot = dynamic_cast<QSPlot*>(selected);
  if ( plot && item_id == menu_cut ) {
	 factory.copyQSPlotToClipboard( plot );
	 m_workbook->execute( new KSCmdRemoveDataset(plot) );
	}
  else if ( plot && item_id == menu_copy ) {
	 factory.copyQSPlotToClipboard( plot );	
	}
  else if ( plot && item_id == menu_copy_all ) {
	 factory.setFlags( KSObjectFactory::CopyAllData );
	 factory.copyQSPlotToClipboard( plot );	
	}
  if ( plot && item_id == menu_delete ) {
	 m_workbook->execute( new KSCmdRemoveDataset(plot) );
	}

  QSAxis *axis = dynamic_cast<QSAxis*>(selected);
  if ( axis && item_id == menu_cut ) {
	 factory.copyQSAxisToClipboard( axis );
	 m_workbook->execute( new KSCmdRemoveAxis(axis) );
	}
  else if ( axis && item_id == menu_copy ) {
	 factory.copyQSAxisToClipboard( axis );	
	}
  else if ( axis && item_id == menu_copy_all ) {
	 factory.setFlags( KSObjectFactory::CopyAllData );
	 factory.copyQSAxisToClipboard( axis );	
	}
  if ( axis && item_id == menu_delete ) {
	 m_workbook->execute( new KSCmdRemoveAxis(axis) );
	}

  if ( item_id == menu_paste ) {
	QSPlot *new_plot = factory.pasteQSPlotFromClipboard( m_axes );
	if ( new_plot ) m_workbook->execute( new KSCmdAddDataset( new_plot ) );
	
	QSAxis *new_axis = factory.pasteQSAxisFromClipboard( m_axes );
	if ( new_axis ) m_workbook->execute( new KSCmdAddAxis( new_axis ) );
	}
 }


