/***************************************************************************
                                 ksattrbtn.cpp
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksattrbtn.h"
#include "ksattrpanel.h"
#include "../widgets/qsdrvqt.h"
#include <qpainter.h>

#define BTN_HSPACE	5
#define BTN_VSPACE	3

KSAttrBtn::KSAttrBtn(QWidget *parent, const char *name )
: QPushButton(parent,name)
 {
  m_attr_panel = NULL;
  setDefault( false );
  setAutoDefault( false );
  setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred ) );
  connect( this, SIGNAL(clicked()), this, SLOT(slot_show_panel()) );
 }

//-----------------------------------------------------------//

KSAttrBtn::~KSAttrBtn()
 {
  delete m_attr_panel;
 }

//-----------------------------------------------------------//

void KSAttrBtn::slot_show_panel()
 {
  delete m_attr_panel;
  m_attr_panel = new KSAttrPanel( this );
  //m_attr_panel->move( 0, 0 );
  //m_attr_panel->resize( parentWidget()->size() );
  //connect( m_attr_panel, SIGNAL(acceptValue()), this, SLOT(slot_accept_value()) );
  prepare( m_attr_panel );
  //m_attr_panel->show();
  if ( m_attr_panel->exec() ) accept( m_attr_panel );
  delete m_attr_panel;
  m_attr_panel = NULL;	
 }

//-----------------------------------------------------------//
/*
void KSAttrBtn::slot_accept_value()
 {
  if ( m_attr_panel ) {
	if ( m_attr_panel->result() ) accept( m_attr_panel );
	delete m_attr_panel;
	m_attr_panel = NULL;
	}
 }
*/
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSFillBtn::KSFillBtn( QWidget *parent, const char *name)
:KSAttrBtn(parent,name)
 {
 }

//-----------------------------------------------------------//

KSFillBtn::~KSFillBtn()
 {
 }

//-----------------------------------------------------------//

void KSFillBtn::setDialogFill( const QSGFill &new_f )
 {
  f = new_f;
  emit attrChanged();
  update();
 }

//-----------------------------------------------------------//

void KSFillBtn::drawButtonLabel( QPainter *p )
 {
  QRect r = rect();
  r.setCoords( r.left()+BTN_HSPACE,
               r.top()+BTN_VSPACE,
               r.right()-BTN_HSPACE,
               r.bottom()-BTN_VSPACE );

  if ( f.style == QSGFill::Transparent ) {
        QFont fnt = font(); fnt.setPointSize( 10 );
        p->setFont( fnt );
        p->setPen( white );
        p->fillRect( r, black );
        p->drawText( 0,
                     0,
                     size().width(),
                     size().height(),
                     AlignHCenter |
                     AlignVCenter,
                     tr("Transparent") );
      }  else {
        p->setPen( black );
        QSDrvQt drv; // we use only a canvas driver so NULL is allowed
        drv.setDC( p, 72, false );
        drv.startDrawing();
        drv.setFill( f );
        drv.drawRect( QSPt2f(r.x(),r.y()), QSPt2f(r.right(),r.bottom()) );
        drv.stopDrawing();
      }
 }

//-----------------------------------------------------------//

void KSFillBtn::prepare( KSAttrPanel *panel )
 {
  KSSelectFill  *fpanel = new KSSelectFill( panel->subPanelPlace1() );
  KSSelectColor *cpanel = new KSSelectColor( panel->subPanelPlace2() );
  panel->setSubPanel1( fpanel );
  panel->setSubPanel2( cpanel );
  fpanel->setPanelFill( f );
  cpanel->setPanelColor( f.color );
 }

//-----------------------------------------------------------//

void KSFillBtn::accept( KSAttrPanel *panel )
 {
  QSGFill fill = ((KSSelectFill *)panel->subPanel1())->panelFill();
  fill.color = ((KSSelectColor *)panel->subPanel2())->panelColor();
  setDialogFill( fill );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSFontBtn::KSFontBtn( QWidget *parent, const char *name)
:KSAttrBtn(parent,name)
 {
 }

//-----------------------------------------------------------//

KSFontBtn::~KSFontBtn()
 {
 }

//-----------------------------------------------------------//

void KSFontBtn::setDialogFont( const QSGFont &new_f )
 {
  f = new_f;
  emit attrChanged();
  update();
 }

//-----------------------------------------------------------//

void KSFontBtn::drawButtonLabel( QPainter * p )
 {
  QFont c = QSDrvQt::toQFont( f ); c.setPointSize( 10 );

  p->setPen( black );
  p->setFont( c );
  p->drawText( 0, 0,
               size().width(),
               size().height(),
               AlignHCenter |
               AlignVCenter,
               c.family() );
 }

//-----------------------------------------------------------//

void KSFontBtn::prepare( KSAttrPanel *panel )
 {
  KSSelectFont  *fpanel = new KSSelectFont( panel->subPanelPlace1() );
  KSSelectColor *cpanel = new KSSelectColor( panel->subPanelPlace2() );
  panel->setSubPanel1( fpanel );
  panel->setSubPanel2( cpanel );
  fpanel->setPanelFont( f );
  cpanel->setPanelColor( f.color );
 }

//-----------------------------------------------------------//

void KSFontBtn::accept( KSAttrPanel *panel )
 {
  QSGFont font = ((KSSelectFont *)panel->subPanel1())->panelFont();
  font.color = ((KSSelectColor *)panel->subPanel2())->panelColor();
  setDialogFont( font );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSLineBtn::KSLineBtn( QWidget *parent, const char *name)
:KSAttrBtn(parent,name)
 {
 }

//-----------------------------------------------------------//

KSLineBtn::~KSLineBtn()
 {
 }

//-----------------------------------------------------------//

void KSLineBtn::setDialogLine( const QSGLine &new_l )
 {
  l = new_l;
  emit attrChanged();
  update();
 }

//-----------------------------------------------------------//

void KSLineBtn::drawButtonLabel( QPainter * p )
 {
  QRect r = rect();
  r.setCoords( r.left()+BTN_HSPACE,
               r.top()+BTN_VSPACE,
               r.right()-BTN_HSPACE,
               r.bottom()-BTN_VSPACE );

  p->setPen( black );
  p->setBrush( white );
  p->drawRect( r );

  p->setClipRect( r );
  if ( l.style != QSGLine::Invisible ) {

                p->setPen( QSDrvQt::toQPen(l) );
                p->drawLine( r.left()  + 4, r.center().y(),
                             r.right() - 4, r.center().y() );
               } else {

                QFont f = font();f.setPointSize( 10 );
                p->setFont( f );
                p->setPen( black );
                p->drawText( 0, 0,
                             size().width(),
                             size().height(),
                             AlignHCenter |
                             AlignVCenter,
                             tr("Invisible") );
               }

  p->setClipping( false );
 }

//-----------------------------------------------------------//

void KSLineBtn::prepare( KSAttrPanel *panel )
 {
  KSSelectLine  *lpanel = new KSSelectLine( panel->subPanelPlace1() );
  KSSelectColor *cpanel = new KSSelectColor( panel->subPanelPlace2() );
  panel->setSubPanel1( lpanel );
  panel->setSubPanel2( cpanel );
  lpanel->setPanelLine( l );
  cpanel->setPanelColor( l.color );
 }

//-----------------------------------------------------------//

void KSLineBtn::accept( KSAttrPanel *panel )
 {
  QSGLine line = ((KSSelectLine *)panel->subPanel1())->panelLine();
  line.color = ((KSSelectColor *)panel->subPanel2())->panelColor();
  setDialogLine( line );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSPointBtn::KSPointBtn(QWidget *parent, const char *name)
:KSAttrBtn(parent,name)
 {
 }

//-----------------------------------------------------------//

KSPointBtn::~KSPointBtn()
 {
 }

//-----------------------------------------------------------//

void KSPointBtn::setDialogPoint( const QSGPoint &new_p )
 {
  p = new_p;
  attrChanged();
  update();
 }

//-----------------------------------------------------------//

void KSPointBtn::drawButtonLabel( QPainter *paint )
 {
  QRect r = rect();

  r.setCoords( r.left()+BTN_HSPACE,
               r.top()+BTN_VSPACE,
               r.right()-BTN_HSPACE,
               r.bottom()-BTN_VSPACE );

  paint->setPen( black );
  paint->setBrush( white );
  paint->drawRect( r );

  paint->setClipRect( r );
  if ( p.style != QSGPoint::Invisible ) {
         QSPt2f mid( r.center().x(), r.center().y() );
         QSDrvQt drv; // we use only canvas driver, so NULL is allowed
         drv.setDC( paint, 72, false );
         drv.startDrawing();
         drv.drawPoint( mid, p );
         drv.stopDrawing();
        } else {
         QFont f = font();f.setPointSize( 10 );
         paint->setFont( f );
         paint->setPen( black );
         paint->drawText( 0, 0,
                          size().width(),
                          size().height(),
                          AlignHCenter |
                          AlignVCenter,
                          tr("Invisible") );
        }
 }

//-----------------------------------------------------------//

void KSPointBtn::prepare( KSAttrPanel *panel )
 {
  KSSelectPoint *ppanel = new KSSelectPoint( panel->subPanelPlace1() );
  KSSelectColor *cpanel = new KSSelectColor( panel->subPanelPlace2() );
  panel->setSubPanel1( ppanel );
  panel->setSubPanel2( cpanel );
  ppanel->setPanelPoint( p );
  cpanel->setPanelColor( p.color );
 }

//-----------------------------------------------------------//

void KSPointBtn::accept( KSAttrPanel *panel )
 {
  QSGPoint point = ((KSSelectPoint *)panel->subPanel1())->panelPoint();
  point.color = ((KSSelectColor *)panel->subPanel2())->panelColor();
  setDialogPoint( point );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSArrowBtn::KSArrowBtn(QWidget *parent, bool origin, const char *name)
:KSAttrBtn(parent,name)
 {
  m_origin = origin;
 }

//-----------------------------------------------------------//

KSArrowBtn::~KSArrowBtn()
 {
 }

//-----------------------------------------------------------//

void KSArrowBtn::setDialogArrow( const QSGArrow &new_a )
 {
  a = new_a;
  attrChanged();
  update();
 }

//-----------------------------------------------------------//

void KSArrowBtn::setOrigin( bool origin )
 {
  m_origin = origin;
  update();
 }

//-----------------------------------------------------------//

void KSArrowBtn::drawButtonLabel( QPainter *paint )
 {
  QRect r = rect();

  r.setCoords( r.left()+BTN_HSPACE,
               r.top()+BTN_VSPACE,
               r.right()-BTN_HSPACE,
               r.bottom()-BTN_VSPACE );

  paint->setPen( black );
  paint->setBrush( white );
  paint->drawRect( r );

  paint->setClipRect( r );
  if ( a.style != QSGArrow::None ) {
         QSPt2f mid( r.center().x(), r.center().y() );
         QSDrvQt drv;   // we use only a canvas driver so NULL is allowed
	 QSGLine l;
         drv.setDC( paint, 72, false );
         drv.startDrawing();
	 drv.setLine( l );
         drv.drawDart( mid, m_origin?180.0:0.0, a );
         drv.stopDrawing();
        } else {
         QFont f = font();f.setPointSize( 10 );
         paint->setFont( f );
         paint->setPen( black );
         paint->drawText( r,
                          AlignHCenter |
                          AlignVCenter,
                          tr("None") );
        }
 }


//-----------------------------------------------------------//

void KSArrowBtn::prepare( KSAttrPanel *panel )
 {
  KSSelectArrow *apanel = new KSSelectArrow( panel->subPanelPlace1() );
  panel->setSubPanel1( apanel );
  apanel->setPanelArrow( a );
 }

//-----------------------------------------------------------//

void KSArrowBtn::accept( KSAttrPanel *panel )
 {
  QSGArrow arrow = ((KSSelectArrow *)panel->subPanel1())->panelArrow();
  setDialogArrow( arrow );
 }

