#ifndef __NETWCLASS
#define __NETWCLASS

#include <qframe.h>
class QPainter;
class QRect;
class QMouseEvent;
class QTimer;
class QPaintEvent;
class QPopupMenu;

class Circuit;
class XDevice;
class XWire;
class Selection;

#define RPOP_DEL	100
#define RPOP_PROP	101
#define RPOP_SUB	102
#define RPOP_SUBW	103
#define RPOP_GRAPH	104
#define RPOP_SHOWGRAPH	105
#define RPOP_EQU	106
#define RPOP_ADD_LIB	107

#define RPOPSEL_CUT	100
#define RPOPSEL_COPY	101
#define RPOPSEL_PASTE	102
#define RPOPSEL_PASTEAT 103

class NetWidget : public QFrame
{	Q_OBJECT
public:
	NetWidget(QWidget *, QWidget *);
	NetWidget(QWidget *, QWidget *, Circuit *);
	~NetWidget();

	// sim mode is static
	static void setSimMode(int);
	static int getSimMode();
	static void setDevice(int);

	void toParentNet();
	Circuit *getActive();
	int contained(Circuit *);

	void removeSelection();

	bool saveAsSubNet();
	int saveNet(QString, bool);
	int openNet(QString, bool);
	int newNet();
	bool hasChanged();
	void resetChanges();
	int printNet(QPainter *);
	void showCircuitEquations();
	void showDeviceEquations();
	void applyDefaults();

	void visible(const QRect&);

	static const int MODE_SIM_STEP = 502;
	static const int MODE_SIM_MULT = 503;

	static const int MIN_SIMSTEPTIME = 1;
	static const int MAX_SIMSTEPTIME = 400;
	static const int MIN_SIMBURST = 1;
	static const int MAX_SIMBURST = 99999;

	static int simTime();
	static void setSimTime(int);
	static int simBurst();
	static void setSimBurst(int);

	static QTimer simTimer;
	static QTimer shortcutWarningTimer;

signals:
	void netChanged(int);
	void netDeleted(Circuit *);
	void netContentChanged();
	void netContentUnchanged();
	void createNewWidget(Circuit *);
	void simStepped();

	void graphChanged();
	void showGraph(Circuit *);
	void addToLib(XDevice *);
	void autoMove(const QPoint&);

public slots:
	void simStep();
	void rmenuCallback(int);
	void rmenuSelCallback(int);
	void enableShortcutWarning();

private:
	int toSubNetW();
	int toSubNet();
	void deleteDev(int);
	int openProp();

	static int STATsimBurst;
	static int STATsimStepTime;
	static int simmode;
	static int actualDevFunc;

	QWidget *m_oParent;
	QRect m_oVisibleRect;

	void mousePressEvent( QMouseEvent * );
	void mouseReleaseEvent( QMouseEvent * );
	void mouseMoveEvent( QMouseEvent * );
	void mouseDoubleClickEvent( QMouseEvent * );
	void paintEvent(QPaintEvent *);
	void selRightMenu(QMouseEvent *);
	void selRightSelMenu(QMouseEvent *);

	Circuit *m_poActiveCircuit;
	XDevice *m_poActiveDevice;
	XWire *m_poActiveWire;
	Selection *m_poActiveSelection;

	QPopupMenu *rpop;
	QPopupMenu *rselpop;

	bool changed;
	bool client;
	int m_bSelMoveCursor;
	int m_bRMenuActive;

	bool runtimeShortcutWarning;
};

#endif
