/************************************/
/* methods of RAMWidget             */
/* methods of RAMScrollWidget        */
/*                                  */
/* inverter dialog for devices      */
/* is part of device prop dialog    */
/*                                  */
/* Andreas Rostin                   */
/* 16.12.98                         */
/*                                  */
/* RAMScrollWidget extension:        */
/* Andreas Rostin                   */
/* 04.03.2000                       */
/************************************/
#include <qwidget.h>
#include <qdialog.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qpaintdevice.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qscrollbar.h>

#include <ramw.h>
#include <xdevice.h>
#include <klogic.h>
#include <tool.h>

#include "ramw.moc"

// results in a scrollable device widget
RAMScrollWidget::RAMScrollWidget(QWidget *parent, const char *name, XDevice *_dev)
	: QWidget(parent, name, WStyle_Customize |WStyle_NormalBorder)
{
	curr_y_size = height();
	vscroll = new QScrollBar(0, 195, GRID, 16 * GRID, 0, QScrollBar::Vertical, this);
	vscroll->setGeometry(width() - 10, 0, 10, height());
	vscroll->hide();
	ramw = new RAMWidget(this, name, _dev);
	ramw->setBitButtons(height());
	ramw->show();

	connect(vscroll, SIGNAL(valueChanged(int)), this, SLOT(vScroll(int)));
}

RAMScrollWidget::~RAMScrollWidget()
{
}

void RAMScrollWidget::paintEvent(QPaintEvent *pev)
{
	QWidget::paintEvent(pev);
	adjustScroll();
	ramw->repaint(TRUE);
}

void RAMScrollWidget::setGeometry(int x, int y, int width, int height)
{
	QWidget::setGeometry(x, y, width, height);
	ramw->setGeometry(0, 0, width - 10, height);
	vscroll->setGeometry(width - 10, 0, 10, height);
	adjustScroll();
}

//static
int RAMScrollWidget::neededWidth()
{
	return RAMWidget::neededWidth() + 10;
}

void RAMScrollWidget::vScroll(int val)
{
	ramw->move(0, -1 * val);
}

void RAMScrollWidget::setBitButtons()
{
	ramw->setBitButtons(height());
}

void RAMScrollWidget::adjustScroll()
{
	int ramy = ramw->height();
	if (ramy != curr_y_size && ramy > height()) {
		curr_y_size = ramy;
		vScroll(0);
		vscroll->setRange(0, ramy - height());
		vscroll->show();
	}
	if (ramy < height()) {
		curr_y_size = ramy;
		vScroll(0);
		vscroll->hide();
	}
}

char *RAMScrollWidget::getNewRAMContent()
{
	return ramw->getNewRAMContent();
}

// set each byte of the ram to the given value
void RAMScrollWidget::setRAM(char bytecontent)
{
	ramw->setRAM(bytecontent);
}

//*****************************************************************************
//*****************************************************************************

RAMWidget::RAMWidget(QWidget *parent, const char *name, XDevice *_dev)
	: QWidget(parent, name, WStyle_Customize |WStyle_NormalBorder)
{
	ram = _dev->getRAMStorageCopy();
	byte_cnt = _dev->RAMSize();
	pix_inputval = new QPixmap(1, 1);
	pix_inputval->fill();

	setBackgroundMode(PaletteBase);
	setBackgroundColor(white);

	for (int i = 0; i < byte_cnt; i++) {
		for (int j = 0; j < 8; j++) {
			bitswitch[i][j] = (QCheckBox *)NULL;
		}
	}
	bitgroup = (QButtonGroup *)NULL;
	xpos = 0;
	ypos = 0;
}

RAMWidget::~RAMWidget()
{
	if (ram) delete [] ram;
	removeBitButtons();
}

char * RAMWidget::getNewRAMContent()
{
	return ram;
}

//static
int RAMWidget::neededWidth()
{
	return 12 * 8 + 40;
}

void RAMWidget::paintEvent(QPaintEvent *pev)
{
	QWidget::paintEvent(pev);
	QPainter p;
	p.begin(this);
	bitBlt(this, 0, 0, pix_inputval);
	p.end();
}

void RAMWidget::setGeometry(int x, int y, int width, int height)
{
	xpos = x;
	ypos = y;

	int bwidth = width;	// avoid warning!
	bwidth = 12;
	int bheight = height / byte_cnt;
	if (bheight < 12) {
		bheight = 12;
	}
	QWidget::setGeometry(x, y, bwidth * 8 + 40, bheight * byte_cnt);
	pix_inputval->resize(40, bheight * byte_cnt);
	pix_inputval->fill();

	// display input value in front
	QPainter p;
	p.begin(pix_inputval);
	p.setPen(Qt::black);
	p.setBrush(Qt::black);
	p.setFont(QFont( "helvetica", 10, QFont::Bold ) );

	for(int i = 0; i < byte_cnt; i++) {
		p.drawText(5, (i + 1) * bheight - 1, Tool::bitString((char)i, 5));
		for(int j = 0; j < 8; j++) {
			bitswitch[i][j]->setGeometry(40 + j * bwidth, i * bheight, bwidth, bheight);
		}
	}
	p.end();
}

// slot for setting/resetting a bit
void RAMWidget::bitButton(int no)
{
	int i = no / 8;
	int j = no % 8;
	if (bitswitch[i][j]->isChecked()) {
		ram[i] = ram[i] | Tool::pow2(j);
	} else {
		int bitval = Tool::pow2(j);
		if (ram[i] & bitval) ram[i] -= bitval;
	}
}

// init bit buttons
void RAMWidget::setBitButtons(int height)
{
	removeBitButtons();

	bitgroup = new QButtonGroup;
	int bwidth = 12;
	int bheight = height / byte_cnt;
	if (bheight < 12) {
		bheight = 12;
	}
	QWidget::setGeometry(xpos, ypos, bwidth * 8 + 40, bheight * byte_cnt);
	pix_inputval->resize(40, bheight * byte_cnt);
	pix_inputval->fill();

	// display input value in front
	QPainter p;
	p.begin(pix_inputval);
	p.setPen(Qt::black);
	p.setBrush(Qt::black);
	p.setFont(QFont( "helvetica", 10, QFont::Bold ) );

	for(int i = 0; i < byte_cnt; i++) {
		p.drawText(5, (i + 1) * bheight - 1, Tool::bitString((char)i, 5));

		// each bit a button: output value
		for(int j = 0; j < 8; j++) {
			bitswitch[i][j] = new QCheckBox(this);
			bitswitch[i][j]->setGeometry(40 + (7 - j) * bwidth, i * bheight, bwidth, bheight);
			bitswitch[i][j]->setChecked(ram[i] & Tool::pow2(j));
			bitgroup->insert(bitswitch[i][j]);
			bitswitch[i][j]->show();
		}
	}
	p.end();
	connect(bitgroup, SIGNAL(clicked(int)), this, SLOT(bitButton(int)));
}

void RAMWidget::removeBitButtons()
{
	if (bitgroup) {
		for(int i = 0; i < byte_cnt; i++) {
			for(int j = 0; j < 8; j++) {
				if (bitswitch[i][j]) {
					disconnect(bitgroup, SIGNAL(clicked(int)), this, SLOT(bitButton(int)));
					delete bitswitch[i][j];
				}
			}
		}
		delete bitgroup;
	}
}

// set each byte of the ram to the given value
void RAMWidget::setRAM(char bytecontent)
{
	for(int i = 0; i < byte_cnt; i++) {
		ram[i] = bytecontent;
		for(int j = 0; j < 8; j++) {
			bitswitch[i][j]->setChecked(ram[i] & Tool::pow2(j));
		}
	}
}
