/***************************************************************************
                          setup.cpp  -  description
                             -------------------
    begin                : mar jul 29 2003
    copyright            : (C) 2003 by Jaime Robles
    email                : jaime@kde.org
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/

#include <klocale.h>
//#include <kdebug.h>
//#include <ostream.h>
#include "setup.h"



Setup::Setup(QWidget *parent, const char *name) : setupui(parent, name)
{
  klogDir = QDir::homeDirPath()+"/.klog";  // We create the ~/.klog for the logs
  if (!QDir::setCurrent ( klogDir )){
    QDir d1(klogDir);
    dirExist = d1.mkdir(klogDir, true);
  }
  dirExist = QDir::setCurrent ( klogDir ) ;
  fileName = "";
  ///////////////////////////////////////////////////////////////////////////////
  // Modifications by kike
  // 25-03-2004
  //////////////////////////////////////////////////////////////////////////////
  // Fill the rig combo
  setRig();
  //////////////////////////////////////////////////////////////////////////////
  // End of modifications
  /////////////////////////////////////////////////////////////////////////////
  
  
  readConf();
  
  slotOpenFileButtonClicked();
}

Setup::~Setup()
{
}


void Setup::slotOkBtnClicked(){
  writeConf();
  accept();  
}


void Setup::readConf(){
  QFile file( "klogrc" );
  if ( file.open( IO_ReadOnly ) ) {
    QTextStream stream( &file );
    QString adifTab;
    QString theData;
    QString data = "";

    data = ""; //
    while (!stream.eof()){
      data = stream.readLine();
      if(!data.isEmpty()){ // If there is another line i read it
        data = data.simplifyWhiteSpace();
        QStringList fields = QStringList::split('=', data );

        adifTab = fields[0].upper();
        theData = fields[1];
        if (adifTab == "CALL"){
          setupui::MyCallkLineEdit->setText(theData.upper());

        }else if (adifTab == "LOCATOR"){
          setupui::MyLocatorkLineEdit->setText(theData.upper());

        }else if (adifTab == "DXCLUSTERSERVER"){
          
          setupui::DXClusterServerkLineEdit->setText(theData);

        }else if (adifTab == "DXCLUSTERPORT"){
          setupui::DXClusterPortkIntNumInput->setValue(theData.toInt());

        }else if (adifTab == "COMPLETEWITHPREVIOUS"){
          if (theData.upper() == "TRUE"){
            setupui::completeWithPreviouscheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::completeWithPreviouscheckBox->setChecked(false);
          }
        }else if (adifTab == "TIMEUTC"){
          if (theData.upper() == "TRUE"){
            setupui::UTCcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::UTCcheckBox->setChecked(false);            
          }

        }else if (adifTab == "OPENLASTFILE"){
          if (theData.upper() == "TRUE"){
            setupui::lastFilecheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::lastFilecheckBox->setChecked(false);
          }
        }else if (adifTab == "DXCLUSTERHFSPOTS"){
          if (theData.upper() == "TRUE"){
            setupui::HFcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::HFcheckBox->setChecked(false);
          }
        }else if (adifTab == "DXCLUSTERVHFSPOTS"){
          if (theData.upper() == "TRUE"){
            setupui::VHFcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::VHFcheckBox->setChecked(false);
          }
        }else if (adifTab == "DXCLUSTERWARCSPOTS"){
          if (theData.upper() == "TRUE"){
            setupui::WARCcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::WARCcheckBox->setChecked(false);
          }
      }else if (adifTab == "DXCLUSTERANNOUNCES"){
          if (theData.upper() == "TRUE"){
            setupui::ANNcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::ANNcheckBox->setChecked(false);
          }
        }else if (adifTab == "DXCLUSTERWXANNOUNCES"){
          if (theData.upper() == "TRUE"){
            setupui::WXcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::WXcheckBox->setChecked(false);
          }
        }else if (adifTab == "DXCLUSTERCONFIRMEDANNOUNCES"){
          if (theData.upper() == "TRUE"){
            setupui::confirmedcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::confirmedcheckBox->setChecked(false);
          }
        }else if (adifTab == "DXCLUSTERWCYANNOUNCES"){
          if (theData.upper() == "TRUE"){
            setupui::WCYcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::WCYcheckBox->setChecked(false);
          }   
        }else if (adifTab == "REALTIMELOG"){
          if (theData.upper() == "TRUE"){
            setupui::realTimeLogCheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::realTimeLogCheckBox->setChecked(false);
          }
        }else if (adifTab == "CONFIRMEDCOLOR"){
          color.setNamedColor(theData.upper());
          setupui::confirmedkColorCombo->setColor(color);
        }else if (adifTab == "WORKEDCOLOR"){
          color.setNamedColor(theData.upper());
          setupui::workedkColorCombo->setColor(color);
        }else if (adifTab == "NEEDEDCOLOR"){
          color.setNamedColor(theData.upper());
          setupui::neededkColorCombo->setColor(color);
        }else if (adifTab == "DEFAULTCOLOR"){
          color.setNamedColor(theData.upper());
          setupui::defaultkColorCombo->setColor(color);
          
        }else if (adifTab == "POWER"){
          setupui::powerkIntNumInput->setValue(theData.toInt());
        }else if (adifTab == "DEFAULTBAND"){
          setupui::bandkComboBox->setCurrentItem(theData.toInt());
        }else if (adifTab == "DEFAULTMODE"){
          setupui::modekComboBox->setCurrentItem(theData.toInt());
        }else if (adifTab == "SHOWPROGRESSDIALOG"){
          if (theData.upper() == "TRUE")
            setupui::checkBoxProgressDialog->setChecked(true);
        }else if (adifTab == "LOGFILENAME"){
          fileName = theData;
          setupui::filenamekLineEdit->setText(fileName);
       }else if (adifTab == "HAMLIB"){
          if (theData.upper() == "TRUE"){
            setupui::hamlibcheckBox->setChecked(true);
          }else if ((theData.upper() == "FALSE")){
            setupui::hamlibcheckBox->setChecked(false);            
          }
   
          ///////////////////////////////////////////////////////////////////////////////
          // Modifications by kike
          // 25-03-2004
          //////////////////////////////////////////////////////////////////////////////
          }else if (adifTab == "RIGNAME"){
       comboBoxTrvList->setCurrentText(rigid2rigname[theData.toInt()]);
          }else if (adifTab == "PORT"){
//       comboBoxTrvPortList->setCurrentText(theData);
       devicelineEdit->setText(theData);
          }else if (adifTab == "BAUDS"){
       //comboBoxTrvSpeedList->setCurrentText(theData);
       		//speedlineEdit->setText(theData);
       		setupui::comboBoxTrvSpeedList->setCurrentItem(theData.toInt());
       }
          //////////////////////////////////////////////////////////////////////////////
          // End of modifications
          //////////////////////////////////////////////////////////////////////////////
		else if (adifTab == "HAMLIBINTERVAL"){
			setupui::hamlibIntervalspinBox->setValue(theData.toInt());
			
          }else{
        }
      }
    }  
    file.close();    
  }else{
  // the file klogrc with preferences does not exist so we have to create it
  }
}

void Setup::writeConf(){
	QFile file("klogrc");
	QString tmp;
	tmp = "true";
	if ( file.open( IO_WriteOnly ) ) {
		QTextStream stream( &file );
		stream << "call=" << (setupui::MyCallkLineEdit->text()).upper() << endl;
		stream << "locator=" << (setupui::MyLocatorkLineEdit->text()).upper()<< endl;
		stream << "dxclusterserver=" << (setupui::DXClusterServerkLineEdit->text()).upper() << endl;
		stream << "dxclusterport=" << QString::number(setupui::DXClusterPortkIntNumInput->value()) << endl;
		stream << "defaultBand=" << QString::number(setupui::bandkComboBox->currentItem()) << endl;
		stream << "defaultMode=" << QString::number(setupui::modekComboBox->currentItem()) << endl;
		if (setupui::UTCcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "timeutc=" + tmp << endl;
		if (setupui::HFcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "completewithprevious=" + tmp << endl;
		if (setupui::completeWithPreviouscheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}

    
		stream << "dxclusterhfspots=" + tmp << endl;
		if (setupui::VHFcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "dxclustervhfspots=" + tmp << endl;    
		if (setupui::WARCcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "dxclusterwarcspots=" + tmp << endl;        
		if (setupui::ANNcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "dxclusterannounces=" + tmp << endl;
		if (setupui::WXcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "dxclusterwxannounces=" + tmp << endl;
    
		if (setupui::WCYcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "dxclusterwcyannounces=" + tmp << endl;      
		if (setupui::confirmedcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "dxclusterconfirmedannounces=" + tmp << endl;          
		if (setupui::realTimeLogCheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "realTimeLog=" + tmp << endl;
		// Color scheme...
		stream << "ConfirmedColor=" + (setupui::confirmedkColorCombo->color()).name() << endl;
		stream << "WorkedColor=" + (setupui::workedkColorCombo->color()).name() << endl;
		stream << "NeededColor=" + (setupui::neededkColorCombo->color()).name() << endl;
		stream << "DefaultColor=" + (setupui::defaultkColorCombo->color()).name() << endl;    
		stream << "Power=" + QString::number(setupui::powerkIntNumInput->value()) << endl;
		if (setupui::lastFilecheckBox->isChecked() && (setupui::filenamekLineEdit->text() != "")){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "OpenLastFile=" + tmp << endl;
		if (fileName != "")
			stream << "LogFileName=" + setupui::filenamekLineEdit->text() << endl;
		if (setupui::checkBoxProgressDialog->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "ShowProgressDialog=" + tmp << endl;    
		if (setupui::hamlibcheckBox->isChecked()){
			tmp="true";
		}else{
			tmp="false";
		}
		stream << "HamLib=" + tmp << endl;
		stream << "RigName=" << rigname2rigid[comboBoxTrvList->currentText()] << endl;
			stream << "Port=" << devicelineEdit->text() << endl;    
  			// stream << "Port=" << comboBoxTrvPortList->currentText() << endl;
			//stream << "Bauds=" << speedlineEdit->text() <<endl;    
			//stream << "Bauds=" << comboBoxTrvSpeedList->currentText() << endl;
			 stream << "Bauds=" << QString::number(setupui::comboBoxTrvSpeedList->currentItem())<<endl;
			stream << "HamlibInterval=" << QString::number(setupui::hamlibIntervalspinBox->value()) << endl;
     ///////////////////////////////////////////////////////////////////////////////
    // Modifications by kike
    // 25-03-2004
    //////////////////////////////////////////////////////////////////////////////
		
    //////////////////////////////////////////////////////////////////////////////
    // End of modifications
    //////////////////////////////////////////////////////////////////////////////
   
		file.close();
	}
  
}

void Setup::slotFileNameClicked(){ 
  QFileDialog fileOpenDialog(this, i18n("Select the file"), TRUE);
  fileOpenDialog.setFilter(i18n("ADIF files (*.adi *.ADI)"));
  fileOpenDialog.setDir(klogDir);
  if (fileOpenDialog.exec() == QDialog::Accepted){
    fileName=fileOpenDialog.selectedFile();
    setupui::filenamekLineEdit->setText(fileName);

  }  
  else
    return;
}


void Setup::slotOpenFileButtonClicked(){
    if (setupui::lastFilecheckBox->isChecked()){
      setupui::filenamekLineEdit->setEnabled(true);
      setupui::searchFilekPushButton->setEnabled(true);
    }else{
      setupui::filenamekLineEdit->setEnabled(false);
      setupui::searchFilekPushButton->setEnabled(false);
    }
}


///////////////////////////////////////////////////////////////////////////////
// Modifications by kike
// 25-03-2004
//////////////////////////////////////////////////////////////////////////////
int Setup::addRigToList(const struct rig_caps* caps, void* data){
        QString name;
  Setup* r = (Setup*)data;
        name=caps->model_name;
        if (name == "Dummy")
                name = "None";
  r->rigname2rigid[name] = caps->rig_model;
  r->rigid2rigname[caps->rig_model] = name;
        r->strings << name;
  return -1; // not 0 --> we want all rigs
}

void Setup::setRig()
{
  // Rutine to fill the rig combo boxes
  // Do not display debug codes when load the rig's
  rig_set_debug(RIG_DEBUG_NONE);

  // and continue...
  rig_load_all_backends();
  rig_list_foreach(addRigToList, this);
  strings.sort();
comboBoxTrvList->insertStringList(strings);
  strings.clear();
}
//////////////////////////////////////////////////////////////////////////////
// End of modifications
//////////////////////////////////////////////////////////////////////////////
