/***************************************************************************
                          award  -  description
                             -------------------
    begin                : vie may 20 2005
    copyright            : (C) 2005 by Jaime Robles
    email                : jaime@robles.nu
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/ 
 
#ifndef AWARD_H
#define AWARD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
//This class shall implement ONE award.
// It will receive a QString with the name of a file that has the information for the
// award.
#include <qstring.h>
#include <qvaluelist.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qfiledialog.h>
#include <qdir.h>
#include <klocale.h>
//#include "world.h"
#include "reference.h"

class Award  {
	//friend class World;
public:
	Award();
	Award(const int treference, const int tnumberOfReferences, const QString &tname, const QString &tprefix, const QString &torganizer);
	~Award();
	
	void setAwardReference(int treference);
	int getAwardReference() const;
	void setNumberOfReferences(int treference);
	int getNumberOfReferences() const;
	
	void setAwardName(const QString &tname);
	QString getAwardName() const;
	
	void setEntityPrefix(const QString &prefix);
	QString getEntityPrefix() const;

	void addPrefix(const QString &prefix);	
	bool checkPrefix(const QString &prefix);
	
	void setOrganizer(const QString &torganizer);
	QString getOrganizer() const;
	
	void addReference(const QString &treference);
	QString getReference(int treference);

	void clearAward();
	void readAward(const QString &tfile);
//	References getAllReferences();
	
  
private:
	int awardReference;	// Each award shall have an internal reference
	int numberOfReferences;	// To know how many references are in this award
	QString awardName;	// Self explained, isn't it ;-)
	QString entityPrefix;	// Where is this award from. To activate this award if the worked call is from the appropriate entity.
	QString organizer;	// Information about the organizer (URL, ...) (not mandatory field)
	typedef QValueList<Reference> References; // The list of references of the award.
	References references;
	//typedef QMap<QString, Entity> PrefixMap;  // Some awards are for several prefix like						// TPEA (EA, EA6, EA8 & EA9)
	typedef QValueList<QString> Prefixes;
	
	//PrefixMap map;
	//PrefixMap::Iterator it;
 	Prefixes prefixes;		// Here we will save the list of prefixes for that entity.
						  
	int entity;
	QStringList fields;	// Auxiliary variable to splir log/formated strings	
	int i;			// Auxiliary int for counters
	int len;		//
	Reference ref;
	int number; // To count the number of created references
	QString klogDir;
	bool dirExist;
};

#endif


