/**************************************************************************
                          adif.h  -  description
                             -------------------
    begin                : vie mar 7 2003
    copyright            : (C) 2003 by Jaime Robles
    email                : jaime@kde.org
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/
#ifndef ADIF_H
#define ADIF_H

#include <qstring.h>


 class Adif{

public:

  Adif();

  ~Adif();
  int band2Int(const QString& tband);
  int mode2Int(const QString& tmode);
  int freq2Int (const QString& tfreq);    // accepts a string like "144", "10"... the MegaHertz section of a frecuency
  QString int2Band(int tband);
  QString freq2Band (const QString& tfreq); //Accepts frecs and returns band
  bool isHF(const QString& tfreq);   // Input is the same as in freq2Int
  bool isVHF(const QString& tfreq);  // Input is the same as in freq2Int
  bool isWARC(const QString& tfreq);  // Input is the same as in freq2Int
private:

  QString sAux;

};

#endif

