/***************************************************************************
                          awardwaz.cpp  -  description
                             -------------------
    begin                : vie feb 28 2003
    copyright            : (C) 2003 by Jaime Robles
    email                : jaime@kde.org
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/

#include <klocale.h>
//#include <kdebug.h>
//#include <ostream.h>
#include "awardwaz.h"


AwardWAZ::AwardWAZ(){
  i = 0;
  j = 0;
  k = 0;
  for (i = 1; i <  ZONES; i++){
    AwardWAZ::wazW[i] = false;
    AwardWAZ::wazC[i] = false;
    for (j = 0; j <  BANDS; j++){
        AwardWAZ::wazb[i][j] = -1;
    };
  };

  for (i = 1; i <  ZONES; i++){
      for (k = 0; k <  MODES; k++){
        AwardWAZ::wazm[i][k] = -1;

    };
  };
};


AwardWAZ::~AwardWAZ(){};

void AwardWAZ::clear(){
  i = 0;
  j = 0;
  k = 0;
  for (i = 1; i <  ZONES; i++){
    AwardWAZ::wazW[i] = false;
    AwardWAZ::wazC[i] = false;
    for (j = 0; j <  BANDS; j++){
        AwardWAZ::wazb[i][j] = -1;
    };
  };

  for (i = 1; i <  ZONES; i++){
      for (k = 0; k <  MODES; k++){
        AwardWAZ::wazm[i][k] = -1;

    };
  };

};
void AwardWAZ::worked(const int tzone, const int tband, const int tmode){
  i = tzone;
  j = tband;
  k = tmode;
  wazb[i][j] = 0;
  wazm[i][k] = 0;
  wazW[i] = true;

};

void AwardWAZ::workedString(const int tzone, const QString& tband, const QString& tmode){
  i = tzone;
  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1){
    return;
  }
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1){
    return;
  }

  wazb[i][j] = 0;
  wazm[i][k] = 0;
  wazW[i] = true;
  wazCountWorked++;
};

void AwardWAZ::notWorked(const int tzone, const int tband, const int tmode){
  //Needs to have a way to check if it
  i = tzone;
  j = tband;
  k = tmode;
  wazb[i][j] = -1;
  wazm[i][k] = -1;
  for (j = 0; j < BANDS; j++)
    if (wazb[i][j] >=0)
      return;
  for (k = 0; k < MODES; k++)
    if (wazm[i][k] >=0)
      return;
  wazW[i] = false;

};

void AwardWAZ::notWorkedString(const int tzone, const QString& tband, const QString& tmode){
  i = tzone;
  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;
  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;

  wazb[i][j] = -1;
  wazm[i][k] = -1;
  for (j = 0; j < BANDS; j++)
    if (wazb[i][j] >=0)
      return;
  for (k = 0; k < MODES; k++)
    if (wazm[i][k] >=0)
      return;
  wazW[i] = false;
};




bool AwardWAZ::isWorked(const int tzone){
  i = tzone;
  return wazW[i];
};

bool AwardWAZ::isWorkedBand (const int tzone, const int tband){
  i = tzone;
  j = tband;
  if (!wazW[i])
    return false;
  for (i = 1; i <  ZONES; i++){
    for (j = 0; j <  BANDS; j++){
     if (wazb[i][j] >= 0 )
        return true;
    };
  };
  return false;

};

bool AwardWAZ::isWorkedMode (const int tzone, const int tmode){
  i = tzone;
  k = tmode;
  if (!wazW[i])
    return false;
  for (i = 1; i <  ZONES; i++){
    for (k = 0; k <  MODES; k++){
     if (wazm[i][k] >= 0 )
        return true;
    };
  };
  return false;

};

int AwardWAZ::howManyWorkedBand(const int tband){
  iAux = 0;
  j = tband;
  for (i = 1; i < ZONES; i++){
    for (j = 0; j < BANDS; j++)
     if (wazb[i][j] >= 0 )
        iAux++;
  }
  return iAux;
};

int AwardWAZ::howManyWorkedMode(const int tmode){
  iAux = 0;
  k = tmode;
  for (i = 1; i < ZONES; i++){
    for (k = 0; k < MODES; k++)
     if (wazm[i][k] >= 0 )
        iAux++;
  }
  return iAux;

};

int AwardWAZ::howManyWorked(){

  iAux = 0;
  for (i = 1; i < ZONES; i++){
     if (wazW[i])
        iAux++;
  }
  return iAux;
//  return  wazCountWorked;
};


//================================
// CONFIRMED

void AwardWAZ::confirmed(const int tzone, const int tband, const int tmode){
  i = tzone;
  j = tband;
  k = tmode;
  wazb[i][j] = 1;
  wazm[i][k] = 1;
  wazC[i] = true;
};

void AwardWAZ::confirmedString(const int tzone, const QString& tband, const QString& tmode){
  i = tzone;

  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;
  wazb[i][j] = 1;
  wazm[i][k] = 1;
  wazC[i] = true;

};


bool AwardWAZ::isConfirmed(const int tzone){
  i = tzone;
  return wazC[i];
};

bool AwardWAZ::isConfirmedBand (const int tzone, const int tband){
  i = tzone;
  j = tband;
  if (!wazC[i])
    return false;
  for (i = 1; i <  ZONES; i++){
    for (j = 0; j <  BANDS; j++){
     if (wazb[i][j] == 1 )
        return true;
    };
  };
  return false;

};

bool AwardWAZ::isConfirmedMode (const int tzone, const int tmode){
  i = tzone;
  k = tmode;
  if (!wazC[i])
    return false;
  for (i = 1; i < ZONES; i++){
    for (k = 0; k <  MODES; k++){
     if (wazm[i][k] == 1 )
        return true;
    };
  };
  return false;

};

int AwardWAZ::howManyConfirmedBand(const int tband){
  iAux = 0;
  j = tband;
  for (i = 1; i < ZONES; i++){
    for (j = 0; j < BANDS; j++)
     if (wazb[i][j] == 1 )
        iAux++;
  }
  return iAux;
};

int AwardWAZ::howManyConfirmedMode(const int tmode){
  iAux = 0;
  k = tmode;
  for (i = 1; i < ZONES; i++){
    for (k = 0; k < MODES; k++)
     if (wazm[i][k] == 1 )
        iAux++;
  }
  return iAux;

};

int AwardWAZ::howManyConfirmed(){

  iAux = 0;
  for (i = 1; i < ZONES; i++){
     if (wazC[i])
        iAux++;
  }
  return iAux;

};


 void AwardWAZ::notConfirmed(const int tzone, const int tband, const int tmode){
  //Needs to have a way to check if it
  i = tzone;
  j = tband;
  k = tmode;
  wazb[i][j] = 0;
  wazm[i][k] = 0;
  for (j = 0; j < BANDS; j++)
    if (wazb[i][j] == 1)
      return;
  for (k = 0; k < MODES; k++)
    if (wazm[i][k] == 1)
      return;
  wazC[i] = false;

};

void AwardWAZ::notConfirmedString(const int tzone, const QString& tband, const QString& tmode){
  i = tzone;

  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;

  wazb[i][j] = 0;
  wazm[i][k] = 0;
  for (j = 0; j < BANDS; j++)
    if (wazb[i][j] ==1)
      return;
  for (k = 0; k < MODES; k++)
    if (wazm[i][k] ==1)
      return;
  wazC[i] = false;
};



 
