/***************************************************************************
                          awardwae.cpp  -  description
                             -------------------
    begin                : mi jul 2 2003
    copyright            : (C) 2003 by Jaime Robles
    email                : jaime@kde.org
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/
 /*
 This file comes from the awardwaz.cpp... ;-)
 */
 #include <klocale.h>
#include "awardwae.h"

AwardWAE::AwardWAE(){
  i = 0;
  j = 0;
  k = 0;
  for (i = 0; i <  ZONES; i++){
    AwardWAE::waeW[i] = false;
    AwardWAE::waeC[i] = false;
    for (j = 0; j <  BANDS; j++){
        AwardWAE::waeb[i][j] = -1;
    };
  };

  for (i = 0; i <  ZONES; i++){
      for (k = 0; k <  MODES; k++){
        AwardWAE::waem[i][k] = -1;

    };
  };
};


AwardWAE::~AwardWAE(){};

void AwardWAE::clear(){
  i = 0;
  j = 0;
  k = 0;
  for (i = 0; i <  ZONES; i++){
    AwardWAE::waeW[i] = false;
    AwardWAE::waeC[i] = false;
    for (j = 0; j <  BANDS; j++){
        AwardWAE::waeb[i][j] = -1;
    };
  };

  for (i = 0; i <  ZONES; i++){
      for (k = 0; k <  MODES; k++){
        AwardWAE::waem[i][k] = -1;

    };
  };

};
void AwardWAE::worked(const int tzone, const int tband, const int tmode){
  i = tzone;
  j = tband;
  k = tmode;
  waeb[i][j] = 0;
  waem[i][k] = 0;
  waeW[i] = true;

};

void AwardWAE::workedString(const int tzone, const QString& tband, const QString& tmode){
  i = tzone;
  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;

  waeb[i][j] = 0;
  waem[i][k] = 0;
  waeW[i] = true;
//  waeCountWorked++;

};

void AwardWAE::notWorked(const int tzone, const int tband, const int tmode){
  //Needs to have a way to check if it
  i = tzone;
  j = tband;
  k = tmode;
  waeb[i][j] = -1;
  waem[i][k] = -1;
  for (j = 0; j < BANDS; j++)
    if (waeb[i][j] >=0)
      return;
  for (k = 0; k < MODES; k++)
    if (waem[i][k] >=0)
      return;
  waeW[i] = false;

};

void AwardWAE::notWorkedString(const int tzone, const QString& tband, const QString& tmode){
  i = tzone;
  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;
  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;

  waeb[i][j] = -1;
  waem[i][k] = -1;
  for (j = 0; j < BANDS; j++)
    if (waeb[i][j] >=0)
      return;
  for (k = 0; k < MODES; k++)
    if (waem[i][k] >=0)
      return;
  waeW[i] = false;
};




bool AwardWAE::isWorked(const int tzone){
  i = tzone;
  return waeW[i];
};

bool AwardWAE::isWorkedBand (const int tzone, const int tband){
  i = tzone;
  j = tband;
  if (!waeW[i])
    return false;
  for (i = 0; i <  ZONES; i++){
    for (j = 0; j <  BANDS; j++){
     if (waeb[i][j] >= 0 )
        return true;
    };
  };
  return false;

};

bool AwardWAE::isWorkedMode (const int tzone, const int tmode){
  i = tzone;
  k = tmode;
  if (!waeW[i])
    return false;
  for (i = 0; i <  ZONES; i++){
    for (k = 0; k <  MODES; k++){
     if (waem[i][k] >= 0 )
        return true;
    };
  };
  return false;

};

int AwardWAE::howManyWorkedBand(const int tband){
  iAux = 0;
  j = tband;
  for (i = 0; i < ZONES; i++){
    for (j = 0; j < BANDS; j++)
     if (waeb[i][j] >= 0 )
        iAux++;
  }
  return iAux;
};

int AwardWAE::howManyWorkedMode(const int tmode){
  iAux = 0;
  k = tmode;
  for (i = 0; i < ZONES; i++){
    for (k = 0; k < MODES; k++)
     if (waem[i][k] >= 0 )
        iAux++;
  }
  return iAux;

};

int AwardWAE::howManyWorked(){

  iAux = 0;
  for (i = 0; i < ZONES; i++){
     if (waeW[i])
        iAux++;
  }
  return iAux;
//  return  waeCountWorked;
};


//================================
// CONFIRMED

void AwardWAE::confirmed(const int tzone, const int tband, const int tmode){
  i = tzone;
  j = tband;
  k = tmode;
  waeb[i][j] = 1;
  waem[i][k] = 1;
  waeC[i] = true;
};

void AwardWAE::confirmedString(const int tzone, const QString& tband, const QString& tmode){
  i = tzone;

  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;
  waeb[i][j] = 1;
  waem[i][k] = 1;
  waeC[i] = true;

};


bool AwardWAE::isConfirmed(const int tzone){
  i = tzone;
  return waeC[i];
};

bool AwardWAE::isConfirmedBand (const int tzone, const int tband){
  i = tzone;
  j = tband;
  if (!waeC[i])
    return false;
  for (i = 0; i <  ZONES; i++){
    for (j = 0; j <  BANDS; j++){
     if (waeb[i][j] == 1 )
        return true;
    };
  };
  return false;

};

bool AwardWAE::isConfirmedMode (const int tzone, const int tmode){
  i = tzone;
  k = tmode;
  if (!waeC[i])
    return false;
  for (i = 0; i < ZONES; i++){
    for (k = 0; k <  MODES; k++){
     if (waem[i][k] == 1 )
        return true;
    };
  };
  return false;

};

int AwardWAE::howManyConfirmedBand(const int tband){
  iAux = 0;
  j = tband;
  for (i = 0; i < ZONES; i++){
    for (j = 0; j < BANDS; j++)
     if (waeb[i][j] == 1 )
        iAux++;
  }
  return iAux;
};

int AwardWAE::howManyConfirmedMode(const int tmode){
  iAux = 0;
  k = tmode;
  for (i = 0; i < ZONES; i++){
    for (k = 0; k < MODES; k++)
     if (waem[i][k] == 1 )
        iAux++;
  }
  return iAux;

};

int AwardWAE::howManyConfirmed(){

  iAux = 0;
  for (i = 0; i < ZONES; i++){
     if (waeC[i])
        iAux++;
  }
  return iAux;

};


 void AwardWAE::notConfirmed(const int tzone, const int tband, const int tmode){
  //Needs to have a way to check if it
  i = tzone;
  j = tband;
  k = tmode;
  waeb[i][j] = 0;
  waem[i][k] = 0;
  for (j = 0; j < BANDS; j++)
    if (waeb[i][j] == 1)
      return;
  for (k = 0; k < MODES; k++)
    if (waem[i][k] == 1)
      return;
  waeC[i] = false;

};

void AwardWAE::notConfirmedString(const int tzone, const QString& tband, const QString& tmode){
  i = tzone;

  sAux = tband;
  j = adif.band2Int(sAux);
  if (j == -1)
    return;
  sAux = tmode;
  k = adif.mode2Int(sAux);
  if (k == -1)
    return;

  waeb[i][j] = 0;
  waem[i][k] = 0;
  for (j = 0; j < BANDS; j++)
    if (waeb[i][j] ==1)
      return;
  for (k = 0; k < MODES; k++)
    if (waem[i][k] ==1)
      return;
  waeC[i] = false;
};


