#ifndef CKLEARAPPTXTSTREAMER_H
#define CKLEARAPPTXTSTREAMER_H

#include <qthread.h>

#include "CKlearAppTXTDecoder.h"
#include "../CKlearAppConfig.h"

/**
Filters for PID 0x0000 (PAT) on demux device, grabs data and passes the buffer to the decoder
@author Omar El-Dakhloul <omar@klear.org> with many code from dvbsnoop, vlc and libdvbpsi
*/
class CKlearAppTXTStreamer : public QThread
{
public:
  CKlearAppTXTStreamer( CKlearAppConfig *config, CKlearAppTXTDecoder *decoder);
  ~CKlearAppTXTStreamer();

  void setRunning( bool status );

private:
  int pid;
  int fd;
  bool isRunning;
  u_char buf[ READ_BUF_SIZE ];

  int getPid();
  long readSectionBuffer();
  long readSectorLoop();
  long readPackHeader( int fd, u_char *buf );
  void run();
  void readContent();
  void tearDownDemux();
  void setPid( int pid );
  void setSectionDemux();
  void setPesDemux();
  void readPesBuffer();

  CKlearAppConfig *KlearConfig;
  CKlearAppTXTDecoder *TXTDecoder;
};

#endif
