/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "pushkey.h"
#include "keyboardwidget.h"
#include <qstring.h>
#include <kglobal.h>
#include <kiconloader.h>

#include <iostream>
using namespace std;

PushKey::PushKey(sendKey * wire, const KeyCode mycode, QWidget * parent, const char * name)
	: QPushButton( parent, name )
{
	this->wire	= wire;
	this->code	= mycode;
	this->lx	= 0;
	this->ly	= 0;
	this->setFocusPolicy(NoFocus);
	this->setFlat(true);

	QFont f( "OpenSymbol", 8, QFont::Normal );
	setFont( f );
	this->setLabel();
}

PushKey::~PushKey()
{
}
string	PushKey::getIconName(KeyCode kc)
{
	switch(kc)
	{
		case 98:	return "key_up";
		case 23:	return "key_tab";
		case 66:	return "key_caps";
		case 50:	return "key_maj";
		case 62:	return "key_maj";
		case 116:	return "klogo";
		case 117:	return "key_menu";
		case 115:	return "klogo";
		case 100:	return "key_left";
		case 104:	return "key_down";
		case 102:	return "key_right";
		case 108:	return "key_return";
		case 105:	return "key_page_down";
		case 99:	return "key_page_up";
//		case 103:	return "
		case 97:	return "key_home";
		case 22:	return "key_backspace";
		case 36:	return "key_return";
		default:	return "";
	}
}
	
void	PushKey::setLabel()
{
	QString ret;
	KeySym tmp;

	if (this->wire != NULL)
	{
		sendKey::keyValue	*kv = this->wire->getKeyValue(this->code);
		if (kv != NULL)
		{
			KeyCode		kc = this->code;
			string	r	= this->getIconName(kc);
			if (r != "")
			{
				this->setPixmap(KGlobal::iconLoader()->loadIcon(r, KIcon::NoGroup, KIcon::SizeSmall));
			}
			else
			{
				if ( (66<kc&&kc<78) || (94<kc&&kc<97) )
					ret	= this->wire->keysymToString(kv->normal);
				else if ( (23<kc&&kc<34) || (37<kc&&kc<48) || (51<kc&&kc<58) || (78<kc&&kc<82) || (82<kc&&kc<86) || (86<kc&&kc<91) )
				{
					tmp	= kv->shift;
					if (tmp > 0)
						ret = this->wire->keysymToString(tmp);
					else
						ret = this->wire->keysymToString(kv->normal);
				}
				else
				{
					ret	= this->wire->keysymToString(kv->normal);
					tmp	= kv->shift;
					if (tmp > 0)
					{
						ret.prepend("\n");
						ret.prepend(this->wire->keysymToString(tmp));
					}
					tmp	= kv->altgr;
					if (tmp > 0)
					{
						ret.append(" ");
						ret.append(this->wire->keysymToString(tmp));
					}
				}
				this->setText(ret);
			}
		}
	}
}

void	PushKey::setLogicalCoord(const int x, const int y)
{
	this->lx	= x;
	this->ly	= y;	
}
void	PushKey::resizeToLogical(const QSize & size)
{
	double x, y, w, h;
	w	= ((size.width()- 2) / (NUM_KEY_COLS+1.6));
	h	= ((size.height()- 2) / (NUM_KEY_ROWS+0.3));
	x	= w * this->lx + 2;
	y	= h * this->ly + 2;
	
	if ( 0 < this->lx && this->lx < 14 && 1 < this->ly && this->ly < 4)
		x	+= 8*(this->ly - 1);	// indent letter
	if (this->ly > 0)
		y	+= 0.3*h;		// add a space between fonction keys and the other
	if (this->lx > 13)
		x	+= w* 1.3;		// move a little bit the nav pad
	if (this->lx > 16)
		x	+= w* 0.3;		// move the key pad a bit more
	if (this->ly == 0 && this->lx < 14)
	{					// space the fonction keys
		if (this->lx>8)
			x	+= 2*w;
		else if (this->lx>4)
			x	+= 1.5*w;
		else if (this->lx>0)
			x	+= w;
	}
	if (this->lx == 13 && 0 < this->ly && this->ly < 3 )
		w	+= w - 8*(this->ly - 1);// enlarge enter, backspace
	if (this->lx == 12 && this->ly == 4 )
		w	+= 2*w;			// enlarge right_shift
	if (this->lx == 0 && 1 < this->ly && this->ly < 4)
		w	+= 8*(this->ly - 1);	// enlarge tab, caps,left_shift
	if (this->lx == 20 && (this->ly == 2 || this->ly == 4))
		h	+= h;			// higher for + and kp_enter
	if (this->ly == 5)
	{
		if ( 0 < this->lx && this->lx < 14)
			x	+= 8;			// align the modifier line with the first letter line (qwertyuiop one)
		if (this->lx == 3)
			w	+= 6*w;			// enlarge space bar
		if (this->lx == 17)
			w	+= w;			// enlarge kp_0
		if (this->lx == 0)
			w	+= 8;
		if (this->lx == 13)
			w	+= w - 8;
	}
	this->setGeometry( QRect((int)x, (int)y, (int)w, (int)h) );
}
