/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */
#include <config.h>


#include "activityviewer.h"
#include "dbviewer.h"
#include "klamav.h"
#include "klamavconfig.h"
#include "collectiondb.h"


#include <klocale.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kkeydialog.h>
#include <kio/netaccess.h>
#include <kfiledialog.h>
#include <kdebug.h>
#include <klistviewsearchline.h>
#include <ktoolbarbutton.h> //ctor


#include <kbuttonbox.h>
#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <kcombobox.h>
#include <qlayout.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>
#include <qtoolbutton.h>

const char *log_type[] = {
    "All Types",
    "Launch",
	"Shutdown",
    "Manual Scan",
	"Error Found",
	"Virus Found",
    "Auto-Scan",
    "Updates",
    "Quarantine",
    0
};

const char *log_days[] = {
    "Last 1 Day",
    "Last 2 Days",
    "Last 7 Days",
    "Last 14 Days",
    "Last 31 Days",
    "Last 62 Days",
    "Last 365 Days",
    0
};


Activityviewer::Activityviewer(QWidget *parent, const char *name)
    : QWidget(parent, name)
{

	//Create GUI	

	QVBoxLayout *vbox = new QVBoxLayout(this, KDialog::marginHint(),
			KDialog::spacingHint(), "vbox");

 	QWidget* privateLayoutWidget2 = new QWidget( this, "dblayout" );

	QGridLayout *layout = new QGridLayout(privateLayoutWidget2, 2, 6, 10, 4);

	QLabel *combo_label = new QLabel(i18n("Display Event Type:"), privateLayoutWidget2);
	//combo_label->setFixedSize(combo_label->sizeHint());
	layout->addWidget(combo_label,0,0);
        combo_label->adjustSize();

	check_combo = new QComboBox(false, privateLayoutWidget2);
	check_combo->insertStrList(log_type);
	check_combo->adjustSize();
	//check_combo->setFixedSize(check_combo->size());
	layout->addWidget(check_combo,0,1);

	QLabel *days_label = new QLabel(i18n(" from the "), privateLayoutWidget2);
	//combo_label->setFixedSize(combo_label->sizeHint());
	layout->addWidget(days_label,0,2);
        days_label->adjustSize();

	days_combo = new QComboBox(false, privateLayoutWidget2);
	days_combo->insertStrList(log_days);
	days_combo->adjustSize();
	//check_combo->setFixedSize(check_combo->size());
	layout->addWidget(days_combo,0,3);
	


 	QToolButton* options = new QToolButton( privateLayoutWidget2,"play" );
 	options->setIconSet( SmallIconSet( "configure" ) );
	options->setTextLabel("Options");
	options->setTextPosition(QToolButton::Right);
	options->setUsesTextLabel(true);
 	options->adjustSize();
 	layout->addWidget(options,0,6);

	vbox->addWidget(privateLayoutWidget2);
 	connect( options, SIGNAL(clicked()), SLOT(slotOptions()) );



	QGroupBox *group2 = new QGroupBox(i18n("Activity"), this);
	vbox->addWidget(group2);

	QGridLayout *layout2 = new QGridLayout( group2, 1, 1, KDialog::spacingHint(),	KDialog::spacingHint(), "layout2");
	layout2->addRowSpacing(0, group2->fontMetrics().height());
	layout2->addRowSpacing(1, group2->fontMetrics().height());
	//layout2->setColStretch(0, 1);
	//layout2->setColStretch(1, 1);

	QWidget *hlp2 = new QWidget( group2 );
	layout2->addMultiCellWidget(hlp2, 1,1, 0,0);
	QVBoxLayout *dir_layout2 = new QVBoxLayout(hlp2, KDialog::spacingHint() );



	KToolBarButton *button;
	KToolBar* searchToolBar = new KToolBar( hlp2 );
	searchToolBar->setMovingEnabled(false);
	searchToolBar->setFlat(true);
	searchToolBar->setIconSize( 16 );
	searchToolBar->setEnableContextMenu( false );

	button = new KToolBarButton( "locationbar_erase", 0, searchToolBar );
        /*QLabel *filter_label =*/ new QLabel( i18n("Search:") + " ", searchToolBar );


	currentbox = new KListView(hlp2);
        currentbox->setShowSortIndicator(true);
    
	QFontMetrics rb_fm(currentbox->fontMetrics());
	//currentbox->setMinimumSize(rb_fm.width("0")*55,
	//			rb_fm.lineSpacing()*15);
	////kdDebug() << ((currentbox->width())/3) << endl;
	currentbox->addColumn( "Date",0);
	currentbox->addColumn( "Type",0);
        currentbox->addColumn( "Event",0);
        currentbox->addColumn( "File",0);
	currentbox->setResizeMode(QListView::AllColumns);
	currentbox->setSelectionMode( QListView::Extended );
	currentbox->setAllColumnsShowFocus(true);

// 	qmenu = new QPopupMenu( currentbox );

//     	connect(currentbox, SIGNAL( contextMenuRequested( QListViewItem *, const QPoint& , int ) ), 
// 		this, SLOT( slotRMB( QListViewItem *, const QPoint &, int ) ) );

	kLineEdit1 = new KListViewSearchLine( (QWidget *)searchToolBar, currentbox,"klinedit1");
/*	QValueList<int> columns;
        columns.append(0);
	columns.append(1);
	columns.append(2);*/
/*	kLineEdit1->setSearchColumns();*/
	//kLineEdit1->setMaxLength(2);
	connect(button, SIGNAL( clicked() ),
	                kLineEdit1, SLOT(clear()) );
	connect(check_combo, SIGNAL( activated(const QString &) ),
	                this, SLOT(allActivityOfType(const QString &) ));
	connect(days_combo, SIGNAL( activated(const QString &) ),
	                this, SLOT(allActivityOfDate(const QString &) ));


        searchToolBar->setStretchableWidget( kLineEdit1 );

	dir_layout2->addWidget( searchToolBar,0,0);

	dir_layout2->addWidget(currentbox,1,0);
	
	//layout->addMultiCellWidget(currentbox);

	CollectionDB::instance()->expireActivity( QString("%1").arg(KlamavConfig::expireDays()) );

 	allActivityOfDate(days_combo->currentText());
	

}

void Activityviewer::populateActivity()
{

	currentbox->clear();

	if (!(activity.isEmpty())){

		int i=0;
		QString eventdate;
		QString eventtype;
		QString event;
		QString file;
		for (QStringList::Iterator it = activity.begin(); it != activity.end(); it++ ){
			////kdDebug() << *it << endl;
			if (i==0){
				eventdate = *it;
				i++;
			}else if (i==1){
				eventtype = *it;
				i++;
			}else if (i==2){
				event = *it;
				i++;
			}else if (i==3){
				file = *it;
				i=0;
				new EventListItem( currentbox, eventdate, eventtype,event, file);
			}
		}
	}
}

void Activityviewer::allActivity()
{

	activity = CollectionDB::instance()->allActivity();

	populateActivity();	
}

void Activityviewer::allActivityOfType(const QString &type)
{


	QString days = days_combo->currentText().remove("Last ").remove(" Days").remove(" Day");

	activity = CollectionDB::instance()->allActivityOfType(type,days);

	populateActivity();	
}

void Activityviewer::allActivityOfDate(const QString &days)
{
	QString stripdays = days;
	stripdays = stripdays.remove("Last ").remove(" Days").remove(" Day");
	QString type = check_combo->currentText();

	activity = CollectionDB::instance()->allActivityOfType(type,stripdays);

	populateActivity();	
}

void Activityviewer::insertItem(const  QString &date, const  QString &type, const QString &event, const QString &file)
{

    if ((check_combo->currentText() == type) || (check_combo->currentText() == "All Types"))
        new EventListItem( currentbox, date, type, event, file);

}

void  Activityviewer::slotOptions(){

	
	kmain->slotConfigKlamav( "Event Logging" );	

}


Activityviewer::~Activityviewer()
{
}

EventListItem::EventListItem( KListView *parent, QString label1, QString label2 , QString label3, QString label4)
    : KListViewItem( parent, label1, label2 , label3, label4 )
{
}
 
EventListItem::~EventListItem()
{
}


// paint ze peons
void EventListItem::paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
    	QColorGroup cg2(cg);
    

	if (( this->text(1).contains( "Virus")) || ( this->text(1).contains( "Error")))
		cg2.setColor(QColorGroup::Text, Qt::red);
	else if ( this->text(1) == "Updates")
		cg2.setColor(QColorGroup::Text, Qt::blue);
	else if ( this->text(1) == "Quarantine")
		cg2.setColor(QColorGroup::Text, Qt::green);

    	KListViewItem::paintCell( p, cg2, column, width, align );

}



#include "activityviewer.moc"
