/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#include "scanviewer.h"
#include "klamav.h"
#include "freshklam.h"
#include "directorylist.h"
#include "dbviewer.h"

#include <config.h>



#include <klocale.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kio/netaccess.h>
#include <knotifyclient.h>
#include <kprocess.h>
#include <qlayout.h>
#include <kcmdlineargs.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>
#include <ksystemtray.h>




ScanViewer::ScanViewer(QWidget *parent, const char *name)
    : QWidget(parent, name)
{

    scanInProgress = TRUE;    
    multiScan = FALSE;    
    
    //QGridLayout *layout = new QGridLayout(this, 6, 3, 10, 4);
    QGridLayout *layout = new QGridLayout(this, 6, 3, 10, 4);
    layout->setColStretch(0, 10);
    layout->addColSpacing(1, 10);
    layout->setColStretch(1, 0);
    layout->setColStretch(2, 1);
    layout->addRowSpacing(1, 10);
    layout->setRowStretch(1, 0);
    layout->setRowStretch(2, 10);
    layout->addRowSpacing(4, 10);
    layout->setRowStretch(4, 0);
    
    
    
    resultview = new QListView(this);
    resultview->setShowSortIndicator(true);

    QFontMetrics rb_fm(resultview->fontMetrics());
    //resultview->setMinimumSize(rb_fm.width("0")*55,
    //            rb_fm.lineSpacing()*15);
    resultview->addColumn( "Name of File",(resultview->width()/3));
        resultview->addColumn( "Name of Virus Found",(resultview->width()/3));
    resultview->addColumn( "Status",(resultview->width()/3));
    resultview->setResizeMode(QListView::AllColumns);
    resultview->setSelectionMode( QListView::Extended );
    resultview->setAllColumnsShowFocus(true);
    layout->addMultiCellWidget(resultview, 2, 2, 0, 2);

    menu = new QPopupMenu( resultview );

        connect(resultview, SIGNAL( contextMenuRequested( QListViewItem *, const QPoint& , int ) ), 
        this, SLOT( slotRMB( QListViewItem *, const QPoint &, int ) ) );
        
    QFrame *status_frame = new QFrame(this);
    status_frame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    QBoxLayout *status_layout = new QHBoxLayout(status_frame, 2);
    

    status_label = new QLabel("", status_frame);
    status_layout->addWidget(status_label, 10);
    
    //matches_label = new QLabel(status_frame);
    //QFontMetrics ml_fm(matches_label->fontMetrics());
    //matches_label->setFixedWidth(ml_fm.width(i18n("9999 viruseses/errors found")));
    //matches_label->setFixedHeight(ml_fm.lineSpacing());
    //status_layout->addWidget(matches_label, 0);
    
    
    status_layout->activate();
    status_frame->adjustSize();
    status_frame->setMinimumSize(status_frame->size());
    layout->addMultiCellWidget(status_frame, 3, 3, 0, 2);

    QFrame *status2_frame = new QFrame(this);
    status2_frame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    QBoxLayout *status2_layout = new QHBoxLayout(status2_frame, 2);
    
    status2_label = new QLabel(i18n("Ready"), status2_frame);
    status2_layout->addWidget(status2_label, 10);

    matches2_label = new QLabel(status2_frame);
    QFontMetrics ml_fm2(matches2_label->fontMetrics());
    matches2_label->setFixedWidth(ml_fm2.width(i18n("9999 viruseses/errors found")));
    matches2_label->setFixedHeight(ml_fm2.lineSpacing());
    status2_layout->addWidget(matches2_label, 0);
    
    status2_layout->activate();
    status2_frame->adjustSize();
    status2_frame->setMinimumSize(status2_frame->size());
    layout->addMultiCellWidget(status2_frame, 4, 4, 0, 2);

        
    layout->activate();


}

ScanViewer::~ScanViewer()
{

    if (childproc){
        delete childproc;
        childproc = 0;
    }
}



void ScanViewer::processOutput()
{
    int pos;
    QString item2;


    buf.replace("//","/"); // don't know why they're getting two slashes
    for (int j=0; buf.section('\n',j,j) != ""; j++ ){
            item2 = (buf.section('\n',j,j)).stripWhiteSpace();
            int fnameStartPoint = 0;
            int fnameEndPoint = item2.findRev(":");
            QString tmpFName = item2.mid(fnameStartPoint,(fnameEndPoint - fnameStartPoint));

            if ((pos = buf.section('\n',j,j).find("FOUND")) != -1){
                QString tmpVirusName = item2.mid((fnameEndPoint+1),(item2.length() - (fnameEndPoint+1)));
                QDate today = QDate::currentDate();
                QTime now = QTime::currentTime();
                QString suffix = QString(":%1 %2")
                    .arg(today.toString("ddd MMMM d yyyy"))
                    .arg(now.toString("hh-mm-ss-zzz ap"));

                //kdDebug() << "klamscan: suffix " << suffix << endl;
                //kdDebug() << "klamscan: tmpFName " << tmpFName << endl;
                //kdDebug() << "klamscan: tmpVirusName " << tmpVirusName << endl;
                if ((tmpVirusName.find("FOUND")) != -1){
                    tmpVirusName.replace("FOUND","");
                    QListViewItem* tm = new QListViewItem( resultview, tmpFName, tmpVirusName,"Loose");
                    tm->setPixmap( 0, SmallIcon("klamav") );
                    //resultview->insertItem(buf.section('\n',j,j));
                    QuarantineList.append(tmpFName+":"+tmpVirusName+suffix);
                }
                status2_label->setText(i18n("Files scanned: %1").arg(++filesscanned));
            }else if ((pos = buf.section('\n',j,j).find("ERROR:")) != -1){
                QString tmpVirusName = item2.mid((fnameEndPoint+1),(item2.length() - (fnameEndPoint+1)));
                new QListViewItem( resultview, tmpFName, tmpVirusName,"Not a Virus");
                //resultview->insertItem(buf.section('\n',j,j));
                errorsEncountered = TRUE;
                status2_label->setText(i18n("Files scanned: %1").arg(++filesscanned));
            }else if ((pos = buf.section('\n',j,j).find("Scanning ")) != -1){
                status_label->setText(buf.section('\n',j,j));
            }else if ((pos = buf.section('\n',j,j).find(": OK")) != -1){
                status2_label->setText(i18n("Files scanned: %1").arg(++filesscanned));
            }
//             if ((!tmpFName.contains(prevdir))){
//                 for (QStringList::Iterator it = listOfUrlsToScan.begin(); it != listOfUrlsToScan.end(); it++ ){
//                     if (tmpFName.contains(*it)){
//                         //kdDebug() << tmpFName.section('/',0,-1) << endl;
//                         prevdir = tmpFName.section('/',0,-1);
//                         dir_combo->setCurrentText(*it);
//                     }
//                 }
//             }

        }

    buf = "";

    QString str;
    str.setNum(resultview->childCount());

    str += i18n(" viruseses/errors found");
    matches2_label->setText(str);
}


void ScanViewer::slotScan(const QString & filepattern, int mode, bool recursive)
{

    //KMessageBox::information (this, filepattern);    

    m_mode = mode;
    m_filepattern = filepattern;
    m_recursive = recursive;
    config = KGlobal::config();

    slotClear();
    QuarantineList.clear();
//    cancel_button->setEnabled(true);
    
    errorsEncountered = FALSE;
    filesscanned = 0;
    status2_label->setText(i18n("Scan in Progress..."));

    QString db;
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    if(!( args->isSet( "scanthis" ) ) )
        db = kmain->freshklam->getCurrentDBDir();
    else{
        config->setGroup("Freshklam");
        QStringList lastDownloadPaths = config->readListEntry("lastDownloadPaths");
        for (QStringList::Iterator ita = lastDownloadPaths.begin(); ita == lastDownloadPaths.begin() ; ita++){
            db = *ita;
        }
    }
    
    //kdDebug() << "here 2" << endl;    
    QString dbpath;
    QString excludes;
    QString options;
    
    if (!(db.isEmpty()))
        dbpath = QString(" -d %1 ").arg(db);

    config->setGroup("Klamscan");
    
    if (config->readEntry("ExcludeQuarantine") == "Yes"){
        config->setGroup("Kuarantine");
        QStringList lastQuarLocations = config->readListEntry("KuarantineLocations");
        QString quarloc;
        for (QStringList::Iterator ita = lastQuarLocations.begin(); ita == lastQuarLocations.begin() ; ita++){
                quarloc = *ita;
        }
        excludes += QString(" --exclude=%1 ").arg(quarloc);
    }

    
    //if ((recursive_box->isChecked() && !(multiScan)) || (multi_recursive && multiScan))
    if (recursive)
        options += " -r ";

    config->setGroup("Klamscan");


    if (!(config->readEntry("NoFilesToExtract")).isEmpty());
        options += "--max-files=" + config->readEntry("NoFilesToExtract")+" ";

    if (!(config->readEntry("MBsToExtract")).isEmpty());
        options += "--max-space=" + config->readEntry("MBsToExtract")+" ";
        
    if (!(config->readEntry("CompressionRatio")).isEmpty());
        options += "--max-ratio=" + config->readEntry("CompressionRatio")+" ";

    if (!(config->readEntry("RecursionLevel")).isEmpty());
        options += "--max-recursion=" + config->readEntry("RecursionLevel")+" ";


    config->setGroup("Klamscan");
    if (config->readEntry("VirusLimitsExceeded") == "Yes")
        options += "--block-max ";

    if (config->readEntry("VirusEncrypted") == "Yes")
        options += "--block-encrypted ";

    if (config->readEntry("ScanMail") == "No")
        options += "--no-mail ";

    if (config->readEntry("ScanHTML") == "No")
        options += "--no-html ";
        
    if (config->readEntry("ScanPE") == "No")
        options += "--no-pe ";

    if (config->readEntry("ScanOle") == "No")
        options += "--no-ole2 ";

    if (config->readEntry("VirusBroken") == "Yes")
        options += "--detect-broken ";


    if (config->readEntry("ScanZip") == "Yes"){
        options += "--unzip";
        if (config->readEntry("ZipUsing") != "")
            options += "="+config->readEntry("ZipUsing")+" ";
        else
            options+=" ";
    }

    if (config->readEntry("ScanRar") == "Yes"){
        options += "--unrar";
        if (config->readEntry("RarUsing") != "")
            options += "="+config->readEntry("RarUsing")+" ";
        else
            options+=" ";
    }
    
    if (config->readEntry("ScanArj") == "Yes"){
        options += "--unarj";
        if (config->readEntry("ArjUsing") != "")
            options += "="+config->readEntry("ArjUsing")+" ";
        else
            options+=" ";
    }

    if (config->readEntry("ScanZoo") == "Yes"){
        options += "--unzoo";
        if (config->readEntry("ZooUsing") != "")
            options += "="+config->readEntry("ZooUsing")+" ";
        else
            options+=" ";
    }
    
    if (config->readEntry("ScanLzh") == "Yes"){
        options += "--lha";
        if (config->readEntry("LzhUsing") != "")
            options += "="+config->readEntry("LzhUsing")+" ";
        else
            options+=" ";
    }

    if (config->readEntry("ScanJar") == "Yes"){
        options += "--jar";
        if (config->readEntry("JarUsing") != "")
            options += "="+config->readEntry("JarUsing")+" ";
        else
            options+=" ";
    }

    if (config->readEntry("ScanDeb") == "Yes"){
        options += "--deb";
        if (config->readEntry("DebUsing") != "")
            options += "="+config->readEntry("DebUsing")+" ";
        else
            options+=" ";
    }

    if (config->readEntry("ScanTar") == "Yes"){
        options += "--tar";
        if (config->readEntry("TarUsing") != "")
            options += "="+config->readEntry("TarUsing")+" ";
        else
            options+=" ";
    }

    if (config->readEntry("ScanTgz") == "Yes"){
        options += "--tgz";
        if (config->readEntry("TgzUsing") != "")
            options += "="+config->readEntry("TgzUsing")+" ";
        else
            options+=" ";
    }

    
    childproc = new KShellProcess();
    *childproc << "clamscan -v ";
    *childproc << excludes << " ";
    *childproc << dbpath << " ";
    *childproc << options << " ";
    
    *childproc << m_filepattern;

    //KMessageBox::information (this,QString("clamscan -v " + excludes + " " + dbpath + " " + options + " " + m_filepattern));    

    connect( childproc, SIGNAL(processExited(KProcess *)),
        SLOT(childExited()) );
    connect( childproc, SIGNAL(receivedStdout(KProcess *, char *, int)),
        SLOT(receivedOutput(KProcess *, char *, int)) );
    // actually it should be checked whether the process was started succesfully
    /*bool success=*/childproc->start(KProcess::NotifyOnExit, KProcess::Stdout);
    menu->setEnabled(FALSE);

    scanInProgress = TRUE;
}


void ScanViewer::finish()
{
//    search_button->setEnabled(true);
//    cancel_button->setEnabled(false);

    buf += '\n';
    processOutput();
    delete childproc;
    childproc = 0;


    //kdDebug() << "finishing klamscan" << endl;
    status_label->setText("If viruses were found, you can right-click to quarantine selected files.");
    menu->setEnabled(TRUE);
    //dir_combo->setEnabled(TRUE);

    multiScan = FALSE;
    scanInProgress = FALSE;
    emit scanFinished(this);
}


void ScanViewer::slotCancel()
{
    finish();

    status2_label->setText(i18n("Cancelled"));

}


void ScanViewer::childExited()
{
    int status = childproc->exitStatus();

    int result;
    
    status2_label->setText( i18n("Scan Complete") );

    if (status == 0){
        if (!(errorsEncountered))
            KNotifyClient::event(kmain->_tray->winId(),"ScanCompleteNoVirus", "Scan Complete - No Viruses Found!");
        else
            KNotifyClient::event(kmain->_tray->winId(),"ScanCompleteNoVirusButErrors", "Scan Complete - No Viruses Found But Some Errors Encountered!");

    }else if(status == 1){
        switch (m_mode) {
        case 0:
            result = KMessageBox::warningContinueCancelList(this, i18n( "I'm going to quarantine this lot, you can restore them later if you want. If you don't want to quarantine, just press cancel."),QuarantineList,i18n( "Quarantine Infected Files" ),i18n( "Quarantine" ));
            switch (result) {
                case 2 : KMessageBox::information (this,"Infected Items have not been quarantined.");  break;
                case 5 : Quarantine(); break;
            }
            break;
        case 1:
            Quarantine(); break;
        default:
            KMessageBox::information (this,"Scan Complete - Viruses Found!");break;
    }
       }else if (status ==40){ KMessageBox::information (this,"Unknown option passed.");

       }else if (status ==50){ KMessageBox::information (this,"Database initialization error.");

       }else if (status ==52){ KMessageBox::information (this,"Not supported file type.");

       }else if (status ==53){ KMessageBox::information (this,"Can't open directory.");

       }else if (status ==54){ KMessageBox::information (this,"Can't open file. (ofm)");

       }else if (status ==55){ KMessageBox::information (this,"Error reading file. (ofm)");

       }else if (status ==56){ KMessageBox::information (this,"Can't stat input file / directory.");

       }else if (status ==57){ KMessageBox::information (this,"Can't get absolute path name of current working directory.");

       }else if (status ==58){ KMessageBox::information (this,"I/O error, please check your filesystem.");

       }else if (status ==59){ KMessageBox::information (this,"Can't get information about current user from /etc/passwd.");

       }else if (status ==60){ KMessageBox::information (this,"Can't get information about user 'clamav' (default name) from /etc/passwd.");

       }else if (status ==61){ KMessageBox::information (this,"Can't fork.");

       }else if (status ==63){ KMessageBox::information (this,"Can't create temporary files/directories (check permissions).");

       }else if (status ==64){ KMessageBox::information (this,"Can't write to temporary directory (please specify another one).");

       }else if (status ==70){ KMessageBox::information (this,"Can't allocate and clear memory (calloc).");

       }else if (status ==71){ KMessageBox::information (this,"Can't allocate memory (malloc).");

       }else if (status ==71){KMessageBox::information (this,"Unspecified Error!");
    }

    status2_label->setText( i18n("Ready") );

    finish();

    //if (status != 0)
          //matches_label->setText("");

}


void ScanViewer::receivedOutput(KProcess */*proc*/, char *buffer, int buflen)
{
    buf += QCString(buffer, buflen+1);
    processOutput();
}


void ScanViewer::slotClear()
{
    //finish();
    resultview->clear();

    status2_label->setText(i18n("Ready"));
    matches2_label->setText("");
}


// void  ScanViewer::setDirName(QString dir){
// //    dir_combo->setEditText(dir);
//     dir_combo->setCurrentText(dir);
// }

void  ScanViewer::Quarantine(){
    
    //config = KGlobal::config();
    config->setGroup("Kuarantine");
    //lastQuarItems = config->readListEntry("KuarantineItems");
    QStringList lastQuarLocations = config->readListEntry("KuarantineLocations");
    
    QString quarloc;
    for (QStringList::Iterator it = lastQuarLocations.begin(); it == lastQuarLocations.begin() ; it++){
            quarloc = *it;
    }
        
    //Get Items for this location
    
    lastQuarItems = config->readListEntry(QString("Items %1").arg(quarloc));
    
    
    for (QStringList::Iterator it = QuarantineList.begin(); it != QuarantineList.end(); it++ ){
        if (lastQuarItems.contains(*it) != 0) {
            lastQuarItems.remove(*it);
        }
        QString item2 = (*it).stripWhiteSpace();
        //kdDebug() << item2 << endl;
        int fnameStartPoint = 0;
        int dtStartPoint = item2.findRev(":");
        int fnameEndPoint = item2.findRev(":", (signed int)-((item2.length() - dtStartPoint)+1));
        //kdDebug() << QString("%1").arg((signed int)-((item2.length() - dtStartPoint)+1)) << endl;
        //kdDebug() << QString("%1").arg(dtStartPoint) << endl;
        //kdDebug() << QString("%1").arg(fnameEndPoint) << endl;
        QString fname = item2.mid(fnameStartPoint,(fnameEndPoint - fnameStartPoint));
        QString itemName = item2.mid((fnameEndPoint+1),((dtStartPoint+1) - (fnameEndPoint+2)));
        QString when = item2.mid((dtStartPoint+1),(item2.length() - (dtStartPoint+1)));
        //kdDebug() << fname << endl;
        //kdDebug() << itemName << endl;
        //kdDebug() << when << endl;
        if (!(fname.isEmpty())){
            QStringList tokens = QStringList::split ( "/", fname, FALSE );
            QString qname = tokens.last();
            qname.prepend("/");
            qname.prepend(quarloc);
            qname.append(":"+when);
            /*
            QString suCommand=QString("mv -f '%1' '%2'").arg(fname).arg(qname);
            KProcIO *proc = new KProcIO();
            proc->setUseShell(TRUE);
            *proc<<suCommand;
            
            proc->start(KProcIO::NotifyOnExit);
            */
            if (KIO::NetAccess::file_move(fname,qname)){
                if (lastQuarItems.contains(item2))
                    lastQuarItems.remove(item2);
                lastQuarItems.prepend(item2);
                (resultview->findItem(fname,0))->setText(2,"Quarantined");
                    (resultview->findItem(fname,0))->setPixmap( 0, SmallIcon("klamavbw") );
                chmod((const char *)qname,0400);

            }else{
                KMessageBox::information (this,i18n("<p>There was a problem quarantining <b>%1</b>. Check your diskspace, the permissions on your quarantine location and whether a file with the same name already exists in the quarantine. </p>").arg(fname));
            }

            
        }
    }
    config->writeEntry(QString("Items %1").arg(quarloc), lastQuarItems);
    config->sync();
    
    //kmain->kuarantine->refresh();



}

void ScanViewer::slotRMB( QListViewItem* Item, const QPoint & point, int )
{

    if( Item ){
    QPixmap gicon;
    QPixmap vicon;
    QPixmap ticon;

        QString iconPath = locate("cache", KMimeType::favIconForURL("http://viruspool.vanderkooij.org")+".png");
        if ( iconPath.isEmpty() )
          vicon = SmallIcon("find");
        else
          vicon = QPixmap( iconPath );

        iconPath = locate("cache", KMimeType::favIconForURL("http://www.google.com")+".png");
        if ( iconPath.isEmpty() )
          gicon = SmallIcon("find");
        else
          gicon = QPixmap( iconPath );

        iconPath = locate("cache", KMimeType::favIconForURL("http://www.trendmicro.com")+".png");
        if ( iconPath.isEmpty() )
          ticon = SmallIcon("find");
        else
          ticon = QPixmap( iconPath );

    menu->clear();
        menu->insertItem( "Quarantine Selected", this,SLOT(slotQuarantineSelected()) );
        menu->insertItem( vicon,QString("Search for %1 with VirusPool").arg(Item->text(1)), this, SLOT(slotVirusPool()) );
        menu->insertItem( ticon,QString("Search for %1 with Trend Micro").arg(Item->text(1)), this, SLOT(slotTrendMicro()) );

        menu->insertItem( gicon,QString("Search for %1 with Google").arg(Item->text(1)), this, SLOT(slotGoogle()) );
        menu->popup( point );
     }
}

void ScanViewer::slotQuarantineSelected()
{

           QPtrList<QListViewItem> list;
    QListViewItemIterator it( resultview, QListViewItemIterator::Selected );
    
    QuarantineList = "";
        while ( it.current() ) {
        QListViewItem* tItem = it.current();
        
        QDate today = QDate::currentDate();
        QTime now = QTime::currentTime();
        QString suffix = QString(":%1 %2")
            .arg(today.toString("ddd MMMM d yyyy"))
            .arg(now.toString("hh-mm-ss ap"));

        QuarantineList.append(tItem->text(0)+":"+tItem->text(1)+suffix);
        ++it;
    }

    Quarantine();
}



void ScanViewer::slotGoogle()
{
    QString name = resultview->currentItem()->text(1);
    kmain->klamdb->slotExternal(name, "Google");
}

void ScanViewer::slotVirusPool()
{
    QString name = resultview->currentItem()->text(1);
    kmain->klamdb->slotExternal(name, "VirusPool");
}

void ScanViewer::slotTrendMicro()
{
    QString name = resultview->currentItem()->text(1);
    kmain->klamdb->slotExternal(name, "TrendMicro");
}

void ScanViewer::slotStartAgain()
{
    slotScan(m_filepattern, m_mode, m_recursive);
}

bool ScanViewer::scanGoingOn()
{
    return scanInProgress;
}

#include "scanviewer.moc"
