/***************************************************************************
begin                : 2004/02/07
copyright            : (C) Mark Kretschmann
email                : markey@web.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configdialog.h"
#include "debug.h"

#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qobjectlist.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtextcodec.h>
#include <qtooltip.h>
#include <qvbox.h>

#include <kapplication.h> //kapp
#include <kcombobox.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <klocale.h>
#include <kstandarddirs.h>

//////////////////////////////////////////////////////////////////////////////////////////
// PUBLIC
//////////////////////////////////////////////////////////////////////////////////////////

KlamavConfigDialog::KlamavConfigDialog( QWidget *parent, const char* name, KConfigSkeleton *config )
        : KConfigDialog( parent, name, config )
{
    setWFlags( WDestructiveClose );

    // IMPORTANT Don't simply change the page names, they are used as identifiers in other parts of the app.
            m_opt1 = new Options1( 0, "General" );
            m_opt2 = new Options2( 0, "Appearance" );
            m_opt4 = new Options4( 0, "Playback" );
    Options5 *opt5 = new Options5( 0, "OSD" );
    QVBox    *opt6 = new QVBox;
            m_opt7 = new Options7( 0, "Collection" );
    Options8 *opt8 = new Options8( 0, "Scrobbler" );


    // add pages
    addPage( m_opt1, i18n( "General" ), "misc", i18n( "Configure General Options" ) );
    addPage( m_opt2,   i18n( "Appearance" ), "colors", i18n( "Configure amaroK's Appearance" ) );
    addPage( m_opt4, i18n( "Playback" ), "kmix", i18n( "Configure Playback" ) );
    addPage( opt5,   i18n( "OSD" ), "tv", i18n( "Configure On-Screen-Display" ) );
    addPage( opt6,   i18n( "Engine" ), "amarok", i18n( "Configure Engine" ) );
    addPage( m_opt7, i18n( "Collection" ), "collection", i18n( "Configure Collection" ) );
    addPage( opt8,   i18n( "last.fm" ), "audioscrobbler", i18n( "Configure last.fm Support" ) );


    connect( m_soundSystem, SIGNAL(activated( int )), SLOT(updateButtons()) );
    connect( aboutEngineButton, SIGNAL(clicked()), SLOT(aboutEngine()) );
    connect( opt5, SIGNAL(settingsChanged()), SLOT(updateButtons()) ); //see options5.ui.h
    connect( m_opt2->styleComboBox, SIGNAL( activated( int ) ), SLOT( updateButtons() ) );
}

KlamavConfigDialog::~KlamavConfigDialog()
{
}


/** Reimplemented from KConfigDialog */
void KlamavConfigDialog::addPage( QWidget *page, const QString &itemName, const QString &pixmapName, const QString &header, bool manage )
{
    // Add the widget pointer to our list, for later reference
    m_pageList << page;

    KConfigDialog::addPage( page, itemName, pixmapName, header, manage );
}


/** Show page by object name */
void KlamavConfigDialog::showPage( const QCString& page )
{
    for( uint index = 0; index < m_pageList.count(); index++ ) {
        if ( m_pageList[index]->name() == page ) {
            KConfigDialog::showPage( index );
            return;
        }
    }
}


//////////////////////////////////////////////////////////////////////////////////////////
// PROTECTED SLOTS
//////////////////////////////////////////////////////////////////////////////////////////

/**
 * Update the settings from the dialog.
 * Example use: User clicks Ok or Apply button in a configure dialog.
 * REIMPLEMENTED
 */
void KlamavConfigDialog::updateSettings()
{
    OSDPreviewWidget *osd = (OSDPreviewWidget*)child( "osdpreview" );
    KlamavConfig::setOsdAlignment( osd->alignment() );
    KlamavConfig::setOsdYOffset( osd->y() );
    amaroK::OSD::instance()->applySettings();

    static_cast<CollectionSetup*>(child("CollectionSetup"))->writeConfig();

    if ( m_engineConfig ) m_engineConfig->save();

    // When sound system has changed, update engine config page
    if ( m_soundSystem->currentText() != m_pluginKlamavName[KlamavConfig::soundSystem()] ) {
        KlamavConfig::setSoundSystem( m_pluginName[m_soundSystem->currentText()] );
        emit settingsChanged();
        soundSystemChanged();
    }

    if ( m_opt2->styleComboBox->currentText() != KlamavConfig::contextBrowserStyleSheet() ) {
        //can't use kconfigxt for the style comboxbox's since we need the string, not the index
        KlamavConfig::setContextBrowserStyleSheet( m_opt2->styleComboBox->currentText() );
        ContextBrowser::instance()->setStyleSheet();
    }

    // can't use kconfigxt for the database comboxbox since we need the DBConnection id and not the index
    QString dbType = QString::number(DbConnection::sqlite);
    if (m_opt7->dbSetupFrame->databaseEngine->currentText() == "MySQL")
    {
        dbType = QString::number(DbConnection::mysql);
    }
    else if (m_opt7->dbSetupFrame->databaseEngine->currentText() == "Postgresql")
    {
        dbType = QString::number(DbConnection::postgresql);
    }
    if ( dbType != KlamavConfig::databaseEngine() ) {
        KlamavConfig::setDatabaseEngine( dbType );
    }
}




#include "configdialog.moc"
