/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KITTY_PUBLISH_H
#define KITTY_PUBLISH_H

#include <qobject.h>
#include <kurl.h>
#include <ktempfile.h>
#include <qstringlist.h>
#include "kitty_feedmodel.h"

/**
@author KesieV
*/
class kitty_publish : public QObject
{
Q_OBJECT
public:
    kitty_publish(QWidget *parent = 0, const char *name = 0);

    ~kitty_publish();

public:
	void setFeed(t_feed feeddata);
	void setOutput(KURL upload,KURL site,QString log,QString pas);
	void publish();

	void setUploadVideos(bool a) {uploadVideos=a;}
	void setUploadThumbnails(bool a) {uploadThumbs=a;}

private slots:
	void slotresult (KIO::Job *);
	void slotpercent (KIO::Job *, unsigned long );
	void publishCancel();

private:
	QWidget *myparent;
	QString buildXML();
	void nextUpload();
	QString articleContentUrl(int id,bool &islocal);
	QString uploaded_filename(KURL localfilename);
	t_feed feed;
	KURL destination;
	KURL dest_upload;
	QStringList uploadQueue;
	KTempFile *tmpfile;
	bool uploadVideos;
	bool uploadThumbs;
	KIO::FileCopyJob *copyJob;
	KProgressDialog *updlg;
	int current;
	int all;
};

#endif
