#include "glib.h"

#include "kipina-i18n.h"
#include "kpunit.h"
#include "kputil.h"

G_CONST_RETURN gchar *
kp_unit_get_string (KPUnit unit, gdouble raw_value)
{
  static GString *string = NULL;
  gchar *tmp;
  
  if (string == NULL)
    string = g_string_new (NULL);
  
  switch (unit) {
    /* TODO: Move implementation to this file! */
    case KP_UNIT_TIME:
      tmp = kp_date_mseconds_to_std_string ((guint) raw_value);
      g_string_assign (string, tmp);
      g_free (tmp);
      break;
      
    case KP_UNIT_KM:
    case KP_UNIT_RAW:
      g_string_printf (string, "%.3f", raw_value);
      break;
      
    case KP_UNIT_MILE:
      g_string_assign (string, _("There is no mile support in Kipin currently!"));
      break;
  }

  return string->str;
}


