#ifndef KP_SPLIT_H_
#define KP_SPLIT_H_

#include <libxml/tree.h>
#include <glib.h>

#define KP_SPLIT_TYPE_NORMAL        "Normal"
#define KP_SPLIT_TYPE_WARM_UP       "Warm Up"
#define KP_SPLIT_TYPE_COOL_DOWN     "Cool Down"
#define KP_SPLIT_TYPE_RECOVERY      "Recovery"

typedef struct KPSplit_ {
  gchar       *type;  
  guint        n;

  gdouble      distance;
  guint32      duration;

  gchar       *sport;
  gchar       *comment;
} KPSplit;

#define KP_SPLIT(pointer) ((KPSplit *)(pointer))


KPSplit         *kp_split_new             (void);
KPSplit         *kp_split_new_full        (const gchar *type,
                                           guint n, 
                                           gdouble distance, 
                                           guint duration,
                                           const gchar *sport,
                                           const gchar *comment);

gdouble          kp_split_get_speed       (KPSplit *split);
guint            kp_split_get_pace        (KPSplit *split);

xmlNodePtr       kp_split_to_xml          (KPSplit *split);

void             kp_split_free            (KPSplit *split);
#endif /* KP_SPLIT_H_ */
