#include <string.h>

#include <gtk/gtk.h>

#include "kparray2d.h"

#define PTR_SIZE sizeof(char *)

guint **
kp_array_2d_alloc (guint rows, guint cols, guint size)
{
  guint i;
  guint **arr = g_malloc (rows * PTR_SIZE);

  for (i = 0; i < rows; i++)
    arr[i] = g_malloc (cols * size);

  return arr;
}

guint **
kp_array_2d_alloc_init0 (guint rows, guint cols, guint size)
{
  guint i;
  guint **arr = g_malloc0 (rows * PTR_SIZE);

  for (i = 0; i < rows; i++) {
    arr[i] = g_malloc0 (cols * size);
  }
  return arr;
}

void
kp_array_2d_free (guint **arr, guint rows, guint cols)
{
  guint i;

  for (i = 0; i < rows; i++)
    g_free (arr[i]);

  g_free (arr);
}


gchar ***
kp_array_2dc_alloc (guint rows, guint cols, guint size)
{
  guint i;
  gchar ***arr = g_malloc (rows * PTR_SIZE);

  for (i = 0; i < rows; i++)
    arr[i] = g_malloc (cols * size);

  return arr;
}
gchar ***
kp_array_2dc_alloc_init0 (guint rows, guint cols, guint size)
{
  guint i;
  gchar ***arr = g_malloc0 (rows * PTR_SIZE);

  for (i = 0; i < rows; i++) {
    arr[i] = g_malloc0 (cols * size);
  }
  return arr;
}
void
kp_array_2dc_free (gchar ***arr, guint rows, guint cols)
{
  guint i;

  for (i = 0; i < rows; i++)
    g_free (arr[i]);

  g_free (arr);
}

  
gdouble **
kp_array_2dd_alloc (guint rows, guint cols, guint size)
{
  guint i;
  gdouble **arr = g_malloc (rows * PTR_SIZE);

  for (i = 0; i < rows; i++)
    arr[i] = g_malloc (cols * size);

  return arr;
}
gdouble **
kp_array_2dd_alloc_init0 (guint rows, guint cols, guint size)
{
  guint i;
  gdouble **arr = g_malloc (rows * PTR_SIZE);

  for (i = 0; i < rows; i++)
    arr[i] = g_malloc (cols * size);

  return arr;
}
void
kp_array_2dd_free (gdouble **arr, guint rows, guint cols)
{
  guint i;

  for (i = 0; i < rows; i++)
    g_free (arr[i]);

  g_free (arr);
}


gfloat **
kp_array_2df_alloc (guint rows, guint cols)
{
  guint i;
  gfloat **arr = g_malloc (rows * PTR_SIZE);

  for (i = 0; i < rows; i++)
    arr[i] = (gfloat *) g_malloc (cols * sizeof (gfloat));

  return arr;
}
gfloat **
kp_array_2df_alloc_init0 (guint rows, guint cols)
{
  guint i;
  gfloat **arr = g_malloc0 (rows * PTR_SIZE);

  for (i = 0; i < rows; i++)
    arr[i] = g_malloc0 (cols * sizeof (gfloat));
  
  return arr;
}
void
kp_array_2df_free (gfloat **arr, guint rows, guint cols)
{
  guint i;

  for (i = 0; i < rows; i++)
    g_free (arr[i]);

  g_free (arr);
}
