#include "page-month.h"
#include "kphtmlutil.h"
#include "kphtmlwriter.h"

#include "../kpworkoutmodel.h"
#include "../kipina-i18n.h"
#include "../kpcomment.h"


static KPHtmlNaviData navi_data = 
{
  1, 1, 0,
  { NULL, NULL, NULL, NULL, NULL },
  { NULL, NULL, NULL, NULL, NULL }
};

static void
write_entries_table (KPHtmlWriter *writer, FILE *fp, guint year, guint month)
{
  KPCalendarEntry *entry;
  KPDate date;
  gchar buf[128];
  gchar *str;
  gchar *comment;
  guint ival;
  gdouble dval;
  GList *node;
  guint id;
  TYear *ty;

  ty = kp_training_log_get_year (writer->log, year);
  if (ty == NULL)
    return;
 
  kp_html_h1 (fp, "%s %u", kp_get_month_name (month-1), year);
  
  kp_html_table_head (fp, _("Link"),
                          _("Date"),
                          _("Sport type"),
                          _("Distance"),
                          _("Duration"),
                          _("Pace"),
                          _("Speed"),
                          _("Description"), 
                             NULL);

  for (node = ty->workouts[month - 1]; node; node = node->next) {
   
    entry = node->data;

    kp_html_table_row_start (fp);

    /* Entry  (Same for all entry types) */
    id = kp_calendar_entry_get_id (entry);
    kp_html_table_cell (fp, "<a href=\"entry-%u.html\">%s</a>\n", id, _("Show"));

    /* Date  (Same for all entry types) */
    kp_calendar_entry_get_date (entry, &date);
    kp_date_to_locale_string (&date, buf, sizeof (buf)-1);
    kp_html_table_cell (fp, buf);
      

    if (KP_IS_WORKOUT (entry)) {
      /* Sport */ 
      kp_html_table_cell (fp, kp_workout_get_sport (KP_WORKOUT (entry)));

      /* Distance */
      if ((dval = kp_workout_model_get_distance (KP_WORKOUT_MODEL (entry))))
        kp_html_table_cell (fp, "%.3f", dval);
      else
        kp_html_table_cell (fp, "-");

      /* Duration */
      if ((ival = kp_workout_model_get_duration (KP_WORKOUT_MODEL (entry)))) {
        str = kp_date_mseconds_to_std_string (ival);
        kp_html_table_cell (fp, str);
        g_free (str);
      }
      else
        kp_html_table_cell (fp, "-");

      /* Pace */
      ival = kp_workout_model_get_pace (KP_WORKOUT_MODEL (entry));
      if (ival) {
        str = kp_date_mseconds_to_std_string (ival);
        kp_html_table_cell (fp, str);
        g_free (str);
      }
      else
        kp_html_table_cell (fp, "-");
      
      /* Speed */
      dval = kp_workout_model_get_speed (KP_WORKOUT_MODEL (entry));
      if (dval) 
        kp_html_table_cell (fp, "%.1f km/h", dval); 
      else
        kp_html_table_cell (fp, "-");

      /* Comment */
      comment = kp_workout_get_comment (KP_WORKOUT (entry));
      kp_html_table_cell (fp, "<span class=\"pre_comment\">%s</span>", (comment) ? comment : "");

      kp_html_table_row_end (fp);
    }
    else if (KP_IS_COMMENT (entry)) {
      kp_html_table_cell (fp, "Comment");
      
      str = kp_comment_get_title (KP_COMMENT (entry));
      kp_html_table_cell_cspan (fp, 2, "<strong>%s</strong>", str);
      g_free (str);
      
      str = kp_comment_get_text (KP_COMMENT (entry));
      kp_html_table_cell_cspan (fp, 2, "%s", str);
      g_free (str);
      kp_html_table_row_end (fp);
    }
    else
    {
      kp_html_table_cell (fp, "Results");
      kp_html_table_cell (fp, "&nbsp;-");
      kp_html_table_cell (fp, "&nbsp;-");
      kp_html_table_cell (fp, "&nbsp;-");
      kp_html_table_cell (fp, "&nbsp;-");
      kp_html_table_row_end (fp);
    }
  }
  kp_html_table_foot (fp);
}



/* Month is between 1 and 12 */
void
page_month (KPHtmlWriter *writer, KPTrainingLog *log, 
            guint year, guint month, GError **err)
{
  GError *tmp_error;
  FILE *fp;
  gchar buf[32];
  
  /* Month page table */
  g_snprintf (buf, sizeof (buf)-1, "month-%u-%u.html", year, month);
  fp = kp_html_writer_open (writer, buf, &tmp_error);

  if (fp == NULL) {
    g_propagate_error (err, tmp_error);
    return;
  }

  kp_html_navi (fp, &navi_data, year, month, 0); 
 
  write_entries_table (writer, fp, year, month);
  kp_html_writer_close (fp);
}


