#ifndef KP_VIEW_H_
#define KP_VIEW_H_

#include <gtk/gtk.h>
#include <glib-object.h>

#include "kpviewmodel.h"

#define KP_TYPE_VIEW (kp_view_get_type())
#define KP_VIEW(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_VIEW, KPView))
#define KP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_VIEW, KPViewClass))
#define KP_IS_VIEW(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_VIEW))
#define KP_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_VIEW))
#define KP_VIEW_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_VIEW, KPViewClass))

typedef struct KPView_
{
  GtkVBox           parent;
  gpointer          private_data;
} KPView;

typedef struct KPViewClass_ {
  GtkVBoxClass      parent_class;

  void           (* viewer_set) (KPView *view, KPViewModel *model);
} KPViewClass;

GType             kp_view_get_type (void);

/* Init */
KPView           *kp_view_new                       (guint d, guint m, guint y);
void              kp_view_add_viewer                (KPView *view,
                                                     const gchar *name,
                                                     KPViewModel *model);
/* Use */

void              kp_view_set_viewer_next           (KPView *view);
void              kp_view_set_viewer_prev           (KPView *view);
void              kp_view_set_viewer_by_object_name (KPView *view,
                                                     const gchar *name);
GList            *kp_view_get_viewers               (KPView *view);
KPViewModel      *kp_view_get_current_viewer        (KPView *view);

#endif
