#ifndef KP_SPORT_ENTRY_H_
#define KP_SPORT_ENTRY_H_

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "../kptraininglog.h"

#include "kpviewmodel.h"

#define KP_TYPE_SPORT_ENTRY (kp_sport_entry_get_type())
#define KP_SPORT_ENTRY(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_SPORT_ENTRY, KPSportEntry))
#define KP_SPORT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_SPORT_ENTRY, KPSportEntryClass))
#define KP_IS_SPORT_ENTRY(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_SPORT_ENTRY))
#define KP_IS_SPORT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_SPORT_ENTRY))
#define KP_SPORT_ENTRY_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_SPORT_ENTRY, KPSportEntryClass))

typedef struct KPSportEntry_
{
  GtkVBox         parent;

  gpointer        private_data;
} KPSportEntry;

typedef struct KPSportEntryClass_
{
  GtkVBoxClass    parent;

  void             (* sport_selected)(KPSportEntry *entry, const gchar *sport);
} KPSportEntryClass;

GType                 kp_sport_entry_get_type           (void);

GtkWidget            *kp_sport_entry_new                (void);
G_CONST_RETURN gchar *kp_sport_entry_get_sport          (KPSportEntry *entry);

#endif
