#include <string.h>
#include <glib-object.h>
#include <glib.h>

#include "kpintensityentry.h"

#include "../kppresetdataitem.h"
#include "../kppresetdata.h"
#include "../kipina-i18n.h"


#define SPORT_MENU_CHOOSE   "Choose a Sport"
#define SPORT_MENU_OTHER    "Other"

static void    kp_intensity_entry_class_init     (KPIntensityEntryClass *klass);
static void    kp_intensity_entry_init           (KPIntensityEntry *bar);
static void    kp_intensity_entry_finalize       (GObject *object);

typedef struct KPIntensityEntryPrivateData_
{
  GtkWidget   *intensity_entry;
  gchar       *intensity;
} KPIntensityEntryPrivateData;

#define KP_INTENSITY_ENTRY_PRIVATE_DATA(widget)  \
  (((KPIntensityEntryPrivateData*) \
  (KP_INTENSITY_ENTRY (widget)->private_data)))



GType
kp_intensity_entry_get_type (void)
{
  static GType kp_intensity_entry_type = 0;

  if (!kp_intensity_entry_type) {
    static const GTypeInfo kp_intensity_entry_info = {
      sizeof (KPIntensityEntryClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_intensity_entry_class_init,
      NULL,
      NULL,
      sizeof (KPIntensityEntry),
      0,
      (GInstanceInitFunc) kp_intensity_entry_init,
      NULL
    };
    kp_intensity_entry_type = g_type_register_static (GTK_TYPE_COMBO_BOX_ENTRY,
                                                     "KPIntensityEntry",
                                                     &kp_intensity_entry_info, 0);
  }
  return kp_intensity_entry_type;
}


static void
kp_intensity_entry_class_init (KPIntensityEntryClass *klass)
{
  GObjectClass *object_class;

  object_class = G_OBJECT_CLASS (klass);
  object_class->finalize = kp_intensity_entry_finalize;
}


static void
kp_intensity_entry_init (KPIntensityEntry *entry)
{
  KPIntensityEntryPrivateData *p_data;
  
  entry->private_data = g_new (KPIntensityEntryPrivateData, 1);
  p_data = KP_INTENSITY_ENTRY_PRIVATE_DATA (entry);
  p_data->intensity = NULL;
}

static void
kp_intensity_entry_finalize (GObject *object)
{
  KPIntensityEntryPrivateData *p_data;
  
  p_data = KP_INTENSITY_ENTRY_PRIVATE_DATA (object);

  g_free (KP_INTENSITY_ENTRY (object)->private_data);
}

/**
 * kp_intensity_entry_new:
 * @log: A #KPTrainingLog, can be NULL
 *
 * Create a new instance of #KPIntensityEntry.
 */
GtkWidget *
kp_intensity_entry_new (void)
{
  GtkListStore *store;
  GtkWidget *entry;
  GSList *list;
  
  store = gtk_list_store_new (1, G_TYPE_STRING);
  entry = g_object_new (kp_intensity_entry_get_type (),
                       "model", store,
                       "text_column", 0,
                        NULL);
  g_object_unref (store);
  
  list = kp_preset_data_get_items (KP_PRESET_DATA_EXERCISE_TYPE);
  for (; list; list = list->next) {
    gtk_combo_box_append_text (GTK_COMBO_BOX (entry), 
                               KP_PRESET_DATA_ITEM (list->data)->name);
  }

  return entry;
}


void
kp_intensity_entry_set_text (KPIntensityEntry *entry, const gchar *text)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *old_text;
  gchar *str;
  gboolean valid;
 
  g_return_if_fail (KP_IS_INTENSITY_ENTRY (entry));
  g_return_if_fail (text != NULL);
  
  model = gtk_combo_box_get_model (GTK_COMBO_BOX (entry));
  old_text = gtk_combo_box_get_active_text (GTK_COMBO_BOX (entry));

  /* The text is already selected */
  if (old_text != NULL && strcmp (old_text, text) == 0) {
    g_free (old_text);
    return;
  }
  
  valid = gtk_tree_model_get_iter_first (model, &iter);
  while (valid) {
    gtk_tree_model_get (model, &iter, 0, &str, -1);

    if (old_text != NULL && strcmp (str, old_text) == 0) {
      gtk_combo_box_set_active_iter (GTK_COMBO_BOX (entry), &iter);
      return;
    }
    g_free (str);

    valid = gtk_tree_model_iter_next (model, &iter);
  }

  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, text, -1);
  gtk_combo_box_set_active_iter (GTK_COMBO_BOX (entry), &iter);
}
