#ifndef KP_ENTRIES_H_
#define KP_ENTRIES_H_

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "kpviewpopupmodel.h"

typedef GtkWidget * (*KPEntryNewFunc) (KPDate *, KPCalendarEntry *);
typedef GtkWidget * (*KPEntryPropFunc) (KPCalendarEntry *);

typedef struct KPEntryData_ {
  GType             type;
  gchar            *name;
  gchar            *icon_name;
  KPEntryNewFunc    new_dialog;
  KPEntryPropFunc   prop_dialog;
} KPEntryData;

typedef struct KPEntryPopup_ {
  GtkWidget     *menu;
  GtkWidget     *title_label;
  GtkWidget     *actions_menu;
  GtkWidget     *add_menu;
  GtkWidget     *delete;
  GtkWidget     *edit;
  GtkWidget     *prop;
} KPEntryPopup;


#define KP_ENTRY_DATA(x) ((KPEntryData *)((x)))

void       kp_entries_init                    (void);
void       kp_entries_add_entry               (GType type,
                                               const gchar *human_name,
                                               const gchar *icon_name,
                                               KPEntryNewFunc func,
                                               KPEntryPropFunc prop_func);
KPEntryData *
           kp_entries_get_entry               (const gchar *human_name);
GSList    *kp_entries_get_list_as_menu_items  (GCallback cb, gpointer data);
KPEntryPopup *
           kp_entries_get_popup               (KPViewPopupModel *model);
void       kp_entries_set_popup_mode_entry    (KPEntryPopup *data,
                                               gboolean there_is_entry);
void       kp_entries_popup_prepare_dynamic   (KPEntryPopup *data,
                                               KPViewPopupModel *model);
void       kp_entries_show_prop_dialog        (KPCalendarEntry *entry);
void       kp_entries_show_edit_dialog        (KPCalendarEntry *entry);


/* Implementations, these shouldn't be called by anything except the types
 * init funcs */

void       kp_entries_show_prop_workout_dialog 
                                              (KPCalendarEntry *entry);
void       kp_entries_show_prop_split_workout_dialog 
                                              (KPCalendarEntry *entry);
void       kp_entries_show_prop_comment_dialog 
                                              (KPCalendarEntry *entry);
void       kp_entries_show_prop_results_dialog 
                                              (KPCalendarEntry *entry);


#endif /* KP_ENTRIES_H_ */
