#ifndef KP_DATE_ENTRY_H_
#define KP_DATE_ENTRY_H_

#include <gtk/gtk.h>
#include "../kputil.h"

#define KP_TYPE_DATE_ENTRY         (kp_date_entry_get_type ())
#define KP_DATE_ENTRY(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), KP_TYPE_DATE_ENTRY, KPDateEntry))
#define KP_DATE_ENTRY_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), KP_TYPE_DATE_ENTRY, KPDateEntryClass))
#define KP_IS_DATE_ENTRY(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), KP_TYPE_DATE_ENTRY))
#define KP_IS_DATE_ENTRY_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), KP_TYPE_DATE_ENTRY))
#define KP_DATE_ENTRY_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), KP_TYPE_DATE_ENTRY, KPDateEntryClass))

typedef struct
{
  GtkTable        parent;

  gpointer        private_data;
} KPDateEntry;

typedef struct
{
  GtkHBoxClass    parent_class;
  void         (* date_selected)(KPDateEntry *entry, KPDate *date);
  void         (* time_selected)(KPDateEntry *entry, KPTime *time);
} KPDateEntryClass;

GType             kp_date_entry_get_type    (void);

GtkWidget        *kp_date_entry_new         (void); 

gboolean          kp_date_entry_get_date    (KPDateEntry *entry, 
                                             KPDate *date);
gboolean          kp_date_entry_get_time    (KPDateEntry *entry,
                                             KPTime *time);
void              kp_date_entry_set_date    (KPDateEntry *entry,
                                             KPDate *date);
void              kp_date_entry_set_time    (KPDateEntry *entry,
                                             KPTime *time);

#endif /* __KP_DATE_ENTRY_H */
