#include <glib-object.h>
#include <glib.h>

#include "kpaddeditdialog.h"
#include "../kipina-i18n.h"


static void         kp_add_edit_dialog_class_init         (KPAddEditDialogClass *klass);
static void         kp_add_edit_dialog_init               (KPAddEditDialog *bar);
static void         kp_add_edit_dialog_finalize           (GObject *object);
static void         kp_add_edit_dialog_set_property       (GObject *object, 
                                                           guint property_id, 
                                                           const GValue *value, 
                                                           GParamSpec *pspec);
static void         kp_add_edit_dialog_get_property       (GObject *object, 
                                                           guint property_id, 
                                                           GValue *value, 
                                                           GParamSpec *pspec);
enum {
  KP_ADD_EDIT_DIALOG_MODE = 1
};


static GObjectClass *parent_class = NULL;

typedef struct KPAddEditDialogPrivateData_
{
  KPAddEditDialogMode   mode;

  GtkWidget            *button_add;
  GtkWidget            *button_close;
} KPAddEditDialogPrivateData;

#define KP_ADD_EDIT_DIALOG_PRIVATE_DATA(widget) (((KPAddEditDialogPrivateData*) \
      (KP_ADD_EDIT_DIALOG (widget)->private_data)))



GType
kp_add_edit_dialog_get_type (void)
{
  static GType        kp_add_edit_dialog_type = 0;

  if (!kp_add_edit_dialog_type) {
    static const GTypeInfo kp_add_edit_dialog_info = {
      sizeof (KPAddEditDialogClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_add_edit_dialog_class_init,
      NULL,
      NULL,
      sizeof (KPAddEditDialog),
      0,
      (GInstanceInitFunc) kp_add_edit_dialog_init,
      NULL
    };
    kp_add_edit_dialog_type = g_type_register_static (GTK_TYPE_DIALOG,
                                                     "KPAddEditDialog",
                                                     &kp_add_edit_dialog_info, 0);
  }
  return kp_add_edit_dialog_type;
}


static void
kp_add_edit_dialog_class_init (KPAddEditDialogClass *klass)
{
  GObjectClass *object_class;
  GParamSpec *pspec;

  object_class = G_OBJECT_CLASS (klass);
  object_class->set_property = kp_add_edit_dialog_set_property;
  object_class->get_property = kp_add_edit_dialog_get_property;
  object_class->finalize = kp_add_edit_dialog_finalize;

  parent_class = g_type_class_peek_parent (klass);
  
  pspec = g_param_spec_int ("mode",
                            "Dialog mode",
                            "Set the mode of the dialog",
                             KP_ADD_EDIT_MODE_ADD,
                             KP_ADD_EDIT_MODE_EDIT,
                             KP_ADD_EDIT_MODE_ADD,
                             G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE);
  
  g_object_class_install_property (object_class, KP_ADD_EDIT_DIALOG_MODE, pspec);
}


static void
kp_add_edit_dialog_set_property (GObject *object, guint property_id, 
                                 const GValue *value, GParamSpec *pspec)
{
  KPAddEditDialogPrivateData *p_data;
  KPAddEditDialog *dialog = KP_ADD_EDIT_DIALOG (object);
  
  p_data = KP_ADD_EDIT_DIALOG_PRIVATE_DATA (dialog);
  
  switch (property_id)
  {
    case KP_ADD_EDIT_DIALOG_MODE:
      p_data->mode = g_value_get_int (value);
     
      if (p_data->mode == KP_ADD_EDIT_MODE_EDIT) {
        gtk_widget_hide (p_data->button_add);
        gtk_widget_show (p_data->button_close);
      } else {
        gtk_widget_show (p_data->button_add);
        gtk_widget_hide (p_data->button_close);
      }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
      break;
  }
}


static void
kp_add_edit_dialog_get_property (GObject *object, guint property_id, 
                                 GValue *value, GParamSpec *pspec)
{
  KPAddEditDialogPrivateData *p_data;
  p_data = KP_ADD_EDIT_DIALOG_PRIVATE_DATA (object);
  
  switch (property_id)
  {
    case KP_ADD_EDIT_DIALOG_MODE:
      g_value_set_int (value, p_data->mode);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
      break;
  }
}


static void
kp_add_edit_dialog_init (KPAddEditDialog *dialog)
{
  KPAddEditDialogPrivateData *p_data;

  dialog->private_data = g_new0 (KPAddEditDialogPrivateData, 1);
  p_data = KP_ADD_EDIT_DIALOG_PRIVATE_DATA (dialog);

  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_NONE);
  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2);

  p_data->button_add = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                              GTK_STOCK_ADD, 
                                              GTK_RESPONSE_OK);
  p_data->button_close = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                                GTK_STOCK_CLOSE, 
                                                GTK_RESPONSE_CLOSE);
}


static void
kp_add_edit_dialog_finalize (GObject *object)
{
  KPAddEditDialogPrivateData *p_data;
  p_data = KP_ADD_EDIT_DIALOG_PRIVATE_DATA (object);

  g_free (KP_ADD_EDIT_DIALOG (object)->private_data);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}
 

KPAddEditDialogMode
kp_add_edit_dialog_get_mode (KPAddEditDialog *dialog)
{
  KPAddEditDialogPrivateData *p_data;
  GValue value = { 0, };
  
  p_data = KP_ADD_EDIT_DIALOG_PRIVATE_DATA (dialog);

  g_value_init (&value, G_TYPE_INT);
  g_object_get_property (G_OBJECT (dialog), "mode", &value);
  
  return g_value_get_int (&value);
}


