/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qpushbutton.h>
#include <qwizard.h>

#include "ksetupwizard.h"

#include "ksettingsgeneralwidget.h"



KSetupWizard::KSetupWizard(QWidget *parent, const char *name)
 : KSetupWzrd(parent, name)
{
  // disable the help button
  helpButton()->hide();
  // enable the finish button at the last page
  setFinishEnabled(generalPage,true);
  
  connect(settingsGeneralWidget, SIGNAL(signalGuessKDEBaseClicked(QString &)),
          this,   SLOT(slotGuessKDEBaseClicked(QString &)));
  connect(settingsGeneralWidget, SIGNAL(signalSelectStorageDirClicked(QString &)),
          this,   SLOT(slotSelectStorageDirClicked(QString &)));
}


KSetupWizard::~KSetupWizard()
{
}


/*!
 */
bool KSetupWizard::execute(TInstallerSettings * settings)
{
  m_settings = settings;

  settingsGeneralWidget->setSettings(m_settings);

  // take care that the welcome page is visible at startup
  showPage(page(0));
  if (exec())
  {
    settingsGeneralWidget->getSettings(m_settings);
    
    return(true);
  }
  else
  {
    return(false);
  }
}


/*!
 */
void KSetupWizard::slotGuessKDEBaseClicked(QString & dir)
{
  emit signalGuessKDEBaseClicked(dir);
}


/*!
 */
void KSetupWizard::slotSelectStorageDirClicked(QString & dir)
{
  emit signalSelectStorageDirClicked(dir);
}


#include "ksetupwizard.moc"
