/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qtable.h>

#include "kpkgselectdialog.h"

#include "kinstallerdefs.h"


KPkgSelectDialog::KPkgSelectDialog(QWidget *parent, const char *name)
 : KPkgSelectDlg(parent, name)
{
}


KPkgSelectDialog::~KPkgSelectDialog()
{
}


/*!
 */
bool KPkgSelectDialog::execute(TPackageInfoList * pkgInfos)
{
  TPackageInfo * info;
  uint num;


  pkgTable->setNumRows(pkgInfos->count());
  
  info = pkgInfos->firstInfo();
  num = 0;
  while (info != 0)
  {
    pkgTable->setText(num,0,info->pkgName);
    pkgTable->setText(num,1,info->pkgVersion);
    pkgTable->setText(num,2,info->installType);
    ++num;
    info = pkgInfos->nextInfo();
  }

  // @todo enable sorting
//  pkgTable->sortColumn(0,true,true);
  m_selectedPackage = 0;
  
  if (exec() == Accepted)
  {
    for (num = 0; num < (uint)pkgTable->numRows(); ++num)
    {
      if (pkgTable->isRowSelected(num))
        m_selectedPackage = pkgInfos->infoAt(num);
    }

    if (m_selectedPackage != 0)
      return(true);
    else
      return(false);
  }
  else
  {
    return(false);
  }
}


/*!
 */
TPackageInfo * KPkgSelectDialog::selectedPackage()
{
  return(m_selectedPackage);
}

#include "kpkgselectdialog.moc"
