#!/bin/sh

function usage
{
	# Title
	echo "Title: FFMPEG VCD Export"

	# Usable?
	which ffmpeg > /dev/null
	[ $? = 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass file-producer
}

function execute
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"

	# Determine info arguments
	size=`[ "$normalisation" = "pal" ] && echo 352x288 || echo 352x240`
	video_bitrate=1152
	audio_bitrate=224

	# Run the command
	ffmpeg -f dv -i - -f vcd -deinterlace -r $normalisation -s $size -b $video_bitrate -acodec mp2 -ab $audio_bitrate -y "$file".mpeg
}

[ "$1" = "--usage" -o "$1" = "" ] && usage $@ || execute $@
