#!/bin/sh

function usage
{
	# Title
	echo "Title: FFMPEG DivX Export"

	# Usable?
	which ffmpeg > /dev/null
	[ $? = 0 ] && mp3=`ffmpeg -formats | grep Encoders: | grep mp3 | wc -l`
	[ $mp3 = 1 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass file-producer

	# Profiles
	echo Profile: High Quality
	echo Profile: Medium Quality
	echo Profile: Low Quality
}

function execute
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"

	# Run the command
	case "$profile" in 
		"0" ) 	ffmpeg -f dv -i - -f avi -deinterlace -s 640x480 -hq -b 4096 -acodec mp3 -ab 192 -y "$file".avi ;;
		"1" ) 	ffmpeg -f dv -i - -f avi -deinterlace -s 320x240 -b 2048 -acodec mp3 -ab 128 -y "$file".avi ;;
		"2" ) 	ffmpeg -f dv -i - -f avi -deinterlace -s 160x120 -b 1024 -acodec mp3 -ab 64 -y "$file".avi ;;
	esac
}

[ "$1" = "--usage" -o "$1" = "" ] && usage $@ || execute $@
