/**
 * \file id3form.cpp
 * GUI for kid3, originally generated by QT Designer.
 *
 * \b Project: Kid3
 * \author Urs Fleisch
 * \date 8 Apr 2003
 */

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qdragobject.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qvbox.h>
#include <qsplitter.h>
#include <qdir.h>

#include "config.h"
#ifdef CONFIG_USE_KDE
#include <klocale.h>
#else
#define i18n(s) tr(s)
#endif

/** Shortcut for pointer to parent (application) widget. */
#define theApp ((Kid3App *)parentWidget())

#include "filelist.h"
#include "genres.h"
#include "kid3.h"
#include "miscconfig.h"
#include "formatconfig.h"
#include "id3form.h"
#include "dirlist.h"

/**
 * A QScrollView which returns the sizeHint of its child.
 * This is necessary to get a reasonable default size of the window.
 */
class Kid3ScrollView: public QScrollView {
public:
	/**
	 * Constructor.
	 * @param parent parent widget
	 * @param name   name
	 * @param f      window flags
	 */
	Kid3ScrollView(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	/**
	 * Constructor.
	 * @param parent  parent widget
	 * @param _client client widget
	 */
	Kid3ScrollView(QWidget *parent, QWidget *_client);
	/**
	 * Get size hint.
	 * @return size hint.
	 */
	virtual QSize sizeHint() const;
	/**
	 * Add child widget.
	 * @param child child widget
	 * @param x     x-coordinate
	 * @param y     y-coordinate
	 */
	virtual void addChild(QWidget *child, int x = 0, int y = 0);
private:
	QWidget *client;
};

/**
 * Constructor.
 *
 * @param parent parent widget
 * @see QScrollView
 */
Kid3ScrollView::Kid3ScrollView(QWidget *parent, const char *name, WFlags f)
	: QScrollView(parent, name, f), client(0) {}

/**
 * Returns the recommended size for the widget by using the sizeHint of
 * the child.
 *
 * @return recommended size.
 */
QSize Kid3ScrollView::sizeHint() const
{
	return client ? client->sizeHint() : QScrollView::sizeHint();
}

/**
 * Add a single widget to the ScrollView.
 * The widget's parent should be the ScrollView's viewport.
 *
 * @param child child widget
 */
void Kid3ScrollView::addChild(QWidget *child, int x, int y)
{
	client = child;
	QScrollView::addChild(child, x, y);
}

/** 
 * Constructs an id3Form as a child of 'parent', with the 
 * name 'name' and widget flags set to 'f'.
 * @param parent parent widget
 * @param name   Qt name
 */
id3Form::id3Form(QWidget* parent, const char* name)
	: QSplitter(parent, name)
{
	setAcceptDrops(TRUE);
	setCaption(i18n("Kid3"));

	m_vSplitter = new QSplitter(Vertical, this, "vSplitter");
	mp3ListBox = new FileList(m_vSplitter, "mp3ListBox");
	mp3ListBox->setSelectionMode(QListBox::Extended);
	m_dirListBox = new DirList(m_vSplitter, "dirListBox");

	scrollView = new Kid3ScrollView(this);
	scrollView->setResizePolicy(QScrollView::AutoOneFit);
	scrollView->setFrameStyle(QFrame::NoFrame);
	rightHalfVBox = new QVBox(scrollView->viewport());
	rightHalfVBox->setSpacing(2);
	rightHalfVBox->setMargin(2);


	filenameGroupBox = new QGroupBox(rightHalfVBox, "filenameGroupBox");
	filenameGroupBox->setTitle(i18n("File&name"));
	filenameGroupBoxLayout = new QGridLayout(filenameGroupBox, 3, 3, 16, 6);

	nameLabel = new QLabel(filenameGroupBox, "nameLabel");
	nameLabel->setText(i18n("Name:"));
	filenameGroupBoxLayout->addWidget(nameLabel, 0, 0);

	nameLineEdit = new QLineEdit(filenameGroupBox, "nameLineEdit");
	filenameGroupBoxLayout->addWidget(nameLineEdit, 0, 1);

	fnV1Button = new QPushButton(filenameGroupBox, "fnV1Button");
	fnV1Button->setText(i18n("From ID3v1"));
	filenameGroupBoxLayout->addWidget(fnV1Button, 0, 2);

	formatLabel = new QLabel(filenameGroupBox, "formatLabel");
	formatLabel->setText(i18n("Format:"));
	filenameGroupBoxLayout->addWidget(formatLabel, 1, 0);

	formatComboBox = new QComboBox(FALSE, filenameGroupBox, "formatComboBox");
	filenameGroupBoxLayout->addWidget(formatComboBox, 1, 1);

	fnV2Button = new QPushButton(filenameGroupBox, "fnV2Button");
	fnV2Button->setText(i18n("From ID3v2"));
	filenameGroupBoxLayout->addWidget(fnV2Button, 1, 2);

	infoLabel = new QLabel(filenameGroupBox, "infoLabel");
	infoLabel->setText(i18n("Info:"));
	filenameGroupBoxLayout->addWidget(infoLabel, 2, 0);

	detailsLabel = new QLabel(filenameGroupBox, "detailsLabel");
	filenameGroupBoxLayout->addMultiCellWidget(detailsLabel, 2, 2, 1, 2);

	idV1GroupBox = new QGroupBox(rightHalfVBox, "idV1GroupBox");
	idV1GroupBox->setTitle(i18n("ID3v&1.1"));
	idV1GroupBoxLayout = new QGridLayout(idV1GroupBox, 6, 3, 16, 6);

	titleV1CheckBox = new QCheckBox(idV1GroupBox, "titleV1CheckBox");
	titleV1CheckBox->setText(i18n("Title:"));
	idV1GroupBoxLayout->addWidget(titleV1CheckBox, 0, 0);

	titleV1LineEdit = new QLineEdit(idV1GroupBox, "titleV1LineEdit");
	titleV1LineEdit->setMaxLength(30);
	idV1GroupBoxLayout->addWidget(titleV1LineEdit, 0, 1);

	filenameV1PushButton = new QPushButton(idV1GroupBox,
										   "filenameV1PushButton");
	filenameV1PushButton->setText(i18n("From Filename"));
	idV1GroupBoxLayout->addWidget(filenameV1PushButton, 0, 2);

	artistV1CheckBox = new QCheckBox(idV1GroupBox, "artistV1CheckBox");
	artistV1CheckBox->setText(i18n("Artist:"));
	idV1GroupBoxLayout->addWidget(artistV1CheckBox, 1, 0);

	artistV1LineEdit = new QLineEdit(idV1GroupBox, "artistV1LineEdit");
	artistV1LineEdit->setMaxLength(30);
	idV1GroupBoxLayout->addWidget(artistV1LineEdit, 1, 1);

	id3V1PushButton = new QPushButton(idV1GroupBox, "id3V1PushButton");
	id3V1PushButton->setText(i18n("From ID3v2"));
	idV1GroupBoxLayout->addWidget(id3V1PushButton, 1, 2);

	albumV1CheckBox = new QCheckBox(idV1GroupBox, "albumV1CheckBox");
	albumV1CheckBox->setText(i18n("Album:"));
	idV1GroupBoxLayout->addWidget(albumV1CheckBox, 2, 0);

	albumV1LineEdit = new QLineEdit(idV1GroupBox, "albumV1LineEdit");
	albumV1LineEdit->setMaxLength(30);
	idV1GroupBoxLayout->addWidget(albumV1LineEdit, 2, 1);

	copyV1PushButton = new QPushButton(idV1GroupBox, "copyV1PushButton");
	copyV1PushButton->setText(i18n("Copy"));
	idV1GroupBoxLayout->addWidget(copyV1PushButton, 2, 2);

	removeV1PushButton = new QPushButton(idV1GroupBox, "removeV1PushButton");
	removeV1PushButton->setText(i18n("Remove"));
	idV1GroupBoxLayout->addWidget(removeV1PushButton, 4, 2);

	commentV1CheckBox = new QCheckBox(idV1GroupBox, "commentV1CheckBox");
	commentV1CheckBox->setText(i18n("Comment:"));
	idV1GroupBoxLayout->addWidget(commentV1CheckBox, 3, 0);

	commentV1LineEdit = new QLineEdit(idV1GroupBox, "commentV1LineEdit");
	commentV1LineEdit->setMaxLength(29);
	idV1GroupBoxLayout->addWidget(commentV1LineEdit, 3, 1);

	pasteV1PushButton = new QPushButton(idV1GroupBox, "pasteV1PushButton");
	pasteV1PushButton->setText(i18n("Paste"));
	idV1GroupBoxLayout->addWidget(pasteV1PushButton, 3, 2);

	yearV1CheckBox = new QCheckBox(idV1GroupBox, "yearV1CheckBox");
	yearV1CheckBox->setText(i18n("Year:"));
	idV1GroupBoxLayout->addWidget(yearV1CheckBox, 4, 0);

	trackV1HBox = new QHBox(idV1GroupBox, "trackV1HBox");
	trackV1HBox->setSpacing(6);
	yearV1SpinBox = new QSpinBox(trackV1HBox, "yearV1SpinBox");
	yearV1SpinBox->setMaxValue(9999);
	trackV1CheckBox = new QCheckBox(trackV1HBox, "trackV1CheckBox");
	trackV1CheckBox->setText(i18n("Track:"));
	trackV1SpinBox = new QSpinBox(trackV1HBox, "trackV1SpinBox");
	trackV1SpinBox->setMaxValue(255);
	idV1GroupBoxLayout->addWidget(trackV1HBox, 4, 1);

	genreV1CheckBox = new QCheckBox(idV1GroupBox, "genreV1CheckBox");
	genreV1CheckBox->setText(i18n("Genre:"));
	idV1GroupBoxLayout->addWidget(genreV1CheckBox, 5, 0);

	genreV1ComboBox = new QComboBox(FALSE, idV1GroupBox, "genreV1ComboBox");
	idV1GroupBoxLayout->addWidget(genreV1ComboBox, 5, 1);

	idV2GroupBox = new QGroupBox(rightHalfVBox, "idV2GroupBox");
	idV2GroupBox->setTitle(i18n("ID3v&2.3"));

	idV2GroupBoxLayout = new QGridLayout(idV2GroupBox, 7, 3, 16, 6);
	idV2GroupBoxLayout->setAlignment(Qt::AlignTop);

	titleV2CheckBox = new QCheckBox(idV2GroupBox, "titleV2CheckBox");
	titleV2CheckBox->setText(i18n("Title:"));
	idV2GroupBoxLayout->addWidget(titleV2CheckBox, 0, 0);

	titleV2LineEdit = new QLineEdit(idV2GroupBox, "titleV2LineEdit");
	idV2GroupBoxLayout->addWidget(titleV2LineEdit, 0, 1);

	filenameV2PushButton = new QPushButton(idV2GroupBox,
										   "filenameV2PushButton");
	filenameV2PushButton->setText(i18n("From Filename"));
	idV2GroupBoxLayout->addWidget(filenameV2PushButton, 0, 2);

	artistV2CheckBox = new QCheckBox(idV2GroupBox, "artistV2CheckBox");
	artistV2CheckBox->setText(i18n("Artist:"));
	idV2GroupBoxLayout->addWidget(artistV2CheckBox, 1, 0);

	artistV2LineEdit = new QLineEdit(idV2GroupBox, "artistV2LineEdit");
	idV2GroupBoxLayout->addWidget(artistV2LineEdit, 1, 1);

	id3V2PushButton = new QPushButton(idV2GroupBox, "id3V2PushButton");
	id3V2PushButton->setText(i18n("From ID3v1"));
	idV2GroupBoxLayout->addWidget(id3V2PushButton, 1, 2);

	albumV2CheckBox = new QCheckBox(idV2GroupBox, "albumV2CheckBox");
	albumV2CheckBox->setText(i18n("Album:"));
	idV2GroupBoxLayout->addWidget(albumV2CheckBox, 2, 0);

	albumV2LineEdit = new QLineEdit(idV2GroupBox, "albumV2LineEdit");
	idV2GroupBoxLayout->addWidget(albumV2LineEdit, 2, 1);

	copyV2PushButton = new QPushButton(idV2GroupBox, "copyV2PushButton");
	copyV2PushButton->setText(i18n("Copy"));
	idV2GroupBoxLayout->addWidget(copyV2PushButton, 2, 2);

	commentV2CheckBox = new QCheckBox(idV2GroupBox, "commentV2CheckBox");
	commentV2CheckBox->setText(i18n("Comment:"));
	idV2GroupBoxLayout->addWidget(commentV2CheckBox, 3, 0);

	commentV2LineEdit = new QLineEdit(idV2GroupBox, "commentV2LineEdit");
	idV2GroupBoxLayout->addWidget(commentV2LineEdit, 3, 1);

	pasteV2PushButton = new QPushButton(idV2GroupBox, "pasteV2PushButton");
	pasteV2PushButton->setText(i18n("Paste"));
	idV2GroupBoxLayout->addWidget(pasteV2PushButton, 3, 2);

	yearV2CheckBox = new QCheckBox(idV2GroupBox, "yearV2CheckBox");
	yearV2CheckBox->setText(i18n("Year:"));
	idV2GroupBoxLayout->addWidget(yearV2CheckBox, 4, 0);

	trackV2HBox = new QHBox(idV2GroupBox, "trackV2HBox"); 
	trackV2HBox->setSpacing(6);
	yearV2SpinBox = new QSpinBox(trackV2HBox, "yearV2SpinBox");
	yearV2SpinBox->setMaxValue(9999);
	trackV2CheckBox = new QCheckBox(trackV2HBox, "trackV2CheckBox");
	trackV2CheckBox->setText(i18n("Track:"));
	trackV2SpinBox = new QSpinBox(trackV2HBox, "trackV2SpinBox");
	trackV2SpinBox->setMaxValue(999);
	idV2GroupBoxLayout->addWidget(trackV2HBox, 4, 1);

	removeV2PushButton = new QPushButton(idV2GroupBox, "removeV2PushButton");
	removeV2PushButton->setText(i18n("Remove"));
	idV2GroupBoxLayout->addWidget(removeV2PushButton, 4, 2);

	genreV2CheckBox = new QCheckBox(idV2GroupBox, "genreV2CheckBox");
	genreV2CheckBox->setText(i18n("Genre:"));
	idV2GroupBoxLayout->addWidget(genreV2CheckBox, 5, 0);

	genreV2ComboBox = new QComboBox(FALSE, idV2GroupBox, "genreV2ComboBox");
	idV2GroupBoxLayout->addWidget(genreV2ComboBox, 5, 1);

	framesTextLabel = new QLabel(idV2GroupBox, "framesTextLabel");
	framesTextLabel->setText(i18n("Frames:"));

	idV2GroupBoxLayout->addWidget(framesTextLabel, 6, 0);

	framesListBox = new QListBox(idV2GroupBox, "framesListBox");
	idV2GroupBoxLayout->addWidget(framesListBox, 6, 1);

	frameButtonVBox = new QVBox(idV2GroupBox, "frameButtonLayout"); 
	frameButtonVBox->setSpacing(6);
	editFramesPushButton = new QPushButton(frameButtonVBox,
										   "editFramesPushButton");
	editFramesPushButton->setText(i18n("Edit"));
	framesAddPushButton = new QPushButton(frameButtonVBox,
										  "framesAddPushButton");
	framesAddPushButton->setText(i18n("Add"));
	deleteFramesPushButton = new QPushButton(frameButtonVBox,
											 "deleteFramesPushButton");
	deleteFramesPushButton->setText(i18n("Delete"));

	idV2GroupBoxLayout->addWidget(frameButtonVBox, 6, 2);


	scrollView->addChild(rightHalfVBox);

	// signals and slots connections
	connect(filenameV1PushButton, SIGNAL(clicked()), this,
			SLOT(fromFilenameV1()));
	connect(id3V1PushButton, SIGNAL(clicked()), this, SLOT(fromID3V1()));
	connect(copyV1PushButton, SIGNAL(clicked()), this, SLOT(copyV1()));
	connect(pasteV1PushButton, SIGNAL(clicked()), this, SLOT(pasteV1()));
	connect(removeV1PushButton, SIGNAL(clicked()), this, SLOT(removeV1()));
	connect(filenameV2PushButton, SIGNAL(clicked()), this,
			SLOT(fromFilenameV2()));
	connect(id3V2PushButton, SIGNAL(clicked()), this, SLOT(fromID3V2()));
	connect(copyV2PushButton, SIGNAL(clicked()), this, SLOT(copyV2()));
	connect(pasteV2PushButton, SIGNAL(clicked()), this, SLOT(pasteV2()));
	connect(removeV2PushButton, SIGNAL(clicked()), this, SLOT(removeV2()));
	connect(mp3ListBox, SIGNAL(selectionChanged()), this,
			SLOT(fileSelected()));
	connect(framesListBox, SIGNAL(doubleClicked(QListBoxItem*)), this,
			SLOT(editFrame()));
	connect(framesListBox, SIGNAL(returnPressed(QListBoxItem*)), this,
			SLOT(editFrame()));
	connect(framesAddPushButton, SIGNAL(clicked()), this, SLOT(addFrame()));
	connect(deleteFramesPushButton, SIGNAL(clicked()), this,
			SLOT(deleteFrame()));
	connect(editFramesPushButton, SIGNAL(clicked()), this, SLOT(editFrame()));
	connect(fnV1Button, SIGNAL(clicked()), this, SLOT(fnFromID3V1()));
	connect(fnV2Button, SIGNAL(clicked()), this, SLOT(fnFromID3V2()));
	connect(nameLineEdit, SIGNAL(textChanged(const QString &)), this,
			SLOT(nameLineEditChanged(const QString &)));
	connect(albumV1LineEdit, SIGNAL(textChanged(const QString &)), this,
			SLOT(albumV1LineEditChanged(const QString &)));
	connect(artistV1LineEdit, SIGNAL(textChanged(const QString &)), this,
			SLOT(artistV1LineEditChanged(const QString &)));
	connect(titleV1LineEdit, SIGNAL(textChanged(const QString &)), this,
			SLOT(titleV1LineEditChanged(const QString &)));
	connect(albumV2LineEdit, SIGNAL(textChanged(const QString &)), this,
			SLOT(albumV2LineEditChanged(const QString &)));
	connect(artistV2LineEdit, SIGNAL(textChanged(const QString &)), this,
			SLOT(artistV2LineEditChanged(const QString &)));
	connect(titleV2LineEdit, SIGNAL(textChanged(const QString &)), this,
			SLOT(titleV2LineEditChanged(const QString &)));
	connect(m_dirListBox, SIGNAL(doubleClicked(QListBoxItem *)), this,
			SLOT(dirSelected(QListBoxItem *)));
	connect(m_dirListBox, SIGNAL(returnPressed(QListBoxItem *)), this,
			SLOT(dirSelected(QListBoxItem *)));

	// tab order
	setTabOrder(mp3ListBox, m_dirListBox);
	setTabOrder(m_dirListBox, filenameGroupBox);
	setTabOrder(filenameGroupBox, nameLineEdit);
	setTabOrder(nameLineEdit, formatComboBox);
	setTabOrder(formatComboBox, fnV1Button);
	setTabOrder(fnV1Button, fnV2Button);
	setTabOrder(fnV2Button, idV1GroupBox);
	setTabOrder(idV1GroupBox, titleV1CheckBox);
	setTabOrder(titleV1CheckBox, titleV1LineEdit);
	setTabOrder(titleV1LineEdit, artistV1CheckBox);
	setTabOrder(artistV1CheckBox, artistV1LineEdit);
	setTabOrder(artistV1LineEdit, albumV1CheckBox);
	setTabOrder(albumV1CheckBox, albumV1LineEdit);
	setTabOrder(albumV1LineEdit, commentV1CheckBox);
	setTabOrder(commentV1CheckBox, commentV1LineEdit);
	setTabOrder(commentV1LineEdit, yearV1CheckBox);
	setTabOrder(yearV1CheckBox, yearV1SpinBox);
	setTabOrder(yearV1SpinBox, trackV1CheckBox);
	setTabOrder(trackV1CheckBox, trackV1SpinBox);
	setTabOrder(trackV1SpinBox, genreV1CheckBox);
	setTabOrder(genreV1CheckBox, genreV1ComboBox);
	setTabOrder(genreV1ComboBox, filenameV1PushButton);
	setTabOrder(filenameV1PushButton, id3V1PushButton);
	setTabOrder(id3V1PushButton, copyV1PushButton);
	setTabOrder(copyV1PushButton, pasteV1PushButton);
	setTabOrder(pasteV1PushButton, removeV1PushButton);
	setTabOrder(removeV1PushButton, idV2GroupBox);
	setTabOrder(idV2GroupBox, titleV2CheckBox);
	setTabOrder(titleV2CheckBox, titleV2LineEdit);
	setTabOrder(titleV2LineEdit, artistV2CheckBox);
	setTabOrder(artistV2CheckBox, artistV2LineEdit);
	setTabOrder(artistV2LineEdit, albumV2CheckBox);
	setTabOrder(albumV2CheckBox, albumV2LineEdit);
	setTabOrder(albumV2LineEdit, commentV2CheckBox);
	setTabOrder(commentV2CheckBox, commentV2LineEdit);
	setTabOrder(commentV2LineEdit, yearV2CheckBox);
	setTabOrder(yearV2CheckBox, yearV2SpinBox);
	setTabOrder(yearV2SpinBox, trackV2CheckBox);
	setTabOrder(trackV2CheckBox, trackV2SpinBox);
	setTabOrder(trackV2SpinBox, genreV2CheckBox);
	setTabOrder(genreV2CheckBox, genreV2ComboBox);
	setTabOrder(genreV2ComboBox, filenameV2PushButton);
	setTabOrder(filenameV2PushButton, id3V2PushButton);
	setTabOrder(id3V2PushButton, copyV2PushButton);
	setTabOrder(copyV2PushButton, pasteV2PushButton);
	setTabOrder(pasteV2PushButton, removeV2PushButton);
	setTabOrder(removeV2PushButton, framesListBox);
	setTabOrder(framesListBox, framesAddPushButton);
	setTabOrder(framesAddPushButton, deleteFramesPushButton);

	// go to next line edit when pressing enter
	connect(titleV1LineEdit, SIGNAL(returnPressed()), artistV1LineEdit, SLOT(setFocus()));
	connect(artistV1LineEdit, SIGNAL(returnPressed()), albumV1LineEdit, SLOT(setFocus()));
	connect(albumV1LineEdit, SIGNAL(returnPressed()), commentV1LineEdit, SLOT(setFocus()));
	connect(commentV1LineEdit, SIGNAL(returnPressed()), yearV1SpinBox, SLOT(setFocus()));
	connect(titleV2LineEdit, SIGNAL(returnPressed()), artistV2LineEdit, SLOT(setFocus()));
	connect(artistV2LineEdit, SIGNAL(returnPressed()), albumV2LineEdit, SLOT(setFocus()));
	connect(albumV2LineEdit, SIGNAL(returnPressed()), commentV2LineEdit, SLOT(setFocus()));
	connect(commentV2LineEdit, SIGNAL(returnPressed()), yearV2SpinBox, SLOT(setFocus()));
}

/**
 * Button ID3v1 From Filename.
 */
void id3Form::fromFilenameV1()
{
	theApp->getTagsFromFilenameV1();
}

/**
 * Button ID3v2 From Filename.
 */
void id3Form::fromFilenameV2()
{
	theApp->getTagsFromFilenameV2();
}

/**
 * Button ID3v2 From ID3v1.
 */
void id3Form::fromID3V2()
{
	theApp->copyV1ToV2();
}

/**
 * Button ID3v1 From ID3v2.
 */
void id3Form::fromID3V1()
{
	theApp->copyV2ToV1();
}

/**
 * Button ID3v1 Copy.
 */
void id3Form::copyV1()
{
	StandardTags st;
	getStandardTagsV1(&st);
	theApp->copyTags(&st);
}

/**
 * Button ID3v2 Copy.
 */
void id3Form::copyV2()
{
	StandardTags st;
	getStandardTagsV2(&st);
	theApp->copyTags(&st);
}

/**
 * Button ID3v2 Remove.
 */
void id3Form::removeV2()
{
	theApp->removeTagsV2();
}

/**
 * Button ID3v1 Paste.
 */
void id3Form::pasteV1()
{
	theApp->pasteTagsV1();
}

/**
 * Button ID3v2 Paste.
 */
void id3Form::pasteV2()
{
	theApp->pasteTagsV2();
}

/**
 * Button ID3v1 Remove.
 */
void id3Form::removeV1()
{
	theApp->removeTagsV1();
}

/**
 * File list box file selected
 */
void id3Form::fileSelected(void)
{
	theApp->fileSelected();
}

/**
 * Get standard tags from the ID3v1 controls.
 *
 * @param st standard tags to store result
 */
void id3Form::getStandardTagsV1(StandardTags *st)
{
	st->title   = titleV1CheckBox->isChecked()   ? titleV1LineEdit->text()
		: QString::null;
	st->artist  = artistV1CheckBox->isChecked()  ? artistV1LineEdit->text()
		: QString::null;
	st->album   = albumV1CheckBox->isChecked()   ? albumV1LineEdit->text()
		: QString::null;
	st->comment = commentV1CheckBox->isChecked() ? commentV1LineEdit->text()
		: QString::null;
	st->year = yearV1CheckBox->isChecked()       ? yearV1SpinBox->value()
		: -1;
	st->track   = trackV1CheckBox->isChecked()   ? trackV1SpinBox->value()
		: -1;
	st->genre   = genreV1CheckBox->isChecked()   ?
		Genres::getNumber(genreV1ComboBox->currentItem()) : -1;
}

/**
 * Get standard tags from the ID3v2 controls.
 *
 * @param st standard tags to store result
 */
void id3Form::getStandardTagsV2(StandardTags *st)
{
	st->title   = titleV2CheckBox->isChecked()   ? titleV2LineEdit->text()
		: QString::null;
	st->artist  = artistV2CheckBox->isChecked()  ? artistV2LineEdit->text()
		: QString::null;
	st->album   = albumV2CheckBox->isChecked()   ? albumV2LineEdit->text()
		: QString::null;
	st->comment = commentV2CheckBox->isChecked() ? commentV2LineEdit->text()
		: QString::null;
	st->year    = yearV2CheckBox->isChecked()    ? yearV2SpinBox->value()
		: -1;
	st->track   = trackV2CheckBox->isChecked()   ? trackV2SpinBox->value()
		: -1;
	st->genre   = genreV2CheckBox->isChecked()   ?
		genreV2ComboBox->currentItem() - 1 : -1;
	st->genre   = genreV2CheckBox->isChecked()   ?
		Genres::getNumber(genreV2ComboBox->currentItem()) : -1;
}

/**
 * Set ID3v1 standard tags controls.
 *
 * @param st standard tags to set
 */
void id3Form::setStandardTagsV1(const StandardTags *st)
{
	titleV1CheckBox->setChecked(!st->title.isNull());
	titleV1LineEdit->setText(st->title);
	artistV1CheckBox->setChecked(!st->artist.isNull());
	artistV1LineEdit->setText(st->artist);
	albumV1CheckBox->setChecked(!st->album.isNull());
	albumV1LineEdit->setText(st->album);
	commentV1CheckBox->setChecked(!st->comment.isNull());
	commentV1LineEdit->setText(st->comment);
	yearV1CheckBox->setChecked(st->year >= 0);
	yearV1SpinBox->setValue(st->year >= 0 ? st->year : 0);
	trackV1CheckBox->setChecked(st->track >= 0);
	trackV1SpinBox->setValue(st->track >= 0 ? st->track : 0);
	genreV1CheckBox->setChecked(st->genre >= 0);
	genreV1ComboBox->setCurrentItem(st->genre >= 0 ?
									Genres::getIndex(st->genre) : 0);
}

/**
 * Set ID3v2 standard tags controls.
 *
 * @param st standard tags to set
 */
void id3Form::setStandardTagsV2(const StandardTags *st)
{
	titleV2CheckBox->setChecked(!st->title.isNull());
	titleV2LineEdit->setText(st->title);
	artistV2CheckBox->setChecked(!st->artist.isNull());
	artistV2LineEdit->setText(st->artist);
	albumV2CheckBox->setChecked(!st->album.isNull());
	albumV2LineEdit->setText(st->album);
	commentV2CheckBox->setChecked(!st->comment.isNull());
	commentV2LineEdit->setText(st->comment);
	yearV2CheckBox->setChecked(st->year >= 0);
	yearV2SpinBox->setValue(st->year >= 0 ? st->year : 0);
	trackV2CheckBox->setChecked(st->track >= 0);
	trackV2SpinBox->setValue(st->track >= 0 ? st->track : 0);
	genreV2CheckBox->setChecked(st->genre >= 0);
	genreV2ComboBox->setCurrentItem(st->genre >= 0 ?
									Genres::getIndex(st->genre) : 0);
}

/**
 * Set all ID3v1 and ID3v2 check boxes on or off.
 *
 * @param val TRUE to set check boxes on.
 */
void id3Form::setAllCheckBoxes(bool val)
{
	titleV1CheckBox->setChecked(val);
	artistV1CheckBox->setChecked(val);
	albumV1CheckBox->setChecked(val);
	commentV1CheckBox->setChecked(val);
	yearV1CheckBox->setChecked(val);
	trackV1CheckBox->setChecked(val);
	genreV1CheckBox->setChecked(val);
	
	titleV2CheckBox->setChecked(val);
	artistV2CheckBox->setChecked(val);
	albumV2CheckBox->setChecked(val);
	commentV2CheckBox->setChecked(val);
	yearV2CheckBox->setChecked(val);
	trackV2CheckBox->setChecked(val);
	genreV2CheckBox->setChecked(val);
}

/**
 * Get number of files selected in file list box.
 *
 * @return number of files selected.
 */
int id3Form::numFilesSelected()
{
	int i, num_files_selected = 0;
	for (i = 0; i < (int)mp3ListBox->count(); i++) {
		if (mp3ListBox->isSelected(i)) {
			++num_files_selected;
		}
	}
	return num_files_selected;
}

/**
 * Accept drag.
 *
 * @param ev drag event.
 */
void id3Form::dragEnterEvent(QDragEnterEvent *ev)
{
	ev->accept(QTextDrag::canDecode(ev));
}

/**
 * Handle drop event.
 *
 * @param ev drop event.
 */
void id3Form::dropEvent(QDropEvent *ev)
{
	QString text;
	if (QTextDrag::decode(ev, text)) {
		theApp->openDrop(text);
	}
}

/**
 * Frame list button Edit.
 */
void id3Form::editFrame(void)
{
	theApp->editFrame();
}

/**
 * Frame list button Add.
 */
void id3Form::addFrame(void)
{
	theApp->addFrame();
}

/**
 * Frame list button Delete.
 */
void id3Form::deleteFrame(void)
{
	theApp->deleteFrame();
}

/**
 * Set filename according to ID3v1 tags.
 */

void id3Form::fnFromID3V1(void)
{
	theApp->getFilenameFromTags(1);
}

/**
 * Set filename according to ID3v1 tags.
 */

void id3Form::fnFromID3V2(void)
{
	theApp->getFilenameFromTags(2);
}

/**
 * Filename line edit is changed.
 * @param contents of line edit
 */
void id3Form::nameLineEditChanged(const QString &txt)
{
	formatLineEdit(nameLineEdit, txt, theApp->fnFormatCfg);
}

/**
 * Album V1 line edit is changed.
 * @param contents of line edit
 */
void id3Form::albumV1LineEditChanged(const QString &txt)
{
	formatLineEdit(albumV1LineEdit, txt, theApp->id3FormatCfg);
}

/**
 * Artist V1 line edit is changed.
 * @param contents of line edit
 */
void id3Form::artistV1LineEditChanged(const QString &txt)
{
	formatLineEdit(artistV1LineEdit, txt, theApp->id3FormatCfg);
}

/**
 * Title V1 line edit is changed.
 * @param contents of line edit
 */
void id3Form::titleV1LineEditChanged(const QString &txt)
{
	formatLineEdit(titleV1LineEdit, txt, theApp->id3FormatCfg);
}

/**
 * Album V2 line edit is changed.
 * @param contents of line edit
 */
void id3Form::albumV2LineEditChanged(const QString &txt)
{
	formatLineEdit(albumV2LineEdit, txt, theApp->id3FormatCfg);
}

/**
 * Artist V2 line edit is changed.
 * @param contents of line edit
 */
void id3Form::artistV2LineEditChanged(const QString &txt)
{
	formatLineEdit(artistV2LineEdit, txt, theApp->id3FormatCfg);
}

/**
 * Title V2 line edit is changed.
 * @param contents of line edit
 */
void id3Form::titleV2LineEditChanged(const QString &txt)
{
	formatLineEdit(titleV2LineEdit, txt, theApp->id3FormatCfg);
}

/**
 * Format string within line edit.
 *
 * @param le   line edit
 * @param txt  text in line edit
 * @param fcfg format configuration
 */
void id3Form::formatLineEdit(QLineEdit *le, const QString &txt,
							 const FormatConfig *fcfg)
{
	if (theApp->miscCfg->formatWhileEditing) {
		QString str(txt);
		fcfg->formatString(str);
		if (str != txt) {
			int curPos = le->cursorPosition();
			le->setText(str);
			le->setCursorPosition(curPos);
		}
	}
}

/**
 * Directory list box directory selected.
 *
 * @param item selected item
 */
void id3Form::dirSelected(QListBoxItem* item) {
	QDir dir(m_dirListBox->getDirname() + QDir::separator() +
					 item->text());
	QString dirPath = dir.absPath();
	if (!dirPath.isEmpty()) {
		theApp->openDirectory(dirPath, true);
	}
}

/**
 * Get filter from ID3v1 check boxes.
 *
 * @return filter.
 */
StandardTagsFilter id3Form::getFilterFromID3V1()
{
	StandardTagsFilter flt;
	flt.m_enableTitle   = titleV1CheckBox->isChecked();
	flt.m_enableArtist  = artistV1CheckBox->isChecked();
	flt.m_enableAlbum   = albumV1CheckBox->isChecked();
	flt.m_enableComment = commentV1CheckBox->isChecked();
	flt.m_enableYear    = yearV1CheckBox->isChecked();
	flt.m_enableTrack   = trackV1CheckBox->isChecked();
	flt.m_enableGenre   = genreV1CheckBox->isChecked();
	flt.allFalseToAllTrue();
	return flt;
}

/**
 * Get filter from ID3v2 check boxes.
 *
 * @return filter.
 */
StandardTagsFilter id3Form::getFilterFromID3V2()
{
	StandardTagsFilter flt;
	flt.m_enableTitle   = titleV2CheckBox->isChecked();
	flt.m_enableArtist  = artistV2CheckBox->isChecked();
	flt.m_enableAlbum   = albumV2CheckBox->isChecked();
	flt.m_enableComment = commentV2CheckBox->isChecked();
	flt.m_enableYear    = yearV2CheckBox->isChecked();
	flt.m_enableTrack   = trackV2CheckBox->isChecked();
	flt.m_enableGenre   = genreV2CheckBox->isChecked();
	flt.allFalseToAllTrue();
	return flt;
}

/**
 * Enable or disable controls requiring ID3v1 tags.
 *
 * @param enable true to enable
 */
void id3Form::enableControlsV1(bool enable)
{
	fnV1Button->setEnabled(enable);
	id3V2PushButton->setEnabled(enable);
	idV1GroupBox->setEnabled(enable);
}
