"""Unit Tests for the XML comments."""

__revision__ = "$Rev: 217 $"
__author__ = "David Stanek <dstanek@dstanek.com>"
__copyright__ = "Copyright 2005, David Stanek"

import os
import py
import kid

tmpdir = py.test.ensuretemp("test_comments")
kid.path.paths.insert(0, str(tmpdir))
tfile0 = tmpdir.join("layout.kid")
tfile0.write("""
    <html xmlns:py="http://purl.org/kid/ns#">
        <body py:match="item.tag == 'body'">
            parent
            <p align="center" py:replace="item[:]">
                ... content will be inserted here ...
            </p>
        </body>
    </html>
""")
tfile1 = tmpdir.join("page.kid")
tfile1.write("""
    <html py:extends="'layout.kid'" xmlns:py="http://purl.org/kid/ns#">
        <body>
            <!-- a comment -->
            <p>my content</p>
        </body>
    </html>
""")

def test_comments_in_extend():
    """Test for the bug that was reported in ticket #66.

    I wanted to make two tests one using the KID_NOCET variable and
    one without.
    # XXX: get that to work
    """
    t = kid.Template(file="page.kid")
    t.serialize()
