/////////////////////////////////////////////////////////////////////////////
// Name:        dialog_eeschema_config.cpp
// Purpose:
// Author:      jean-pierre Charras
// Modified by:
// Created:     17/02/2006 21:14:46
// RCS-ID:
// Copyright:   License GNU
// Licence:
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 17/02/2006 21:14:46

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma implementation "dialog_eeschema_config.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes
#include "fctsys.h"

#include "common.h"
#include "program.h"
#include "libcmp.h"
#include "general.h"

#include "protos.h"
#include "netlist.h"

#include "id.h"

#include "dialog_eeschema_config.h"

////@begin XPM images
////@end XPM images

/******************************************************************/
void WinEDA_SchematicFrame::InstallConfigFrame(const wxPoint & pos)
/******************************************************************/
{
	KiConfigEeschemaFrame * CfgFrame = new KiConfigEeschemaFrame(this);
	CfgFrame->ShowModal(); CfgFrame->Destroy();
}


/*!
 * KiConfigEeschemaFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( KiConfigEeschemaFrame, wxDialog )

/*!
 * KiConfigEeschemaFrame event table definition
 */

BEGIN_EVENT_TABLE( KiConfigEeschemaFrame, wxDialog )

////@begin KiConfigEeschemaFrame event table entries
    EVT_CLOSE( KiConfigEeschemaFrame::OnCloseWindow )

    EVT_BUTTON( SAVE_CFG, KiConfigEeschemaFrame::OnSaveCfgClick )

    EVT_LISTBOX( FORMAT_NETLIST, KiConfigEeschemaFrame::OnFormatNetlistSelected )

    EVT_BUTTON( REMOVE_LIB, KiConfigEeschemaFrame::OnRemoveLibClick )

    EVT_BUTTON( ADD_LIB, KiConfigEeschemaFrame::OnAddLibClick )

    EVT_BUTTON( INSERT_LIB, KiConfigEeschemaFrame::OnInsertLibClick )

    EVT_BUTTON( ID_LIB_PATH_SEL, KiConfigEeschemaFrame::OnLibPathSelClick )

////@end KiConfigEeschemaFrame event table entries

END_EVENT_TABLE()

/*!
 * KiConfigEeschemaFrame constructors
 */

KiConfigEeschemaFrame::KiConfigEeschemaFrame( )
{
}

KiConfigEeschemaFrame::KiConfigEeschemaFrame( WinEDA_SchematicFrame* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
wxString msg;

	m_Parent = parent;
	m_LibListChanged = FALSE;

    Create(parent, id, caption, pos, size, style);

	msg = _("from ") + g_EDA_Appl->m_CurrentOptionFile;
	SetTitle(msg);
	SetFormatsNetListes();
	m_ListLibr->InsertItems(g_LibName_List, 0);
	m_LibDirCtrl->SetValue( g_UserLibDirBuffer );
}

/*!
 * KiConfigEeschemaFrame creator
 */

bool KiConfigEeschemaFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin KiConfigEeschemaFrame member initialisation
    m_NetFormatBox = NULL;
    m_FileExtList = NULL;
    m_ListLibr = NULL;
    m_LibDirCtrl = NULL;
////@end KiConfigEeschemaFrame member initialisation

////@begin KiConfigEeschemaFrame creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end KiConfigEeschemaFrame creation
    return true;
}

/*!
 * Control creation for KiConfigEeschemaFrame
 */

void KiConfigEeschemaFrame::CreateControls()
{
	SetFont(*g_DialogFont);

////@begin KiConfigEeschemaFrame content construction
    // Generated by DialogBlocks, 10/11/2007 16:00:50 (unregistered)

    KiConfigEeschemaFrame* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer3, 1, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer4, 0, wxGROW|wxALL, 5);

    wxButton* itemButton5 = new wxButton( itemDialog1, SAVE_CFG, _("Save Cfg"), wxDefaultPosition, wxDefaultSize, 0 );
    if (KiConfigEeschemaFrame::ShowToolTips())
        itemButton5->SetToolTip(_("save current configuration setting in the local .pro file"));
    itemButton5->SetForegroundColour(wxColour(204, 0, 0));
    itemBoxSizer4->Add(itemButton5, 0, wxGROW|wxALL, 5);

    itemBoxSizer4->Add(5, 5, 0, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText7 = new wxStaticText( itemDialog1, wxID_STATIC, _("NetList Formats:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer4->Add(itemStaticText7, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP, 5);

    wxArrayString m_NetFormatBoxStrings;
    m_NetFormatBox = new wxListBox( itemDialog1, FORMAT_NETLIST, wxDefaultPosition, wxDefaultSize, m_NetFormatBoxStrings, wxLB_SINGLE );
    itemBoxSizer4->Add(m_NetFormatBox, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    itemBoxSizer4->Add(5, 5, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer10Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Files ext:"));
    m_FileExtList = new wxStaticBoxSizer(itemStaticBoxSizer10Static, wxVERTICAL);
    itemBoxSizer4->Add(m_FileExtList, 0, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer11 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer11, 1, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxBoxSizer* itemBoxSizer12 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer11->Add(itemBoxSizer12, 1, wxGROW, 5);

    wxBoxSizer* itemBoxSizer13 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer12->Add(itemBoxSizer13, 0, wxGROW|wxALL, 5);

    wxButton* itemButton14 = new wxButton( itemDialog1, REMOVE_LIB, _("Remove"), wxDefaultPosition, wxDefaultSize, 0 );
    if (KiConfigEeschemaFrame::ShowToolTips())
        itemButton14->SetToolTip(_("Unload the selected library"));
    itemButton14->SetForegroundColour(wxColour(204, 0, 0));
    itemBoxSizer13->Add(itemButton14, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton15 = new wxButton( itemDialog1, ADD_LIB, _("Add"), wxDefaultPosition, wxDefaultSize, 0 );
    if (KiConfigEeschemaFrame::ShowToolTips())
        itemButton15->SetToolTip(_("Add a new library after the selected library, add load it"));
    itemButton15->SetForegroundColour(wxColour(0, 128, 0));
    itemBoxSizer13->Add(itemButton15, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton16 = new wxButton( itemDialog1, INSERT_LIB, _("Ins"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton16->SetHelpText(_("Add a new library beforer the selected library, add load it"));
    if (KiConfigEeschemaFrame::ShowToolTips())
        itemButton16->SetToolTip(_("Add a new library beforer the selected library, add load it"));
    itemButton16->SetForegroundColour(wxColour(0, 0, 255));
    itemBoxSizer13->Add(itemButton16, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer17 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer12->Add(itemBoxSizer17, 1, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText18 = new wxStaticText( itemDialog1, wxID_STATIC, _("Libraries"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticText18->SetForegroundColour(wxColour(204, 0, 0));
    itemBoxSizer17->Add(itemStaticText18, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);

    wxArrayString m_ListLibrStrings;
    m_ListLibr = new wxListBox( itemDialog1, ID_LISTBOX, wxDefaultPosition, wxDefaultSize, m_ListLibrStrings, wxLB_SINGLE );
    itemBoxSizer17->Add(m_ListLibr, 1, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM|wxADJUST_MINSIZE, 5);

    wxStaticBox* itemStaticBoxSizer20Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Default library file path:"));
    wxStaticBoxSizer* itemStaticBoxSizer20 = new wxStaticBoxSizer(itemStaticBoxSizer20Static, wxHORIZONTAL);
    itemStaticBoxSizer20Static->SetForegroundColour(wxColour(206, 0, 0));
    itemBoxSizer2->Add(itemStaticBoxSizer20, 0, wxGROW|wxALL, 5);

    m_LibDirCtrl = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    if (KiConfigEeschemaFrame::ShowToolTips())
        m_LibDirCtrl->SetToolTip(_("Default path to search libraries which have no absolute path in name,\nor a name which does not start by ./ or ../\nIf void, the default path is kicad/library"));
    itemStaticBoxSizer20->Add(m_LibDirCtrl, 1, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxButton* itemButton22 = new wxButton( itemDialog1, ID_LIB_PATH_SEL, _("Browse"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticBoxSizer20->Add(itemButton22, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

////@end KiConfigEeschemaFrame content construction

wxString msg = _("Cmp file Ext: ") + g_NetCmpExtBuffer;
    wxStaticText * text = new wxStaticText( itemDialog1, -1, msg, wxDefaultPosition, wxDefaultSize, 0 );
    m_FileExtList->Add(text, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);

	msg = _("Net file Ext: ") + g_NetExtBuffer;
    text = new wxStaticText( itemDialog1, -1, msg, wxDefaultPosition, wxDefaultSize, 0 );
    m_FileExtList->Add(text, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);

	msg = _("Library file Ext: ") + g_LibExtBuffer;
    text = new wxStaticText( itemDialog1, -1, msg, wxDefaultPosition, wxDefaultSize, 0 );
    m_FileExtList->Add(text, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);

	msg = _("Symbol file Ext: ") + g_SymbolExtBuffer;
    text = new wxStaticText( itemDialog1, -1, msg, wxDefaultPosition, wxDefaultSize, 0 );
    m_FileExtList->Add(text, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);

	msg = _("Schematic file Ext: ") + g_SchExtBuffer;
    text = new wxStaticText( itemDialog1, -1, msg, wxDefaultPosition, wxDefaultSize, 0 );
    m_FileExtList->Add(text, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);

    wxArrayString NetlistNameItems;
    NetlistNameItems.Add(wxT("Pcbnew"));
    NetlistNameItems.Add(wxT("OrcadPcb2"));
    NetlistNameItems.Add(wxT("CadStar"));
    NetlistNameItems.Add(wxT("Spice"));
    msg = ReturnUserNetlistTypeName( true );
    while ( ! msg.IsEmpty() )
    {
        NetlistNameItems.Add(msg);
        msg = ReturnUserNetlistTypeName( false );
    }
    m_NetFormatBox->InsertItems(NetlistNameItems, 0);
}

/*!
 * Should we show tooltips?
 */

bool KiConfigEeschemaFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap KiConfigEeschemaFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin KiConfigEeschemaFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end KiConfigEeschemaFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon KiConfigEeschemaFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin KiConfigEeschemaFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end KiConfigEeschemaFrame icon retrieval
}



/**************************************************************/
void KiConfigEeschemaFrame::OnCloseWindow(wxCloseEvent & event)
/**************************************************************/
{
	ChangeSetup();
	if ( m_LibListChanged )
	{
		LoadLibraries(m_Parent);
		if ( m_Parent->m_Parent->m_ViewlibFrame )
			m_Parent->m_Parent->m_ViewlibFrame->ReCreateListLib();
	}
	EndModal(0);
}


/*********************************************/
void KiConfigEeschemaFrame::ChangeSetup()
/*********************************************/
{
	g_UserLibDirBuffer = m_LibDirCtrl->GetValue();
	SetRealLibraryPath( wxT("library") );
}



/********************************************************/
void KiConfigEeschemaFrame::LibDelFct(wxCommandEvent& event)
/********************************************************/
{
int ii;

	ii = m_ListLibr->GetSelection();
	if ( ii < 0 ) return;

	g_LibName_List.RemoveAt(ii);
	m_ListLibr->Clear();
	m_ListLibr->InsertItems(g_LibName_List, 0);
	m_LibListChanged = TRUE;
}

/****************************************************************/
void KiConfigEeschemaFrame::AddOrInsertLibrary(wxCommandEvent& event)
/****************************************************************/
/* Insert or add a library to the existing library list:
	New library is put in list before (insert) or after (add)
	the selection
*/
{
int ii;
wxString FullLibName,ShortLibName, Mask;

	ii = m_ListLibr->GetSelection();
	if ( ii < 0 ) ii = 0;
	ChangeSetup();
	if( event.GetId() == ADD_LIB)
	{
		if( g_LibName_List.GetCount() != 0 ) ii ++;	/* Add after selection */
	}

	Mask = wxT("*") + g_LibExtBuffer;

	wxFileDialog FilesDialog(this, _("Library files:"), g_RealLibDirBuffer,
		wxEmptyString, Mask,
		wxFD_DEFAULT_STYLE | wxFD_MULTIPLE);

	FilesDialog.ShowModal();
	wxArrayString Filenames;
	FilesDialog.GetPaths(Filenames);

	for ( unsigned jj = 0; jj < Filenames.GetCount(); jj ++ )
	{
		FullLibName = Filenames[jj];
		ShortLibName = MakeReducedFileName(FullLibName,g_RealLibDirBuffer,g_LibExtBuffer);
		if ( ShortLibName.IsEmpty() )	//Just in case...
			continue;
		//Add or insert new library name
		if (FindLibrary(ShortLibName) == NULL)
		{
			m_LibListChanged = TRUE;
			g_LibName_List.Insert(ShortLibName, ii);
			m_ListLibr->Clear();
			m_ListLibr->InsertItems(g_LibName_List, 0);
		}

		else
		{
			wxString msg;
			msg << wxT("<") << ShortLibName << wxT("> : ") << _("Library already in use");
			DisplayError(this, msg);
		}
	}

}



/****************************************************/
void KiConfigEeschemaFrame::SetFormatsNetListes()
/****************************************************/
/* Adjust the m_NetFormatBox current selection, according to the current netlist format*/

{
	if ( g_NetFormat > (int)m_NetFormatBox->GetCount() )
		g_NetFormat = NET_TYPE_PCBNEW;
	m_NetFormatBox->SetSelection(g_NetFormat - NET_TYPE_PCBNEW);
}

/*!
 * wxEVT_COMMAND_NETLIST_SELECTED event handler for FORMAT_NETLIST
 */

void KiConfigEeschemaFrame::OnFormatNetlistSelected( wxCommandEvent& event )
{
	g_NetFormat = m_NetFormatBox->GetSelection() + NET_TYPE_PCBNEW;
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for DEL_LIB
 */

void KiConfigEeschemaFrame::OnRemoveLibClick( wxCommandEvent& event )
{
	LibDelFct(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ADD_LIB
 */

void KiConfigEeschemaFrame::OnAddLibClick( wxCommandEvent& event )
{
	AddOrInsertLibrary(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for INSERT_LIB
 */

void KiConfigEeschemaFrame::OnInsertLibClick( wxCommandEvent& event )
{
	AddOrInsertLibrary(event);
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for SAVE_CFG
 */

void KiConfigEeschemaFrame::OnSaveCfgClick( wxCommandEvent& event )
{
	ChangeSetup();
	m_Parent->Save_Config(this);
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_LIB_PATH_SEL
 */

void KiConfigEeschemaFrame::OnLibPathSelClick( wxCommandEvent& event )
{
wxString path = g_RealLibDirBuffer;

bool select = EDA_DirectorySelector(_(" Default Path for libraries"),		/* Titre de la fenetre */
					path,			/* Chemin par defaut */
					wxDD_DEFAULT_STYLE,
					this,	/* parent frame */
					wxDefaultPosition);

	if ( !select ) return;

	m_LibDirCtrl->SetValue(path);

}


