/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "passworditem.h"

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

PasswordItem::PasswordItem(const QString &group, const QString &key, QString &ref)
    : KCoreConfigSkeleton::ItemString(group, key, ref),
      m_wallet(0),
      m_reference(ref),
      m_default(QString())
{
    m_wallet = new Wallet();
}

// ------------------------------------------------------------------------------------------------------------------- //

PasswordItem::~PasswordItem()
{
    if (m_wallet)
        delete m_wallet;
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Public methods reimplemented from KCoreConfigSkeleton                                                            //
// ------------------------------------------------------------------------------------------------------------------- //

void PasswordItem::readConfig(KConfig *config)
{
    KConfigGroup cg(config, mGroup);
    this->readImmutability(cg);

    m_reference = m_wallet->readPassword();
}

// ------------------------------------------------------------------------------------------------------------------- //

void PasswordItem::readDefault(KConfig*)
{
}

// ------------------------------------------------------------------------------------------------------------------- //

void PasswordItem::setDefault()
{
    m_reference = m_default;
}

// ------------------------------------------------------------------------------------------------------------------- //

void PasswordItem::swapDefault()
{
    QString tmp;
    tmp = m_reference;
    m_reference = m_default;
    m_default = tmp;
}

// ------------------------------------------------------------------------------------------------------------------- //

void PasswordItem::writeConfig(KConfig *)
{
    if (!this->isImmutable())
        m_wallet->writePassword(m_reference);
}

// ------------------------------------------------------------------------------------------------------------------- //
